package cn.mangofanfan.fanwindow.mixin.client;

import cn.mangofanfan.fanwindow.client.config.BgPicture;
import cn.mangofanfan.fanwindow.client.function.RenderBackground;
import cn.mangofanfan.fanwindow.client.screen.ConfigManager;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_437.class)
public abstract class ScreenMixin extends class_362 implements class_4068 {

    @Inject(method = "renderPanoramaBackground", at = @At("HEAD"), cancellable = true)
    private void onRenderBackground(CallbackInfo ci,
                                    @Local(argsOnly = true) class_332 context,
                                    @Local(argsOnly = true) float deltaTicks) {
        class_310 client = class_310.method_1551();
        ConfigManager configManager = ConfigManager.getInstance();
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        if (client.field_1687 == null) {
            Logger logger = LoggerFactory.getLogger("ScreenMixin");
            logger.trace("ScreenMixin is ready to change global background.");
            if (configManager.config.isUseNewBackgroundGlobally()) {
                BgPicture bgPicture = configManager.config.getBgPicture();
                int[] textureSize = bgPicture.getPicSize();
                class_2960 bgTexture = class_2960.method_60655("fanwindow", bgPicture.getPath());
                RenderBackground.renderBackground(context, textureSize, width, height, bgTexture);
                logger.trace("ScreenMixin background has been rendered.");
                ci.cancel();
            }
            else {
                logger.trace("According to config, ScreenMixin return.");
            }
        }
    }

}
