package cn.mangofanfan.fanwindow.client.screen;

import cn.mangofanfan.fanwindow.client.GlobalState;
import cn.mangofanfan.fanwindow.client.config.ConfigManager;
import cn.mangofanfan.fanwindow.client.function.VersionedRenderImpl;
import cn.mangofanfan.fanwindow.client.function.SimpleToastBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4189;
import net.minecraft.class_426;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4749;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_8020;
import net.minecraft.class_8082;
import net.minecraft.class_8219;
import net.minecraft.class_8662;

public class NewTitleScreen extends class_437 {
    // 定位点
    private int cenX;
    private int cenY;

    private final class_8020 logoDrawer;
    ConfigManager configManager;
    SimpleToastBuilder toastBuilder;

    // 单人游戏
    private volatile class_4185 singlePlayerButton;
    // 多人游戏
    private volatile class_4185 multiPlayerButton;
    // 选项
    private volatile class_4185 optionsButton;
    // 退出
    private volatile class_4185 quitButton;
    // 切换按钮
    private volatile class_4185 toggleButton;
    // 语言
    private volatile class_4185 languageOrReplayButton;
    // 无障碍
    private volatile class_8662 accessibilityOptionButton;
    // 版权
    private volatile class_4185 copyrightButton;
    // 设置按钮 或 模组菜单按钮
    private volatile class_4185 modsButton;

    private final GlobalState globalState;
    private static final Logger logger = LoggerFactory.getLogger(NewTitleScreen.class);
    private static final class_310 client = class_310.method_1551();

    public NewTitleScreen(class_2561 title) {
        super(title);
        globalState = GlobalState.getInstance();
        logoDrawer = new class_8020(false);
        configManager = ConfigManager.getInstance();
        toastBuilder = new SimpleToastBuilder();
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        cenX = field_22789 - 160;
        cenY = field_22790 - 160;

        this.singlePlayerButton = class_4185.method_46430(class_2561.method_43471("menu.singleplayer"),
                button -> field_22787.method_1507(new class_526(this)))
                .method_46434(cenX, cenY, 60, 60)
                .method_46431();
        this.multiPlayerButton = class_4185.method_46430(class_2561.method_43471("menu.multiplayer"),
                button -> {
                    class_437 screen = field_22787.field_1690.field_21840 ? new class_500(this) : new class_4749(this);
                    field_22787.method_1507(screen);
                })
                .method_46434(cenX + 65, cenY, 60, 60)
                .method_46431();
        this.optionsButton = class_4185.method_46430(class_2561.method_43471("menu.options"),
                button -> field_22787.method_1507(new class_429(this, field_22787.field_1690)))
                .method_46434(cenX, cenY + 65, 60, 60)
                .method_46431();
        this.quitButton = class_4185.method_46430(class_2561.method_43471("menu.quit"),
                button -> {
                    if (configManager.config.isExitMinecraftConfirm())
                        field_22787.method_1507(new ExitConfirmScreen(class_2561.method_30163("T-T")));
                    else
                        field_22787.method_1592();
                })
                .method_46434(cenX + 65, cenY + 65, 60, 60)
                .method_46431();
        this.toggleButton = this.getToggleButtonBuilder()
                .method_46434(cenX + 130, cenY, 27, 27)
                .method_46431();
        this.languageOrReplayButton = this.getLanguageOrReplayButton();
        this.languageOrReplayButton.method_53533(27);
        this.languageOrReplayButton.method_48229(cenX + 130, cenY + 33);
        this.accessibilityOptionButton = class_8082.method_48594(27,
                button -> field_22787.method_1507(new class_4189(this, field_22787.field_1690)),
                true);
        this.accessibilityOptionButton.method_53533(27);
        this.accessibilityOptionButton.method_48229(cenX + 130, cenY + 65);
        this.copyrightButton = class_4185.method_46430(class_2561.method_30163("©"),
                button -> field_22787.method_1507(new class_8219(this)))
                .method_46434(cenX + 130, cenY + 98, 27, 27)
                .method_46431();

        this.method_37063(singlePlayerButton);
        this.method_37063(multiPlayerButton);
        this.method_37063(optionsButton);
        this.method_37063(quitButton);
        this.method_37063(toggleButton);
        this.method_37063(languageOrReplayButton);
        this.method_37063(accessibilityOptionButton);
        this.method_37063(copyrightButton);

        // 若未禁用原版标题屏幕，则配置与模组菜单按钮应当位于此处
        if (!configManager.config.isDisableVanillaTitleScreen()) {
            this.modsButton = this.getModsButtonBuilder(class_2561.method_43471("category.modmenu.name"), class_2561.method_43471("fanwindow.config"))
                    .method_46434(cenX, cenY + 130, 60, 27)
                    .method_46431();
            this.method_37063(modsButton);
        }
    }

    /**
     * <p>获取足以打开 ModMenu 提供的 ModsScreen 屏幕的按钮 Builder。</p>
     * <p>若 ModMenu 未加载，本方法将抛出 ClassNotFoundException 错误，应当在调用时接收并处理此错误。</p>
     * @param name 按钮上的文本
     * @return 按钮 Builder
     */
    private class_4185.@NotNull class_7840 getModsScreenButtonBuilder(class_2561 name) throws ClassNotFoundException {
        Class<?> ModsScreen = Class.forName("com.terraformersmc.modmenu.gui.ModsScreen");
        Class<?>[] paramTypes = { class_437.class };
        class_4185.class_7840 builder = class_4185.method_46430(name,
                button -> {
                    try {
                        field_22787.method_1507((class_437) ModsScreen.getDeclaredConstructor(paramTypes).newInstance(this));
                        logger.debug("Open ModsScreen from FanWindow Title Screen.");
                    } catch (InstantiationException | IllegalAccessException | InvocationTargetException |
                             NoSuchMethodException e) {
                        logger.error("Could not instantiate ModsScreen while ModMenu is already loaded : ", e);
                        toastBuilder.show(
                                class_2561.method_43471("fanwindow.modmenu.modsScreenFailed.title"),
                                class_2561.method_43471("fanwindow.modmenu.modsScreenFailed.description"));
                    }
                });
        builder.method_46434(cenX, cenY + 130, 60, 27);
        return builder;
    }

    /**
     * 根据 ModMenu 加载情况，获取不同的按钮 Builder。
     * @param name1 若 ModMenu 已加载，获取的打开 ModsScreen 的按钮上的文本
     * @param name2 若 ModMenu 未加载，获取的打开配置屏幕的按钮上的文本
     * @return 按钮 Builder
     */
    private class_4185.@NotNull class_7840 getModsButtonBuilder(class_2561 name1, class_2561 name2) {
        // 如果有ModMenu则添加打开ModsScreen的按钮
        if (globalState.isModMenuSupport()) {
            try {
                return this.getModsScreenButtonBuilder(name1);
            } catch (ClassNotFoundException e) {
                logger.error("Could not load ModsScreen while ModMenu is already loaded : ", e);
                throw new RuntimeException(e);
            }
        }
        // 否则添加打开本模组配置页面的按钮
        else {
            return class_4185.method_46430(name2,
                            button -> {
                                field_22787.method_1507(configManager.getScreen(this));
                                logger.debug("Open FanWindow ConfigScreen from FanWindow Title Screen.");
                            });
        }
    }

    /**
     * 根据设置，获取切换标题屏幕或 {@link NewTitleScreen#getModsButtonBuilder(class_2561, class_2561)} 的按钮 Builder。
     * @return 按钮 Builder
     */
    private class_4185.@NotNull class_7840 getToggleButtonBuilder() {
        // 若未禁用原版标题屏幕，则创建切换标题屏幕的按钮
        if (!configManager.config.isDisableVanillaTitleScreen()) {
            return class_4185.method_46430(class_2561.method_30163("</>"),
                    button -> {
                        GlobalState globalState = GlobalState.getInstance();
                        globalState.setStarted(true);
                        globalState.setNewMainWindowInUse(false);
                        field_22787.method_1507(new class_442());
                    });
        }
        // 否则，创建打开模组菜单或配置屏幕的按钮
        else {
            return getModsButtonBuilder(class_2561.method_30163("</>"), class_2561.method_30163("</>"));
        }
    }

    /**
     * 如果同时加载了 ReplayMod，则将语言按钮替换为 ReplayMod 的回放按钮。
     * @return TextIconButtonWidget
     */
    private class_8662 getLanguageOrReplayButton() {
        if (GlobalState.getInstance().isReplayModSupport()) {
            return class_8662.method_52723(
                    class_2561.method_43471("replaymod.gui.replayviewer"),
                    button -> field_22787.method_1507(cn.mangofanfan.fanwindow.client.function.ReplayModScreenGetter.getReplayModScreen()),
                    true
            ).method_52725(27).method_52727(class_2960.method_60655("fanwindow", "icon/replay_button"), 16, 16).method_52724();
        }
        else {
            return class_8082.method_48592(27,
                    button -> field_22787.method_1507(new class_426(this, field_22787.field_1690, field_22787.method_1526())),
                    true);
        }
    }

    @Override
    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        // 强制重新初始化布局
        this.method_37067();
        this.method_25426();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        logoDrawer.method_48210(context, field_22789 / 5 * 3, 1.0F, field_22790 - 50);
    }

    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (configManager.config.isUseNewBackgroundGlobally() || (!configManager.config.isUseNewBackgroundGlobally()) && !configManager.config.isUseNewBackgroundInNewScreen()) {
            super.method_25420(context, mouseX, mouseY, deltaTicks);
        }
        else {
            new VersionedRenderImpl().renderBackground(context, field_22789, field_22790);
        }
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean method_25422() {
        return false;
    }
}