package cn.mangofanfan.fanwindow.mixin.client;

import cn.mangofanfan.fanwindow.client.GlobalState;
import cn.mangofanfan.fanwindow.client.config.ConfigManager;
import cn.mangofanfan.fanwindow.client.config.FanWindowConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_8667;

@Mixin(class_419.class)
public abstract class DisconnectedScreenMixin extends class_437 {
    protected DisconnectedScreenMixin(class_2561 title) {
        super(title);
    }

    @Shadow
    @Final
    private class_437 parent;

    @Shadow
    @Final
    private class_8667 grid;

    @Unique
    private final class_310 field_22787 = class_310.method_1551();

    @Unique
    class_4185 reConnectButton;

    @Unique
    FanWindowConfig config = ConfigManager.getInstance().config;

    @Unique
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    // 感谢 Jetbrains AI，感谢 Gemini 3 Pro，J门——G门——
    @Inject(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/widget/DirectionalLayoutWidget;refreshPositions()V"))
    private void injectBeforeGridRefresh(CallbackInfo ci) {
        reConnectButton = class_4185.method_46430(
                config.isEnableAutoReconnect()
                        ? class_2561.method_43469("gui.fanwindow.auto_reconnect", config.getAutoReconnectWaitTime())
                        : class_2561.method_43471("gui.fanwindow.reconnect"),
                button -> reConnect()
        ).method_46432(200).method_46431();
        this.grid.method_52736(reConnectButton);
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void initEnd(CallbackInfo ci) {
        if (config.isEnableAutoReconnect()) {
            executor.execute(this::timerTask);
        }
    }

    @Unique
    private void timerTask() {
        int time = config.getAutoReconnectWaitTime();
        try {
            if (field_22787 != null) {
                while (time-- > 0) {
                    Thread.sleep(1000);
                        int finalTime = time;
                        field_22787.execute(() ->
                                this.reConnectButton.method_25355(class_2561.method_43469("gui.fanwindow.auto_reconnect", finalTime))
                        );
                    }
                field_22787.execute(this::reConnect);
            }
        } catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Unique
    private void reConnect() {
        class_642 info = GlobalState.getInstance().getLastServerEntry();
        class_412.method_36877(
                this.parent,
                class_310.method_1551(),
                class_639.method_2950(info.field_3761),
                info,
                false,
                null);
    }

    @Override
    public void method_25432() {
        executor.shutdownNow();
    }
}
