package cn.mangofanfan.fanwindow.client.screen;

import cn.mangofanfan.fanwindow.client.screen.widget.GameModeCardWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_525;
import net.minecraft.class_5676;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8086;
import net.minecraft.class_8100;
import net.minecraft.class_8667;
import net.minecraft.class_8767;
import net.minecraft.client.gui.widget.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@Environment(EnvType.CLIENT)
public class NewCreateWorldScreenGameTab extends class_8086 {
    class_327 textRenderer;
    private static final class_2561 GAME_TAB_TITLE_TEXT = class_2561.method_43471("createWorld.tab.game.title");
    private static final class_2561 ALLOW_COMMANDS_TEXT = class_2561.method_43471("selectWorld.allowCommands");
    private final class_342 worldNameField;
    static final class_2561 ENTER_NAME_TEXT = class_2561.method_43471("selectWorld.enterName");
    static final class_2561 EXPERIMENTS_TEXT = class_2561.method_43471("selectWorld.experiments");
    static final class_2561 ALLOW_COMMANDS_INFO_TEXT = class_2561.method_43471("selectWorld.allowCommands.info");

    Logger logger = LoggerFactory.getLogger(NewCreateWorldScreenGameTab.class);

    public NewCreateWorldScreenGameTab(class_525 self) {
        super(GAME_TAB_TITLE_TEXT);
        this.textRenderer = class_310.method_1551().field_1772;

        class_7845.class_7939 adder = this.field_42139.method_48636(8).method_47610(1);
        class_7847 positioner = adder.method_47611();
        class_8100 worldCreator = self.method_48657();
        this.worldNameField = new class_342(textRenderer, 208, 20, class_2561.method_43471("selectWorld.enterName"));
        this.worldNameField.method_1852(worldCreator.method_48715());
        this.worldNameField.method_1863(worldCreator::method_48710);
        worldCreator
                .method_48712(
                        creator -> this.worldNameField
                                .method_47400(
                                        class_7919.method_47407(class_2561.method_43469("selectWorld.targetFolder", class_2561.method_43470(creator.method_49703()).method_27692(class_124.field_1056)))
                                )
                );
        // CreateWorldScreen.this.setInitialFocus(this.worldNameField);
        adder.method_47615(
                class_8767.method_53549(textRenderer, this.worldNameField, ENTER_NAME_TEXT),
                adder.method_47611().method_46467()
        );

        // 新版游戏模式选择器
        class_8667 directionalLayoutWidget_GameMod = class_8667.method_52742().method_52735(16);
        GameModeCardWidget tab_GameModeSurvival = directionalLayoutWidget_GameMod.method_52736(new GameModeCardWidget(worldCreator, self));
        tab_GameModeSurvival.setMode(class_8100.class_4539.field_20624);
        GameModeCardWidget tab_GameModeHardcore = directionalLayoutWidget_GameMod.method_52736(new GameModeCardWidget(worldCreator, self));
        tab_GameModeHardcore.setMode(class_8100.class_4539.field_20625);
        GameModeCardWidget tab_GameModeCreative = directionalLayoutWidget_GameMod.method_52736(new GameModeCardWidget(worldCreator, self));
        tab_GameModeCreative.setMode(class_8100.class_4539.field_20626);
        adder.method_47615(directionalLayoutWidget_GameMod, positioner.method_46467());

        GameModeCardWidget[] tab_GameModes = {tab_GameModeSurvival, tab_GameModeHardcore, tab_GameModeCreative};
        worldCreator.method_48712(creator -> {
            for(GameModeCardWidget tab_GameMode : tab_GameModes) {
                tab_GameMode.setChosen(false);
                if (tab_GameMode.getMode().equals(worldCreator.method_48721())) {
                    tab_GameMode.setChosen(true);
                }
            }
        });

        // 游戏难度和允许作弊按钮调整在一行内
        class_8667 directionalLayoutWidget_Settings = class_8667.method_52742().method_52735(8);

        class_5676<class_1267> cyclingButtonWidget_Difficulty = directionalLayoutWidget_Settings.method_52737(
                class_5676.method_32606(class_1267::method_5463)
                        .method_32624(class_1267.values())
                        .method_32617(0, 0, 150, 20, class_2561.method_43471("options.difficulty"), (button, value) -> worldCreator.method_48696(value)),
                positioner
        );
        worldCreator.method_48712(creator -> {
            cyclingButtonWidget_Difficulty.method_32605(creator.method_48722());
            cyclingButtonWidget_Difficulty.field_22763 = !creator.method_48723();
            cyclingButtonWidget_Difficulty.method_47400(class_7919.method_47407(creator.method_48722().method_48556()));
        });
        class_5676<Boolean> cyclingButtonWidget_AllowCheat = directionalLayoutWidget_Settings.method_52736(
                class_5676.method_32614()
                        .method_32618(value -> class_7919.method_47407(ALLOW_COMMANDS_INFO_TEXT))
                        .method_32617(0, 0, 150, 20, ALLOW_COMMANDS_TEXT, (button, value) -> worldCreator.method_48713(value))
        );
        worldCreator.method_48712(creator -> {
            cyclingButtonWidget_AllowCheat.method_32605(worldCreator.method_48724());
            cyclingButtonWidget_AllowCheat.field_22763 = !worldCreator.method_48729() && !worldCreator.method_48723();
        });

        adder.method_47615(directionalLayoutWidget_Settings, positioner.method_46467());

        if (!class_155.method_16673().method_48022()) {
            adder.method_47612(
                    class_4185.method_46430(
                                    EXPERIMENTS_TEXT,
                                    button -> self.method_49010(worldCreator.method_48728().comp_1030())
                            )
                            .method_46432(210)
                            .method_46431()
            );
        }

        logger.info("New Create World Screen Game Tab initialized.");
    }
}
