/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.events;

import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.FormChangeConfig;
import com.github.d0ctorleon.mythsandlegends.utils.HeldItemTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationConfig;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationHelper;
import net.minecraft.world.item.ItemStack;

public class HeldItemUpdateEventListener {
    public static void onHeldItemPost(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        ItemStack newStack = event.getReceived();
        ItemStack oldStack = event.getReturned();
        if (pokemon == null || pokemon.getSpecies() == null) {
            MythsAndLegends.getLogger().debug("HeldItemEvent.Post: Pokemon or species is null. Aborting.");
            return;
        }
        if (ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack)) {
            return;
        }
        TransformationConfig config = FormChangeConfig.getConfig();
        String speciesName = pokemon.getSpecies().getName().toLowerCase();
        MythsAndLegends.getLogger().debug("Processing HeldItemEvent.Post for {}. Old: {}, New: {}", (Object)speciesName, (Object)oldStack.getItem(), (Object)newStack.getItem());
        boolean transformationApplied = false;
        for (HeldItemTransformation rule : config.heldItemChanges) {
            if (!rule.pokemon.equalsIgnoreCase(speciesName)) continue;
            MythsAndLegends.getLogger().debug("Checking held item rule for {}", (Object)speciesName);
            if (!TransformationHelper.tryApplyHeldItemChange(pokemon, newStack, rule)) continue;
            MythsAndLegends.getLogger().debug("Applied held item transformation for {} based on rule.", (Object)speciesName);
            transformationApplied = true;
            break;
        }
        if (!transformationApplied) {
            MythsAndLegends.getLogger().debug("No new transformation applied, checking for reversion based on old item.");
            for (HeldItemTransformation rule : config.heldItemChanges) {
                if (!rule.pokemon.equalsIgnoreCase(speciesName) || !TransformationHelper.tryRevertHeldItemChange(pokemon, oldStack, rule)) continue;
                MythsAndLegends.getLogger().debug("Reverted held item transformation for {} based on rule.", (Object)speciesName);
                break;
            }
        }
    }
}

