/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.mixins;

import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SingleEntitySpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.KeyItemConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.ZygardeCubeChargeCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.custom.CustomItemsCondition;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.github.d0ctorleon.mythsandlegends.utils.ZygardeUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SingleEntitySpawnAction.class})
public abstract class SingleEntitySpawnActionMixin {
    @Unique
    private final ConfigVariables postSpawnHook$config = MythsAndLegends.getConfigManager().getConfig();

    @Inject(method={"run()Lcom/cobblemon/mod/common/api/spawning/detail/EntitySpawnResult;"}, at={@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;getWorld()Lnet/minecraft/server/level/ServerLevel;", ordinal=0, shift=At.Shift.AFTER)})
    private void afterSpawnEntity(CallbackInfoReturnable<EntitySpawnResult> cir) {
        if (this.postSpawnHook$config.item_consumption_mode == 0 || this.postSpawnHook$config.item_consumption_mode == 2) {
            MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin: Skipping item consumption based on mode {}", (Object)this.postSpawnHook$config.item_consumption_mode);
            return;
        }
        SingleEntitySpawnAction self = (SingleEntitySpawnAction)this;
        SpawningContext ctx = self.getCtx();
        SpawnDetail detail = self.getDetail();
        this.postSpawnHook$processAction(ctx, detail);
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin: Post-spawn hook executed for mode {}.", (Object)this.postSpawnHook$config.item_consumption_mode);
    }

    @Unique
    private void postSpawnHook$processAction(SpawningContext ctx, SpawnDetail detail) {
        MythsAndLegends.getLogger().debug("Post-Spawn Action: Processing started for spawn detail: {} with mode {}", (Object)detail.getName(), (Object)this.postSpawnHook$config.item_consumption_mode);
        Spawner spawner = ctx.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            ServerPlayer player = MythsAndLegendsConditions.getPlayerFromUUID(ctx.getWorld(), playerSpawner.getUuid());
            if (player == null) {
                MythsAndLegends.getLogger().debug("Post-Spawn Action: Player not found online for UUID: {}, skipping item consumption.", (Object)playerSpawner.getUuid());
                return;
            }
            boolean itemsWereProcessed = false;
            for (SpawningCondition condition : detail.getConditions()) {
                List appendages = condition.getAppendages();
                if (appendages == null || appendages.isEmpty()) continue;
                MythsAndLegends.getLogger().debug("Post-Spawn Action: Processing {} appendage conditions for player {}", (Object)appendages.size(), (Object)player.getName().getString());
                if (!this.postSpawnHook$processAppendageConditions(appendages, player, this.postSpawnHook$config.item_consumption_mode)) continue;
                itemsWereProcessed = true;
            }
            if (itemsWereProcessed) {
                MythsAndLegends.getLogger().debug("Post-Spawn Action: Triggering inventory check for player {} after processing conditions.", (Object)player.getName().getString());
                PlayerDataUtils.updatePlayerData((Player)player);
            }
        } else {
            MythsAndLegends.getLogger().trace("Post-Spawn Action: Spawner is not a PlayerSpawner ({}), skipping player-specific item logic.", (Object)spawner.getClass().getSimpleName());
        }
        MythsAndLegends.getLogger().debug("Post-Spawn Action: Processing finished for spawn detail: {}", (Object)detail.getName());
    }

    @Unique
    private boolean postSpawnHook$processAppendageConditions(List<AppendageCondition> appendages, ServerPlayer player, int consumptionMode) {
        MythsAndLegends.getLogger().debug("Post-Spawn Action: Evaluating appendage conditions for item removal with mode {}.", (Object)consumptionMode);
        boolean removalAttempted = false;
        for (AppendageCondition appendage : appendages) {
            boolean consumeZygardeComponents;
            if (appendage instanceof CustomItemsCondition) {
                CustomItemsCondition customItemsCondition = (CustomItemsCondition)appendage;
                List<CustomItemsCondition.CustomItemCondition> customItems = customItemsCondition.getItemConditions();
                if (customItems == null || customItems.isEmpty()) continue;
                for (CustomItemsCondition.CustomItemCondition itemCondition : customItems) {
                    boolean consumeThisItem;
                    if (itemCondition == null || itemCondition.getItemId() == null) continue;
                    if (!(consumeThisItem = (switch (consumptionMode) {
                        case 1 -> itemCondition.isConsume();
                        case 3 -> true;
                        case 4 -> itemCondition.isConsume();
                        default -> false;
                    }))) continue;
                    MythsAndLegends.getLogger().debug("Post-Spawn Action (Mode {}): Attempting removal for Custom Item: {} x{}", (Object)consumptionMode, (Object)itemCondition.getItemId(), (Object)itemCondition.getCount());
                    this.postSpawnHook$removeSpecificItem(player, itemCondition.getItemId(), itemCondition.getCount());
                    removalAttempted = true;
                }
                continue;
            }
            if (appendage instanceof KeyItemConditions.KeyItem) {
                ResourceLocation keyItemId;
                boolean consumeThisKeyItem;
                KeyItemConditions.KeyItem keyItem = (KeyItemConditions.KeyItem)appendage;
                if (!(consumeThisKeyItem = (switch (consumptionMode) {
                    case 1 -> true;
                    case 3 -> true;
                    default -> false;
                })) || (keyItemId = keyItem.getKeyItemId()) == null) continue;
                MythsAndLegends.getLogger().debug("Post-Spawn Action (Mode {}): Attempting removal for Key Item: {}", (Object)consumptionMode, (Object)keyItemId);
                this.postSpawnHook$removeSpecificItem(player, keyItemId, 1);
                removalAttempted = true;
                continue;
            }
            if (!(appendage instanceof ZygardeCubeChargeCondition)) continue;
            ZygardeCubeChargeCondition zygardeCondition = (ZygardeCubeChargeCondition)appendage;
            if (!(consumeZygardeComponents = (switch (consumptionMode) {
                case 1 -> true;
                case 3 -> true;
                default -> false;
            }))) continue;
            int cellsToConsume = zygardeCondition.getRequired_cells();
            int coresToConsume = zygardeCondition.getRequired_cores();
            if (cellsToConsume > 0 || coresToConsume > 0) {
                MythsAndLegends.getLogger().debug("Post-Spawn Action (Mode {}): Attempting removal for Zygarde components: {} cells, {} cores", (Object)consumptionMode, (Object)cellsToConsume, (Object)coresToConsume);
                if (!this.postSpawnHook$removeZygardeComponents(player, cellsToConsume, coresToConsume)) continue;
                removalAttempted = true;
                continue;
            }
            MythsAndLegends.getLogger().trace("Post-Spawn Action (Mode {}): Zygarde condition found, but 0 cells/cores required.", (Object)consumptionMode);
        }
        MythsAndLegends.getLogger().debug("Post-Spawn Action: Finished evaluating appendage conditions for mode {}. Removal attempted: {}", (Object)consumptionMode, (Object)removalAttempted);
        return removalAttempted;
    }

    @Unique
    private boolean postSpawnHook$removeZygardeComponents(ServerPlayer player, int cellsToRemove, int coresToRemove) {
        boolean overallSuccess;
        if (cellsToRemove <= 0 && coresToRemove <= 0) {
            MythsAndLegends.getLogger().trace("Post-Spawn Action: No Zygarde components specified for removal.");
            return false;
        }
        ItemStack zygardeCubeStack = ZygardeUtil.findZygardeCube(player);
        if (zygardeCubeStack == null || zygardeCubeStack.isEmpty()) {
            MythsAndLegends.getLogger().warn("Post-Spawn Action: Could not find a Zygarde Cube in {}'s inventory.", (Object)player.getName().getString());
            DebtUtils debtUtils = MythsAndLegends.getDebtUtils();
            UUID playerUuid = player.getUUID();
            boolean debtAdded = false;
            if (cellsToRemove > 0) {
                ResourceLocation cellId = Items.ZYGARDE_CELL.getId();
                if (cellId != null) {
                    MythsAndLegends.getLogger().debug("Post-Spawn Action: Adding debt for {} cells (cube not found).", (Object)cellsToRemove);
                    debtUtils.addDebt(playerUuid, cellId, cellsToRemove);
                    debtAdded = true;
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Cell debt: Cell Item ID is null!");
                }
            }
            if (coresToRemove > 0) {
                ResourceLocation coreId = Items.ZYGARDE_CORE.getId();
                if (coreId != null) {
                    MythsAndLegends.getLogger().debug("Post-Spawn Action: Adding debt for {} cores (cube not found).", (Object)coresToRemove);
                    debtUtils.addDebt(playerUuid, coreId, coresToRemove);
                    debtAdded = true;
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Core debt: Core Item ID is null!");
                }
            }
            return false;
        }
        MythsAndLegends.getLogger().debug("Post-Spawn Action: Found Zygarde Cube for {}. Attempting to remove {} cells and {} cores.", (Object)player.getName().getString(), (Object)cellsToRemove, (Object)coresToRemove);
        int cellsActuallyRemoved = 0;
        int coresActuallyRemoved = 0;
        boolean fullCellRemoval = true;
        boolean fullCoreRemoval = true;
        if (cellsToRemove > 0) {
            cellsActuallyRemoved = ZygardeCubeBundleItem.removeCells(zygardeCubeStack, cellsToRemove);
            if (cellsActuallyRemoved != cellsToRemove) {
                fullCellRemoval = false;
                int debtCells = cellsToRemove - cellsActuallyRemoved;
                MythsAndLegends.getLogger().warn("Post-Spawn Action: Failed to remove the required {} cells from cube for {}. Actually removed: {}. Adding debt for {}.", (Object)cellsToRemove, (Object)player.getName().getString(), (Object)cellsActuallyRemoved, (Object)debtCells);
                ResourceLocation cellId = Items.ZYGARDE_CELL.getId();
                if (cellId != null) {
                    MythsAndLegends.getDebtUtils().addDebt(player.getUUID(), cellId, debtCells);
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Cell debt: Cell Item ID is null!");
                }
            } else {
                MythsAndLegends.getLogger().debug("Post-Spawn Action: Successfully removed {} cells.", (Object)cellsActuallyRemoved);
            }
        }
        if (coresToRemove > 0) {
            coresActuallyRemoved = ZygardeCubeBundleItem.removeCores(zygardeCubeStack, coresToRemove);
            if (coresActuallyRemoved != coresToRemove) {
                fullCoreRemoval = false;
                int debtCores = coresToRemove - coresActuallyRemoved;
                MythsAndLegends.getLogger().warn("Post-Spawn Action: Failed to remove the required {} cores from cube for {}. Actually removed: {}. Adding debt for {}.", (Object)coresToRemove, (Object)player.getName().getString(), (Object)coresActuallyRemoved, (Object)debtCores);
                ResourceLocation coreId = Items.ZYGARDE_CORE.getId();
                if (coreId != null) {
                    MythsAndLegends.getDebtUtils().addDebt(player.getUUID(), coreId, debtCores);
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Core debt: Core Item ID is null!");
                }
            } else {
                MythsAndLegends.getLogger().debug("Post-Spawn Action: Successfully removed {} cores.", (Object)coresActuallyRemoved);
            }
        }
        player.getInventory().setChanged();
        boolean bl = overallSuccess = fullCellRemoval && fullCoreRemoval;
        if (overallSuccess) {
            MythsAndLegends.getLogger().info("Post-Spawn Action: Successfully removed exact required amounts ({} cells, {} cores) from Zygarde Cube for player {}.", (Object)cellsToRemove, (Object)coresToRemove, (Object)player.getName().getString());
        } else {
            MythsAndLegends.getLogger().warn("Post-Spawn Action: Failed to remove exact required amounts (Needed:{}/{}, Removed:{}/{}) for player {}. Debt may have been added.", (Object)cellsToRemove, (Object)coresToRemove, (Object)cellsActuallyRemoved, (Object)coresActuallyRemoved, (Object)player.getName().getString());
        }
        return overallSuccess;
    }

    @Unique
    private void postSpawnHook$removeSpecificItem(ServerPlayer player, ResourceLocation itemId, int count) {
        if (count <= 0) {
            MythsAndLegends.getLogger().trace("Post-Spawn Action: Skipping removal for item {} with count {}", (Object)itemId, (Object)count);
            return;
        }
        Item itemToRemove = this.postSpawnHook$getItemFromRegistries(itemId);
        if (itemToRemove == null || itemToRemove == net.minecraft.world.item.Items.AIR) {
            MythsAndLegends.getLogger().warn("Post-Spawn Action: Could not find item in registry for ID: {}. Cannot remove from player {}.", (Object)itemId, (Object)player.getName().getString());
            return;
        }
        MythsAndLegends.getLogger().debug("Post-Spawn Action: Attempting to remove {}x {} ({}) for player {}", (Object)count, (Object)itemId, (Object)itemToRemove.getDescription().getString(), (Object)player.getName().getString());
        boolean checkBundles = this.postSpawnHook$config.inventory_check_bundles;
        boolean checkShulkers = this.postSpawnHook$config.inventory_check_shulker_boxes;
        if (!InventoryUtils.removeItemFromInventory(player, itemToRemove, count, checkBundles, checkShulkers)) {
            MythsAndLegends.getLogger().warn("Post-Spawn Action: Item {} not found/insufficient ({}/{}) in inventory for {}, adding debt.", (Object)itemId, (Object)"X", (Object)count, (Object)player.getName().getString());
            DebtUtils debtUtils = MythsAndLegends.getDebtUtils();
            debtUtils.addDebt(player.getUUID(), itemId, count);
        } else {
            MythsAndLegends.getLogger().debug("Post-Spawn Action: Successfully removed {}x {} for player {}", (Object)count, (Object)itemId, (Object)player.getName().getString());
            player.getInventory().setChanged();
        }
    }

    @Unique
    private Item postSpawnHook$getItemFromRegistries(ResourceLocation itemId) {
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        if (item == null || item == net.minecraft.world.item.Items.AIR) {
            MythsAndLegends.getLogger().error("Post-Spawn Action: Item ID {} not found in Registries.ITEM.", (Object)itemId);
            return null;
        }
        return item;
    }
}

