/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item;

import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.context.FishingSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import org.jetbrains.annotations.NotNull;

public class ZygardeCubeChargeCondition
implements AppendageCondition {
    public int required_cells;
    public int required_cores;

    public boolean fits(@NotNull SpawningContext spawningContext) {
        FishingSpawningContext fishingContext;
        SpawnCause fishingContextCause;
        Entity causeEntity;
        if (this.required_cells <= 0 && this.required_cores <= 0) {
            return true;
        }
        ServerPlayer targetPlayer = null;
        Spawner spawner = spawningContext.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            targetPlayer = MythsAndLegendsConditions.getPlayerFromUUID(spawningContext.getWorld(), playerSpawner.getUuid());
        } else if (spawningContext instanceof FishingSpawningContext && (causeEntity = (fishingContextCause = (fishingContext = (FishingSpawningContext)spawningContext).getCause()).getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity;
            targetPlayer = serverPlayerEntity = (ServerPlayer)causeEntity;
        }
        if (targetPlayer != null) {
            int checkCells = this.required_cells;
            int checkCores = this.required_cores;
            Item zygardeCubeItem = ZygardeCubeBundleItem.getZygardeCubeItem();
            Item cellItem = ZygardeCubeBundleItem.getCellItem();
            Item coreItem = ZygardeCubeBundleItem.getCoreItem();
            if (zygardeCubeItem == null || zygardeCubeItem == Items.AIR || cellItem == null || cellItem == Items.AIR || coreItem == null || coreItem == Items.AIR) {
                MythsAndLegends.getLogger().debug("Zygarde Cube items not found/registered. Condition check fails.");
                return false;
            }
            for (ItemStack stack : targetPlayer.getInventory().items) {
                BundleContents contents;
                if (stack == null || stack.isEmpty() || !stack.is(zygardeCubeItem) || (contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS)) == null || contents.isEmpty()) continue;
                ArrayList<ItemStack> cubeContents = new ArrayList<ItemStack>();
                contents.itemsCopy().forEach(cubeContents::add);
                int cellsInThisCube = ZygardeCubeBundleItem.countItemsOfType(cubeContents, cellItem);
                int coresInThisCube = ZygardeCubeBundleItem.countItemsOfType(cubeContents, coreItem);
                if (cellsInThisCube < checkCells || coresInThisCube < checkCores) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public int getRequired_cells() {
        return this.required_cells;
    }

    public int getRequired_cores() {
        return this.required_cores;
    }
}

