/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.gui;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGui;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public class ConfigGuiHandler
extends ChestMenu {
    private final ConfigVariables config;
    private int currentPage;
    private final int totalPages;
    private final Container inventory;

    public ConfigGuiHandler(int syncId, Player player, Container inventory, ConfigVariables config, int currentPage) {
        super(MenuType.GENERIC_9x6, syncId, player.getInventory(), inventory, 6);
        this.config = config;
        this.inventory = inventory;
        this.currentPage = currentPage;
        this.totalPages = ConfigGui.getTotalPages();
    }

    public void clicked(int slotId, int button, ClickType actionType, Player player) {
        if (!(player instanceof ServerPlayer) || slotId < 0 || slotId >= this.getContainer().getContainerSize()) {
            if (slotId >= this.getContainer().getContainerSize()) {
                super.clicked(slotId, button, actionType, player);
            }
            return;
        }
        ItemStack clickedItem = this.getSlot(slotId).getItem();
        if (clickedItem.isEmpty()) {
            return;
        }
        if (slotId == 46 && clickedItem.getItem() == Items.ARROW) {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.refreshGui(player);
            }
            return;
        }
        if (slotId == 53 && clickedItem.getItem() == Items.ARROW) {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.refreshGui(player);
            }
            return;
        }
        int potentialPaperSlot = slotId - 9;
        ConfigGui.SettingInfo<?> clickedSetting = null;
        int overallSettingIndex = -1;
        if (potentialPaperSlot >= 0 && potentialPaperSlot < this.getContainer().getContainerSize()) {
            clickedSetting = this.findSettingByPaperSlot(potentialPaperSlot);
        }
        if (clickedSetting != null && actionType == ClickType.PICKUP) {
            switch (clickedSetting.type) {
                case TOGGLE: {
                    this.handleToggleSetting(clickedSetting, slotId);
                    break;
                }
                case CYCLE: {
                    this.handleCycleSetting(clickedSetting, slotId);
                }
            }
            MythsAndLegends.getConfigManager().saveConfig();
        }
    }

    private ConfigGui.SettingInfo<?> findSettingByPaperSlot(int paperSlot) {
        int startIndex = this.currentPage * 26;
        int endIndex = Math.min(startIndex + 26, ConfigGui.ALL_SETTINGS.size());
        boolean hasPreviousPage = this.currentPage > 0;
        int currentSettingIndexOnPage = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            int expectedPaperSlot = -1;
            boolean slotFound = false;
            while (!slotFound) {
                int row = currentSettingIndexOnPage / 9;
                int col = currentSettingIndexOnPage % 9;
                int potentialPaperSlot = row * 18 + col;
                if (hasPreviousPage && potentialPaperSlot == 37) {
                    ++currentSettingIndexOnPage;
                    continue;
                }
                expectedPaperSlot = potentialPaperSlot;
                slotFound = true;
            }
            if (expectedPaperSlot == paperSlot) {
                return ConfigGui.ALL_SETTINGS.get(i);
            }
            ++currentSettingIndexOnPage;
        }
        return null;
    }

    private void handleToggleSetting(ConfigGui.SettingInfo<?> setting, int woolSlot) {
        ConfigGui.SettingInfo<?> toggleSetting = setting;
        boolean currentValue = (Boolean)toggleSetting.getter.apply(this.config);
        boolean newValue = !currentValue;
        toggleSetting.setter.accept(this.config, (ConfigVariables)((Object)Boolean.valueOf(newValue)));
        this.updateWoolColor(woolSlot, newValue);
    }

    private void handleCycleSetting(ConfigGui.SettingInfo<?> setting, int woolSlot) {
        ConfigGui.SettingInfo<?> cycleSetting = setting;
        String currentValue = (String)cycleSetting.getter.apply(this.config);
        List<String> options = cycleSetting.cycleOptions;
        if (options == null || options.isEmpty()) {
            return;
        }
        int currentIndex = options.indexOf(currentValue);
        int nextIndex = (currentIndex + 1) % options.size();
        String newValue = options.get(nextIndex);
        cycleSetting.setter.accept(this.config, (ConfigVariables)((Object)newValue));
        this.updateCycleWool(woolSlot, newValue);
    }

    private void updateWoolColor(int slot, boolean enabled) {
        ItemStack wool = new ItemStack((ItemLike)(enabled ? Items.LIME_WOOL : Items.RED_WOOL));
        wool.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)(enabled ? "Enabled" : "Disabled")).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED));
        Optional<Component> originalName = Optional.ofNullable((Component)this.getSlot(slot - 9).getItem().get(DataComponents.CUSTOM_NAME));
        originalName.ifPresent(name -> wool.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)name.getString()).withStyle(ChatFormatting.DARK_GRAY)))));
        this.getSlot(slot).setByPlayer(wool);
    }

    private void updateCycleWool(int slot, String currentValue) {
        ItemStack wool = new ItemStack((ItemLike)Items.PURPLE_WOOL);
        wool.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)currentValue).withStyle(ChatFormatting.LIGHT_PURPLE));
        Optional<Component> originalName = Optional.ofNullable((Component)this.getSlot(slot - 9).getItem().get(DataComponents.CUSTOM_NAME));
        originalName.ifPresent(name -> wool.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)name.getString()).withStyle(ChatFormatting.DARK_GRAY)))));
        this.getSlot(slot).setByPlayer(wool);
    }

    private void refreshGui(Player player) {
        ConfigGui.populateInventoryForPage((SimpleContainer)this.inventory, this.config, this.currentPage, this.totalPages);
        player.closeContainer();
        new ConfigGui().openConfigGui((ServerPlayer)player, this.config, this.currentPage);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        return ItemStack.EMPTY;
    }
}

