/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.items;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.utils.ForceSpawningUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class ZygardeCubeBundleItem
extends BundleItem {
    public static final int MAX_CELLS = 95;
    public static final int MAX_CORES = 5;
    public static final int TOTAL_CAPACITY = 100;
    private static final int ITEM_BAR_COLOR = Mth.color((float)0.2f, (float)0.9f, (float)0.3f);

    public ZygardeCubeBundleItem(Item.Properties settings) {
        super(settings);
    }

    public static Item getZygardeCubeItem() {
        return (Item)Items.ZYGARDE_CORE.get();
    }

    public static Item getCellItem() {
        return (Item)Items.ZYGARDE_CELL.get();
    }

    public static Item getCoreItem() {
        return (Item)Items.ZYGARDE_CORE.get();
    }

    private static boolean isZygardeComponent(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item cell = ZygardeCubeBundleItem.getCellItem();
        Item core = ZygardeCubeBundleItem.getCoreItem();
        return cell != null && stack.is(cell) || core != null && stack.is(core);
    }

    public static int countItemsOfType(List<ItemStack> stacks, Item itemType) {
        if (stacks == null || itemType == null) {
            return 0;
        }
        int count = 0;
        for (ItemStack stack : stacks) {
            if (stack == null || stack.isEmpty() || !stack.is(itemType)) continue;
            count += stack.getCount();
        }
        return count;
    }

    private static int getTotalItemCount(List<ItemStack> stacks) {
        if (stacks == null) {
            return 0;
        }
        int cellCount = ZygardeCubeBundleItem.countItemsOfType(stacks, ZygardeCubeBundleItem.getCellItem());
        int coreCount = ZygardeCubeBundleItem.countItemsOfType(stacks, ZygardeCubeBundleItem.getCoreItem());
        return cellCount + coreCount;
    }

    private static int getLimitForItem(Item item) {
        Item cell = ZygardeCubeBundleItem.getCellItem();
        Item core = ZygardeCubeBundleItem.getCoreItem();
        if (cell != null && item == cell) {
            return 95;
        }
        if (core != null && item == core) {
            return 5;
        }
        return 0;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickType, Player player) {
        ItemStack stackToAdd;
        int addedAmount;
        if (clickType != ClickAction.SECONDARY || stack.getCount() != 1) {
            return false;
        }
        BundleContents currentContents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        ArrayList<ItemStack> currentStacksList = new ArrayList<ItemStack>(currentContents.size());
        currentContents.itemsCopy().forEach(currentStacksList::add);
        boolean changed = false;
        ItemStack slotStack = slot.getItem();
        if (slotStack.isEmpty()) {
            ItemStack removedStack;
            if (!currentStacksList.isEmpty() && (removedStack = (ItemStack)currentStacksList.removeFirst()) != null && !removedStack.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                ItemStack leftover = slot.safeInsert(removedStack);
                if (!leftover.isEmpty()) {
                    ZygardeCubeBundleItem.addStackToList(currentStacksList, leftover);
                    if (!leftover.isEmpty()) {
                        player.getInventory().placeItemBackInInventory(leftover);
                    }
                }
                changed = true;
            }
        } else if (ZygardeCubeBundleItem.isZygardeComponent(slotStack) && slotStack.getItem().canFitInsideContainerItems() && (addedAmount = ZygardeCubeBundleItem.addStackToList(currentStacksList, stackToAdd = slotStack.copy())) > 0) {
            slotStack.shrink(addedAmount);
            this.playInsertSound((Entity)player);
            changed = true;
        }
        if (changed) {
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(List.copyOf(currentStacksList)));
        }
        return changed;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        int addedAmount;
        if (clickType != ClickAction.SECONDARY || !slot.allowModification(player) || stack.getCount() != 1) {
            return false;
        }
        BundleContents currentContents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        ArrayList<ItemStack> currentStacksList = new ArrayList<ItemStack>(currentContents.size());
        currentContents.itemsCopy().forEach(currentStacksList::add);
        boolean changed = false;
        if (otherStack.isEmpty()) {
            ItemStack removedStack;
            if (!currentStacksList.isEmpty() && (removedStack = (ItemStack)currentStacksList.removeFirst()) != null && !removedStack.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                cursorStackReference.set(removedStack);
                changed = true;
            }
        } else if (ZygardeCubeBundleItem.isZygardeComponent(otherStack) && otherStack.getItem().canFitInsideContainerItems() && (addedAmount = ZygardeCubeBundleItem.addStackToList(currentStacksList, otherStack)) > 0) {
            this.playInsertSound((Entity)player);
            changed = true;
        }
        if (changed) {
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(List.copyOf(currentStacksList)));
        }
        return changed;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        ItemStack itemstack = player.getItemInHand(hand);
        BundleContents bundleContents = (BundleContents)itemstack.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents != null && !bundleContents.isEmpty() && !world.isClientSide && player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).isShiftKeyDown()) {
            InteractionResult result = ForceSpawningUtils.forceSpawnFromItemUse(world, player, hand, "zygarde_cube");
            if (result.consumesAction()) {
                return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide());
            }
            if (world.isClientSide) {
                // empty if block
            }
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void onDestroyed(ItemEntity entity) {
        BundleContents bundleContentsComponent = (BundleContents)entity.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContentsComponent != null) {
            entity.getItem().set(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)entity, (Iterable)bundleContentsComponent.itemsCopy());
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS)).filter(contents -> !contents.isEmpty()).map(BundleTooltip::new);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        List<ItemStack> currentStacks;
        BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        List<Object> list = currentStacks = contents != null ? contents.itemCopyStream().toList() : List.of();
        if (currentStacks.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"item.mythsandlegends.zygarde_cube.tooltip.empty").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.mythsandlegends.zygarde_cube.tooltip.max_capacity", (Object[])new Object[]{95, 5}).withStyle(ChatFormatting.DARK_GRAY));
            return;
        }
        int cellCount = ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCellItem());
        int coreCount = ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCoreItem());
        int totalItems = cellCount + coreCount;
        tooltip.add((Component)Component.translatable((String)"item.mythsandlegends.zygarde_cube.tooltip.cells", (Object[])new Object[]{cellCount, 95}).withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.mythsandlegends.zygarde_cube.tooltip.cores", (Object[])new Object[]{coreCount, 5}).withStyle(ChatFormatting.AQUA));
        float fullnessRatio = (float)totalItems / 100.0f;
        tooltip.add((Component)Component.translatable((String)"item.mythsandlegends.zygarde_cube.tooltip.fullness", (Object[])new Object[]{totalItems, 100}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.mythsandlegends.zygarde_cube.tooltip.max_capacity", (Object[])new Object[]{95, 5}).withStyle(ChatFormatting.DARK_GRAY));
        if (type.isAdvanced() && MythsAndLegends.getConfigManager().getConfig().debug_mode) {
            Fraction vanillaOccupancy = contents.weight();
            tooltip.add((Component)Component.literal((String)("Vanilla Occupancy: " + Mth.mulAndTruncate((Fraction)vanillaOccupancy, (int)64) + "/64")).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        return contents != null && !contents.isEmpty();
    }

    public int getBarWidth(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        if (contents == null || contents.isEmpty()) {
            return 0;
        }
        int totalItems = ZygardeCubeBundleItem.getTotalItemCount(contents.itemCopyStream().toList());
        float fullnessRatio = (float)totalItems / 100.0f;
        return Math.min(1 + (int)(fullnessRatio * 12.0f), 13);
    }

    public int getBarColor(ItemStack stack) {
        return ITEM_BAR_COLOR;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static int addStackToList(List<ItemStack> currentStacks, ItemStack stackToAdd) {
        int currentCount;
        if (stackToAdd.isEmpty() || !ZygardeCubeBundleItem.isZygardeComponent(stackToAdd)) {
            return 0;
        }
        Item itemType = stackToAdd.getItem();
        int limit = ZygardeCubeBundleItem.getLimitForItem(itemType);
        int spaceAvailable = limit - (currentCount = ZygardeCubeBundleItem.countItemsOfType(currentStacks, itemType));
        if (spaceAvailable <= 0) {
            return 0;
        }
        int amountToAdd = Math.min(stackToAdd.getCount(), spaceAvailable);
        if (amountToAdd <= 0) {
            return 0;
        }
        ItemStack existingStack = null;
        for (ItemStack internalStack : currentStacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)internalStack, (ItemStack)stackToAdd)) continue;
            existingStack = internalStack;
            break;
        }
        if (existingStack != null) {
            existingStack.grow(amountToAdd);
            stackToAdd.shrink(amountToAdd);
            currentStacks.remove(existingStack);
            currentStacks.add(existingStack);
        } else {
            currentStacks.add(stackToAdd.split(amountToAdd));
        }
        return amountToAdd;
    }

    public static int getCellCount(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        if (contents == null || contents.isEmpty()) {
            return 0;
        }
        List<ItemStack> currentStacks = contents.itemCopyStream().toList();
        return ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCellItem());
    }

    public static int getCoreCount(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        if (contents == null || contents.isEmpty()) {
            return 0;
        }
        List<ItemStack> currentStacks = contents.itemCopyStream().toList();
        return ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCoreItem());
    }

    public static int getRemainingSpace(ItemStack stack) {
        int currentCells = ZygardeCubeBundleItem.getCellCount(stack);
        int currentCores = ZygardeCubeBundleItem.getCoreCount(stack);
        return 100 - (currentCells + currentCores);
    }

    public static int addCells(ItemStack stack, int amount) {
        if (amount <= 0 || ZygardeCubeBundleItem.getCellItem() == null) {
            return 0;
        }
        BundleContents currentContents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        ArrayList<ItemStack> currentStacksList = new ArrayList<ItemStack>(currentContents.size());
        currentContents.itemsCopy().forEach(currentStacksList::add);
        int currentCellCount = ZygardeCubeBundleItem.countItemsOfType(currentStacksList, ZygardeCubeBundleItem.getCellItem());
        int spaceAvailable = 95 - currentCellCount;
        int amountToAdd = Math.min(amount, spaceAvailable);
        if (amountToAdd <= 0) {
            return 0;
        }
        ItemStack cellsToAddStack = new ItemStack((ItemLike)ZygardeCubeBundleItem.getCellItem(), amountToAdd);
        int actuallyAdded = ZygardeCubeBundleItem.addStackToList(currentStacksList, cellsToAddStack);
        if (actuallyAdded > 0) {
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(List.copyOf(currentStacksList)));
        }
        return actuallyAdded;
    }

    public static int addCores(ItemStack stack, int amount) {
        if (amount <= 0 || ZygardeCubeBundleItem.getCoreItem() == null) {
            return 0;
        }
        BundleContents currentContents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        ArrayList<ItemStack> currentStacksList = new ArrayList<ItemStack>(currentContents.size());
        currentContents.itemsCopy().forEach(currentStacksList::add);
        int currentCoreCount = ZygardeCubeBundleItem.countItemsOfType(currentStacksList, ZygardeCubeBundleItem.getCoreItem());
        int spaceAvailable = 5 - currentCoreCount;
        int amountToAdd = Math.min(amount, spaceAvailable);
        if (amountToAdd <= 0) {
            return 0;
        }
        ItemStack coresToAddStack = new ItemStack((ItemLike)ZygardeCubeBundleItem.getCoreItem(), amountToAdd);
        int actuallyAdded = ZygardeCubeBundleItem.addStackToList(currentStacksList, coresToAddStack);
        if (actuallyAdded > 0) {
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(List.copyOf(currentStacksList)));
        }
        return actuallyAdded;
    }

    public static int removeCells(ItemStack stack, int amount) {
        return ZygardeCubeBundleItem.removeItemsOfType(stack, ZygardeCubeBundleItem.getCellItem(), amount);
    }

    public static int removeCores(ItemStack stack, int amount) {
        return ZygardeCubeBundleItem.removeItemsOfType(stack, ZygardeCubeBundleItem.getCoreItem(), amount);
    }

    private static int removeItemsOfType(ItemStack stack, Item itemType, int amount) {
        if (amount <= 0 || itemType == null) {
            return 0;
        }
        BundleContents currentContents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        if (currentContents == null || currentContents.isEmpty()) {
            return 0;
        }
        ArrayList currentStacksList = new ArrayList(currentContents.size());
        currentContents.itemsCopy().forEach(currentStacksList::add);
        int totalRemoved = 0;
        int remainingToRemove = amount;
        for (int i = currentStacksList.size() - 1; i >= 0 && remainingToRemove > 0; --i) {
            ItemStack internalStack = (ItemStack)currentStacksList.get(i);
            if (internalStack == null || internalStack.isEmpty() || !internalStack.is(itemType)) continue;
            int amountFromThisStack = Math.min(internalStack.getCount(), remainingToRemove);
            internalStack.shrink(amountFromThisStack);
            totalRemoved += amountFromThisStack;
            remainingToRemove -= amountFromThisStack;
            if (!internalStack.isEmpty()) continue;
            currentStacksList.remove(i);
        }
        if (totalRemoved > 0) {
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(List.copyOf(currentStacksList)));
        }
        return totalRemoved;
    }
}

