/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.loot;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.loot.GroupEntry;
import com.github.d0ctorleon.mythsandlegends.loot.LootGroup;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableModifier {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<String, List<LootGroup>> lootConfig = new HashMap<String, List<LootGroup>>();
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("mythsandlegends").resolve("loot_tables_config.json");
    private static List<String> ULTRA_RARE_ITEMS;
    private static List<String> RARE_ITEMS;
    private static List<String> COMMON_ITEMS;

    private static void initializeRaritySets() {
        if (ULTRA_RARE_ITEMS != null) {
            return;
        }
        MythsAndLegends.getLogger().debug("Initializing rarity sets for default config...");
        ULTRA_RARE_ITEMS = MythsAndLegends.getConfigManager().getConfig().ULTRA_RARE_ITEMS;
        RARE_ITEMS = MythsAndLegends.getConfigManager().getConfig().RARE_ITEMS;
        COMMON_ITEMS = MythsAndLegends.getConfigManager().getConfig().COMMON_ITEMS;
        MythsAndLegends.getLogger().debug("Rarity sets initialized.");
    }

    public static void registerLootModifications() {
        LootTableModifier.loadLootTableConfig();
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            ResourceLocation tableId = key.location();
            String tableIdStr = tableId.toString();
            if (builtin && lootConfig.containsKey(tableIdStr)) {
                List<LootGroup> groupsForTable = lootConfig.get(tableIdStr);
                if (groupsForTable == null || groupsForTable.isEmpty()) {
                    return;
                }
                MythsAndLegends.getLogger().debug("Modifying loot table: {}", (Object)tableIdStr);
                for (LootGroup group : groupsForTable) {
                    if (!group.enabled || group.entries.isEmpty()) continue;
                    LootPool.Builder poolBuilder = LootPool.lootPool();
                    boolean addedAnyValidEntries = false;
                    poolBuilder.when(LootItemRandomChanceCondition.randomChance((float)group.chance));
                    poolBuilder.setRolls((NumberProvider)ConstantValue.exactly((float)group.rolls));
                    MythsAndLegends.getLogger().debug("  Processing Group '{}' (Chance: {}, Rolls: {})", (Object)group.groupName, (Object)Float.valueOf(group.chance), (Object)group.rolls);
                    for (GroupEntry entry : group.entries) {
                        Optional optionalItem = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)entry.itemId));
                        if (optionalItem.isPresent() && optionalItem.get() != net.minecraft.world.item.Items.AIR) {
                            Item item = (Item)optionalItem.get();
                            LootPoolSingletonContainer.Builder itemEntryBuilder = LootItem.lootTableItem((ItemLike)item);
                            itemEntryBuilder.setWeight(entry.weight);
                            if (entry.minCount != 1 || entry.maxCount != 1) {
                                Object countProvider = entry.minCount == entry.maxCount ? ConstantValue.exactly((float)entry.minCount) : UniformGenerator.between((float)entry.minCount, (float)entry.maxCount);
                                itemEntryBuilder.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)countProvider));
                                MythsAndLegends.getLogger().debug("    - Adding Entry: {} (Weight: {}, Count: {}-{})", (Object)entry.itemId, (Object)entry.weight, (Object)entry.minCount, (Object)entry.maxCount);
                            } else {
                                MythsAndLegends.getLogger().debug("    - Adding Entry: {} (Weight: {}, Count: 1)", (Object)entry.itemId, (Object)entry.weight);
                            }
                            poolBuilder.add((LootPoolEntryContainer.Builder)itemEntryBuilder);
                            addedAnyValidEntries = true;
                            continue;
                        }
                        MythsAndLegends.getLogger().warn("Item ID '{}' in loot group '{}' for table '{}' not found or is Air, skipping entry.", (Object)entry.itemId, (Object)group.groupName, (Object)tableIdStr);
                    }
                    if (addedAnyValidEntries) {
                        context.addPool(poolBuilder);
                        MythsAndLegends.getLogger().debug("  Successfully added pool for group '{}' to table '{}'.", (Object)group.groupName, (Object)tableIdStr);
                        continue;
                    }
                    MythsAndLegends.getLogger().warn("Skipping pool for group '{}' in table '{}' as it contained no valid item entries.", (Object)group.groupName, (Object)tableIdStr);
                }
            }
        });
    }

    public static void loadLootTableConfig() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            MythsAndLegends.getLogger().info("Loot configuration file v2 not found, creating default at: {}", (Object)CONFIG_PATH);
            LootTableModifier.createDefaultConfigFile();
            return;
        }
        Type configMapType = new TypeToken<Map<String, List<LootGroup>>>(){}.getType();
        JsonObject rootObject = null;
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
            rootObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (JsonSyntaxException | IOException e) {
            MythsAndLegends.getLogger().error("Error reading or parsing loot configuration file v2: {}. Using empty config. Please fix or delete the file.", (Object)e.getMessage(), (Object)e);
            lootConfig = new HashMap<String, List<LootGroup>>();
            return;
        }
        if (rootObject != null && rootObject.has("lootTables")) {
            JsonElement lootTablesElement = rootObject.get("lootTables");
            Map loaded = (Map)GSON.fromJson(lootTablesElement, configMapType);
            if (loaded != null) {
                lootConfig = loaded;
                MythsAndLegends.getLogger().info("Successfully loaded loot table configuration v2.");
            } else {
                MythsAndLegends.getLogger().error("Parsed 'lootTables' section in configuration file v2 was null or invalid. Using empty config.");
                lootConfig = new HashMap<String, List<LootGroup>>();
            }
        } else {
            MythsAndLegends.getLogger().error("Loot configuration file v2 is missing the 'lootTables' key. Using empty config.");
            lootConfig = new HashMap<String, List<LootGroup>>();
        }
    }

    private static void createDefaultConfigFile() {
        LootTableModifier.initializeRaritySets();
        if (Items.ALL_ITEM_IDS.isEmpty()) {
            MythsAndLegends.getLogger().error("Items.ALL_ITEM_IDS is not populated! Cannot generate default loot config. Make sure items are registered first.");
            lootConfig = new HashMap<String, List<LootGroup>>();
            return;
        }
        HashMap<String, List<LootGroup>> defaultConfig = new HashMap<String, List<LootGroup>>();
        MythsAndLegends.getLogger().info("Generating default loot config using rarity weights...");
        Map<ResourceLocation, Float> commonChestChances = MythsAndLegends.getConfigManager().getConfig().common_chest_chances;
        Map<ResourceLocation, Float> rareChestChances = MythsAndLegends.getConfigManager().getConfig().rare_chest_chances;
        String ZYGARDE_CELL_ID = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"zygarde_cell").toString();
        String ZYGARDE_CORE_ID = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"zygarde_core").toString();
        ArrayList<ResourceLocation> tablesToConfigure = new ArrayList<ResourceLocation>(commonChestChances.keySet());
        tablesToConfigure.addAll(rareChestChances.keySet());
        for (ResourceLocation tableId : tablesToConfigure) {
            String tableIdStr = tableId.toString();
            ArrayList<LootGroup> groupsForThisTable = new ArrayList<LootGroup>();
            float groupChance = commonChestChances.getOrDefault(tableId, rareChestChances.getOrDefault(tableId, Float.valueOf(0.05f))).floatValue();
            LootGroup mainGroup = new LootGroup(tableId.getPath().replace('/', '_') + "_mythic_items", groupChance, 1);
            for (ResourceLocation itemId : Items.ALL_ITEM_IDS) {
                String itemIdStr = itemId.toString();
                int weight = ULTRA_RARE_ITEMS.contains(itemIdStr) ? 1 : (RARE_ITEMS.contains(itemIdStr) ? 5 : (COMMON_ITEMS.contains(itemIdStr) ? 30 : 10));
                int minCount = 1;
                int maxCount = 1;
                if (itemIdStr.equals(ZYGARDE_CELL_ID)) {
                    minCount = MythsAndLegends.getConfigManager().getConfig().zygarde_cell_min_count;
                    maxCount = MythsAndLegends.getConfigManager().getConfig().zygarde_cell_max_count;
                    MythsAndLegends.getLogger().debug("Setting custom count for {} in {}: {}-{}", (Object)itemIdStr, (Object)tableIdStr, (Object)minCount, (Object)maxCount);
                } else if (itemIdStr.equals(ZYGARDE_CORE_ID)) {
                    minCount = MythsAndLegends.getConfigManager().getConfig().zygarde_core_min_count;
                    maxCount = MythsAndLegends.getConfigManager().getConfig().zygarde_core_max_count;
                    MythsAndLegends.getLogger().debug("Setting custom count for {} in {}: {}-{}", (Object)itemIdStr, (Object)tableIdStr, (Object)minCount, (Object)maxCount);
                }
                mainGroup.entries.add(new GroupEntry(itemIdStr, weight, minCount, maxCount));
            }
            if (!mainGroup.entries.isEmpty()) {
                groupsForThisTable.add(mainGroup);
                defaultConfig.put(tableIdStr, groupsForThisTable);
                continue;
            }
            MythsAndLegends.getLogger().warn("No default entries generated for table {} (check item registration and rarity sets).", (Object)tableIdStr);
        }
        lootConfig = defaultConfig;
        MythsAndLegends.getLogger().info("Default loot config generated for {} tables.", (Object)defaultConfig.size());
        LootTableModifier.saveConfigToFile();
    }

    private static void saveConfigToFile() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Could not create config directory: {}", (Object)CONFIG_PATH.getParent(), (Object)e);
            return;
        }
        Type configMapType = new TypeToken<Map<String, List<LootGroup>>>(){}.getType();
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonObject rootObjectWithComments = new JsonObject();
            JsonElement configJsonElement = GSON.toJsonTree(lootConfig, configMapType);
            rootObjectWithComments.add("lootTables", configJsonElement);
            GSON.toJson((JsonElement)rootObjectWithComments, (Appendable)writer);
            MythsAndLegends.getLogger().info("Saved loot table configuration v2 to {}", (Object)CONFIG_PATH);
        }
        catch (JsonIOException | IOException e) {
            MythsAndLegends.getLogger().error("Error saving loot configuration file v2: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

