/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.net;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.FormChangeConfig;
import com.github.d0ctorleon.mythsandlegends.net.SyncTransformConfigPacket;
import com.github.d0ctorleon.mythsandlegends.net.TriggerTransformationPacket;
import com.github.d0ctorleon.mythsandlegends.net.TriggerZygardeActionPacket;
import com.github.d0ctorleon.mythsandlegends.utils.FusionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.InteractionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationConfig;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationHelper;
import com.github.d0ctorleon.mythsandlegends.utils.ZygardeUtil;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import org.apache.logging.log4j.Logger;

public class MythsAndLegendsNetworking {
    private static final Logger LOGGER = MythsAndLegends.getLogger();

    public static void init() {
        MythsAndLegendsNetworking.registerPacketsC2S();
        if (Platform.getEnv().equals((Object)Dist.DEDICATED_SERVER)) {
            MythsAndLegendsNetworking.registerS2CServer();
        }
    }

    private static void registerS2CServer() {
        NetworkManager.registerS2CPayloadType(SyncTransformConfigPacket.ID, SyncTransformConfigPacket.CODEC);
        LOGGER.info("Registered S2C SyncTransformConfigPacket payload type on server.");
    }

    public static void registerPacketsC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, TriggerTransformationPacket.ID, TriggerTransformationPacket.CODEC, (packet, context) -> {
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                context.queue(() -> MythsAndLegendsNetworking.handleTransformationTrigger(serverPlayer, packet.pokemonId()));
            } else {
                LOGGER.warn("Received TriggerTransformationPacket from a non-ServerPlayerEntity or null player: {}", (Object)player);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, TriggerZygardeActionPacket.ID, TriggerZygardeActionPacket.CODEC, (packet, context) -> {
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (packet.actionType() == TriggerZygardeActionPacket.ZygardeActionType.TRANSFORM) {
                    context.queue(() -> ZygardeUtil.handleZygardeFormChange(serverPlayer, packet.pokemonId()));
                } else if (packet.actionType() == TriggerZygardeActionPacket.ZygardeActionType.CHARGE) {
                    context.queue(() -> ZygardeUtil.handleZygardeCharge(serverPlayer, packet.pokemonId()));
                }
            } else {
                LOGGER.warn("Received TriggerZygardeActionPacket from a non-ServerPlayerEntity or null player: {}", (Object)player);
            }
        });
        LOGGER.info("Registered C2S network packets for Myths and Legends.");
    }

    private static void handleTransformationTrigger(ServerPlayer player, UUID pokemonId) {
        if (player == null || player.serverLevel() == null) {
            LOGGER.warn("Received transformation trigger packet with null player or world.");
            return;
        }
        Entity entity = player.serverLevel().getEntity(pokemonId);
        if (!(entity instanceof PokemonEntity)) {
            LOGGER.warn("Received transformation trigger packet for non-Pokemon entity or invalid UUID: {}", (Object)pokemonId);
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        if (pokemonEntity.getPokemon().getOwnerUUID() != null && !pokemonEntity.getPokemon().getOwnerUUID().equals(player.getUUID())) {
            LOGGER.warn("Player {} tried to trigger transformation on Pokemon {} they don't own via packet.", (Object)player.getName().getString(), (Object)pokemonId);
            return;
        }
        if (pokemonEntity.isBattleClone()) {
            LOGGER.debug("Transformation trigger ignored for battle clone {}", (Object)pokemonId);
            return;
        }
        Pokemon targetPokemon = pokemonEntity.getPokemon();
        ItemStack heldStack = player.getMainHandItem();
        String speciesName = targetPokemon.getSpecies().getName().toLowerCase();
        TransformationConfig config = FormChangeConfig.getConfig();
        LOGGER.debug("Handling transformation trigger for {} from player {} with item {}", (Object)speciesName, (Object)player.getName().getString(), (Object)heldStack.getItem());
        for (FusionTransformation fusionTransformation : config.fusions) {
            if (!fusionTransformation.basePokemon.equalsIgnoreCase(speciesName)) continue;
            LOGGER.debug("Checking fusion/unfusion rule for {}", (Object)speciesName);
            if (!TransformationHelper.tryApplyFusionOrUnfusion(player, targetPokemon, heldStack, fusionTransformation, InteractionHand.MAIN_HAND)) continue;
            LOGGER.debug("Applied fusion/unfusion based on rule via packet.");
            player.swing(InteractionHand.MAIN_HAND);
            return;
        }
        for (InteractionTransformation interactionTransformation : config.interactionChanges) {
            if (!interactionTransformation.pokemon.equalsIgnoreCase(speciesName)) continue;
            LOGGER.debug("Checking interaction rule for {}", (Object)speciesName);
            if (!TransformationHelper.tryApplyInteractionChange(player, targetPokemon, heldStack, interactionTransformation)) continue;
            LOGGER.debug("Applied interaction form change based on rule via packet.");
            player.swing(InteractionHand.MAIN_HAND);
            return;
        }
        LOGGER.debug("No matching transformation rule found for {} with item {} via packet trigger.", (Object)speciesName, (Object)heldStack.getItem());
    }
}

