/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.CobblemonWorldSpawnerManager;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.config.CobblemonConfig;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.KeyItemCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.ZygardeCubeChargeCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.custom.CustomItemsCondition;
import com.github.d0ctorleon.mythsandlegends.commands.Commands;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import com.github.d0ctorleon.mythsandlegends.utils.ItemCooldownStorage;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.github.d0ctorleon.mythsandlegends.utils.ZygardeUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ForceSpawningUtils {
    public static InteractionResult forceSpawnFromItemUse(Level world, Player playerEntity, InteractionHand hand, String keyItemIdentifierPath) {
        if (playerEntity instanceof ServerPlayer) {
            return ForceSpawningUtils.forceSpawnInternal(world, (ServerPlayer)playerEntity, keyItemIdentifierPath, true, false, null, playerEntity.getItemInHand(hand));
        }
        return InteractionResult.FAIL;
    }

    public static InteractionResult forceSpawnByKeyItem(Level world, ServerPlayer playerEntity, String keyItemIdentifierPath, boolean consumeVoucher, boolean ignoreCooldown, CommandSourceStack feedbackSource) {
        ResourceLocation itemId = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)keyItemIdentifierPath);
        Item keyItem = BuiltInRegistries.ITEM.getOptional(itemId).orElse(null);
        ItemStack itemStack = keyItem != null ? new ItemStack((ItemLike)keyItem) : ItemStack.EMPTY;
        return ForceSpawningUtils.forceSpawnInternal(world, playerEntity, keyItemIdentifierPath, consumeVoucher, ignoreCooldown, feedbackSource, itemStack);
    }

    private static InteractionResult forceSpawnInternal(Level world, ServerPlayer playerEntity, String keyItemIdentifierPath, boolean consumeVoucher, boolean ignoreCooldown, CommandSourceStack feedbackSource, ItemStack itemStackUsed) {
        int sliceHeight;
        SpawnCause cause;
        int remainingTicks;
        ConfigVariables modConfig = MythsAndLegends.getConfigManager().getConfig();
        ItemCooldownStorage cooldownStorage = MythsAndLegends.getItemCooldownStorage();
        if (!modConfig.enable_force_spawning) {
            MythsAndLegends.getLogger().debug("Force spawning is disabled in config.");
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.disabled"));
            return InteractionResult.FAIL;
        }
        if (world.isClientSide) {
            MythsAndLegends.getLogger().warn("forceSpawnInternal called on client side!");
            return InteractionResult.FAIL;
        }
        UUID playerId = playerEntity.getUUID();
        Item item = itemStackUsed.getItem();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation requiredKeyItemId = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)keyItemIdentifierPath);
        Item requiredKeyItem = BuiltInRegistries.ITEM.getOptional(requiredKeyItemId).orElse(null);
        if (requiredKeyItem == null) {
            MythsAndLegends.getLogger().error("The required key item identifier '{}' does not resolve to a valid item!", (Object)requiredKeyItemId);
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.internal", (Object[])new Object[]{"Invalid Key Item Path"}));
            return InteractionResult.FAIL;
        }
        if (item == net.minecraft.world.item.Items.AIR) {
            item = requiredKeyItem;
            itemId = requiredKeyItemId;
            MythsAndLegends.getLogger().debug("Resolved item from path for command/logic: {}", (Object)itemId);
        } else if (!Items.KEY_ITEM_IDS.contains(itemId)) {
            MythsAndLegends.getLogger().warn("Attempted force spawn with non-tracked item reference: {}", (Object)itemId);
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.invalid_item", (Object[])new Object[]{itemId.toString()}));
            return InteractionResult.FAIL;
        }
        Item finalItem = item;
        ResourceLocation finalItemId = itemId;
        if (!PlayerDataUtils.getPlayerData((Player)playerEntity).hasItem(requiredKeyItem)) {
            String itemNameForMsg = requiredKeyItem.getDescription().getString();
            MythsAndLegends.getLogger().debug("Player {} does not have required key item {} ({}) in persistent data", (Object)playerId, (Object)itemNameForMsg, (Object)requiredKeyItemId);
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.missing_key_item", (Object[])new Object[]{itemNameForMsg}));
            return InteractionResult.FAIL;
        }
        int cooldownSeconds = modConfig.force_spawn_item_cooldown;
        int maxVouchers = modConfig.force_spawning_vouchers;
        int requiredVouchers = 1;
        if (!ignoreCooldown && (remainingTicks = ItemCooldownStorage.calculateRemainingCooldownTicks(cooldownStorage, playerId, finalItem, cooldownSeconds)) > 0) {
            MythsAndLegends.getLogger().debug("Cooldown active for player {} (Item: {}, Global Check: {}). Ticks remaining: {}", (Object)playerId, (Object)finalItemId, (Object)modConfig.global_item_cooldown, (Object)remainingTicks);
            String remainingTime = Commands.formatTicksToTime(remainingTicks);
            MutableComponent feedbackMsg = modConfig.global_item_cooldown ? Component.translatable((String)"commands.mythsandlegends.forcespawn.error.cooldown_global", (Object[])new Object[]{remainingTime}) : Component.translatable((String)"commands.mythsandlegends.forcespawn.error.cooldown", (Object[])new Object[]{finalItem.getDescription(), remainingTime});
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)feedbackMsg);
            if (feedbackSource == null) {
                playerEntity.getCooldowns().addCooldown(finalItem, remainingTicks);
            }
            return InteractionResult.FAIL;
        }
        if (modConfig.enable_vouchers && consumeVoucher && !cooldownStorage.hasEnoughVouchers(playerId, finalItem, requiredVouchers, maxVouchers)) {
            MythsAndLegends.getLogger().debug("Out of vouchers for player {} (Item: {}, Global Check: {})", (Object)playerId, (Object)finalItemId, (Object)modConfig.global_item_vouchers);
            MutableComponent feedbackMsg = modConfig.global_item_vouchers ? Component.translatable((String)"commands.mythsandlegends.forcespawn.error.no_vouchers_global", (Object[])new Object[]{maxVouchers}) : Component.translatable((String)"commands.mythsandlegends.forcespawn.error.no_vouchers", (Object[])new Object[]{finalItem.getDescription(), maxVouchers});
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)feedbackMsg);
            return InteractionResult.FAIL;
        }
        MythsAndLegends.getLogger().debug("Applying cooldown and saving timestamp for player {}, item {}", (Object)playerId, (Object)finalItemId);
        cooldownStorage.saveCooldownTimestamp(playerId, finalItem);
        if (cooldownSeconds > 0) {
            int cooldownTicks = cooldownSeconds * 20;
            playerEntity.getCooldowns().addCooldown(finalItem, cooldownTicks);
            MythsAndLegends.getLogger().debug("Applied visual cooldown of {} ticks for item {}", (Object)cooldownTicks, (Object)finalItemId);
        } else {
            MythsAndLegends.getLogger().debug("Cooldown seconds is 0, skipping visual cooldown application.");
        }
        MythsAndLegends.getLogger().debug("Attempting force spawn for key item condition {} triggered by {}", (Object)keyItemIdentifierPath, (Object)playerEntity.getName().getString());
        PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.getUUID());
        if (spawner == null) {
            MythsAndLegends.getLogger().error("No PlayerSpawner found for player {}", (Object)playerId);
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.internal", (Object[])new Object[]{"No Spawner"}));
            return InteractionResult.FAIL;
        }
        SpawnBucket spawn_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> modConfig.force_spawning_spawn_pool.equalsIgnoreCase(b.name)).findFirst().orElse(null);
        if (spawn_bucket == null) {
            MythsAndLegends.getLogger().warn("Configured force spawn pool '{}' not found. Using default bucket selection.", (Object)modConfig.force_spawning_spawn_pool);
            cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (Entity)spawner.getCauseEntity());
        } else {
            MythsAndLegends.getLogger().debug("Using spawn bucket from config: {}", (Object)spawn_bucket.name);
            cause = new SpawnCause((Spawner)spawner, spawn_bucket, (Entity)spawner.getCauseEntity());
        }
        CobblemonConfig cobblemonConfig = Cobblemon.INSTANCE.getConfig();
        int sliceDiameter = modConfig.force_spawn_check_width == -1 ? cobblemonConfig.getWorldSliceDiameter() : modConfig.force_spawn_check_width;
        int n = sliceHeight = modConfig.force_spawn_check_height == -1 ? cobblemonConfig.getWorldSliceHeight() : modConfig.force_spawn_check_height;
        if (sliceDiameter <= 0 || sliceHeight <= 0) {
            MythsAndLegends.getLogger().warn("Invalid slice dimensions configured or defaulted: height={}, diameter={}. Aborting spawn.", (Object)sliceHeight, (Object)sliceDiameter);
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.invalid_dimensions"));
            return InteractionResult.FAIL;
        }
        int baseX = (int)Math.floor(playerEntity.getX() - (double)((float)sliceDiameter / 2.0f));
        int baseY = (int)Math.floor(playerEntity.getY() - (double)((float)sliceHeight / 2.0f));
        int baseZ = (int)Math.floor(playerEntity.getZ() - (double)((float)sliceDiameter / 2.0f));
        int minY = world.getMinBuildHeight();
        int maxY = Math.min(world.getMaxBuildHeight() - 1, playerEntity.level().getHeight()) - sliceHeight;
        baseY = Math.max(minY, Math.min(baseY, maxY));
        SpawningArea area = new SpawningArea(cause, (ServerLevel)world, baseX, baseY, baseZ, sliceDiameter, sliceHeight, sliceDiameter);
        MythsAndLegends.getLogger().debug("Calculated SpawningArea for force spawn: {}", (Object)area);
        AtomicBoolean spawnSuccessful = new AtomicBoolean(false);
        AtomicReference<Object> spawnedDetail = new AtomicReference<Object>(null);
        try {
            WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, area);
            if (slice == null) {
                MythsAndLegends.getLogger().debug("Prospecting found no potential spawn points in the area.");
                ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.no_area"));
                return InteractionResult.FAIL;
            }
            List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
            if (contexts.isEmpty()) {
                MythsAndLegends.getLogger().debug("No spawnable contexts found after resolving slice for area: {}", (Object)area);
                ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.no_context"));
                return InteractionResult.FAIL;
            }
            MythsAndLegends.getLogger().debug("Found {} spawnable contexts for force spawn.", (Object)contexts.size());
            contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).filter(selectionPair -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selectionPair.getSecond(), keyItemIdentifierPath)).limit(1L).findFirst().ifPresent(selection -> {
                MythsAndLegends.getLogger().debug("Selected spawn detail {} for context {} matching key item {}", (Object)((SpawnDetail)selection.getSecond()).getDisplayName(), selection.getFirst(), (Object)keyItemIdentifierPath);
                if (selection.getSecond() == null || selection.getFirst() == null) {
                    MythsAndLegends.getLogger().error("Critical Error: Null context or detail in selected pair! Context: {}, Detail: {}", selection.getFirst(), selection.getSecond());
                    return;
                }
                SpawnAction spawnAction = ((SpawnDetail)selection.getSecond()).doSpawn((SpawningContext)selection.getFirst());
                try {
                    if (spawnAction == null) {
                        MythsAndLegends.getLogger().error("doSpawn returned a null SpawnAction for detail {}", (Object)((SpawnDetail)selection.getSecond()).getDisplayName());
                        return;
                    }
                    ForceSpawningUtils.executeSpawnAction(spawnAction);
                    MythsAndLegends.getLogger().info("Successfully executed spawn action for {} via force spawn!", (Object)((SpawnDetail)selection.getSecond()).getDisplayName());
                    spawnSuccessful.set(true);
                    spawnedDetail.set(((SpawnDetail)selection.getSecond()));
                }
                catch (Exception e) {
                    MythsAndLegends.getLogger().error("Error executing spawn action for " + ((SpawnDetail)selection.getSecond()).getDisplayName(), (Throwable)e);
                }
            });
            if (spawnSuccessful.get()) {
                SpawnDetail detail = spawnedDetail.get();
                if (detail != null) {
                    String displayName = detail.getDisplayName();
                    ForceSpawningUtils.consumeAdditionalItemsAfterForceSpawn(playerEntity, detail, modConfig.item_consumption_mode);
                    if (displayName != null) {
                        ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.success_spawned", (Object[])new Object[]{displayName}));
                    } else {
                        MythsAndLegends.getLogger().warn("SpawnDetail {} provided a null display name. Using generic success message.", (Object)detail.getId());
                        ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.success"));
                    }
                } else {
                    MythsAndLegends.getLogger().warn("Spawn was marked successful but SpawnDetail reference was null. Using generic success message.");
                    ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.success"));
                }
                return InteractionResult.SUCCESS;
            }
            boolean matchAttempted = contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).anyMatch(selectionPair -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selectionPair.getSecond(), keyItemIdentifierPath));
            if (!matchAttempted) {
                MythsAndLegends.getLogger().debug("Found contexts, but no spawn detail matched the specific key item condition: {}", (Object)keyItemIdentifierPath);
                ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.no_match", (Object[])new Object[]{keyItemIdentifierPath}));
            } else {
                ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.action_failed"));
            }
            return InteractionResult.FAIL;
        }
        catch (IllegalStateException e) {
            MythsAndLegends.getLogger().error("Failed to prospect area during force spawn: {}", (Object)area, (Object)e);
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.invalid_area"));
            return InteractionResult.FAIL;
        }
        catch (Exception e) {
            MythsAndLegends.getLogger().error("Unexpected error during force spawn process for key item {}", (Object)keyItemIdentifierPath, (Object)e);
            ForceSpawningUtils.sendFeedback(feedbackSource, playerEntity, (Component)Component.translatable((String)"commands.mythsandlegends.forcespawn.error.internal", (Object[])new Object[]{"Unexpected Error"}));
            return InteractionResult.FAIL;
        }
    }

    private static void sendFeedback(CommandSourceStack source, ServerPlayer player, Component message) {
        if (source != null) {
            source.sendFailure(message);
        } else if (player != null) {
            player.displayClientMessage(message, true);
        }
    }

    private static boolean isSpawnDetailForKeyItem(SpawnDetail detail, String keyItemIdentifierPath) {
        MythsAndLegends.getLogger().debug("Checking Detail: {} against KeyItemPath: {}", (Object)detail.getId(), (Object)keyItemIdentifierPath);
        for (SpawningCondition condition : detail.getConditions()) {
            List appendages = condition.getAppendages();
            for (AppendageCondition appendage : appendages) {
                ZygardeCubeChargeCondition zygardeCubeChargeCondition;
                KeyItemCondition keyItemCondition;
                ResourceLocation conditionIdentifier;
                if (appendage instanceof KeyItemCondition && (conditionIdentifier = (keyItemCondition = (KeyItemCondition)appendage).getKeyItemId()) != null && conditionIdentifier.getPath().equalsIgnoreCase(keyItemIdentifierPath)) {
                    MythsAndLegends.getLogger().debug("Match found via KeyItemCondition appendage: {}", (Object)conditionIdentifier);
                    return true;
                }
                if (!(appendage instanceof ZygardeCubeChargeCondition) || (zygardeCubeChargeCondition = (ZygardeCubeChargeCondition)appendage).getRequired_cells() <= 0 && zygardeCubeChargeCondition.getRequired_cores() <= 0) continue;
                return true;
            }
        }
        MythsAndLegends.getLogger().debug("No matching KeyItemCondition found for path: {}", (Object)keyItemIdentifierPath);
        return false;
    }

    public static void executeSpawnAction(SpawnAction<?> spawnAction) {
        spawnAction.complete();
        ((CompletableFuture)spawnAction.getFuture().thenAccept(result -> {
            if (result instanceof EntitySpawnResult) {
                EntitySpawnResult entitySpawnResult = (EntitySpawnResult)result;
            }
        })).exceptionally(throwable -> null);
    }

    private static void consumeAdditionalItemsAfterForceSpawn(ServerPlayer player, SpawnDetail detail, int consumptionMode) {
        if (consumptionMode == 0 || consumptionMode == 1) {
            MythsAndLegends.getLogger().debug("Force Spawn: Skipping additional item consumption for mode {}", (Object)consumptionMode);
            return;
        }
        MythsAndLegends.getLogger().debug("Force Spawn: Checking for additional items to consume for detail {} with mode {}", (Object)detail.getName(), (Object)consumptionMode);
        boolean removalAttempted = false;
        for (SpawningCondition condition : detail.getConditions()) {
            List appendages = condition.getAppendages();
            if (appendages == null || appendages.isEmpty()) continue;
            for (AppendageCondition appendage : appendages) {
                boolean consumeThis;
                if (appendage instanceof CustomItemsCondition) {
                    CustomItemsCondition customItemsCond = (CustomItemsCondition)appendage;
                    List<CustomItemsCondition.CustomItemCondition> items = customItemsCond.getItemConditions();
                    if (items == null) continue;
                    for (CustomItemsCondition.CustomItemCondition itemCond : items) {
                        boolean consumeThis2;
                        if (itemCond == null || itemCond.getItemId() == null) continue;
                        if (!(consumeThis2 = (switch (consumptionMode) {
                            case 2 -> true;
                            case 3 -> true;
                            case 4 -> itemCond.isConsume();
                            default -> false;
                        }))) continue;
                        MythsAndLegends.getLogger().debug("Force Spawn (Mode {}): Consuming additional Custom Item: {} x{}", (Object)consumptionMode, (Object)itemCond.getItemId(), (Object)itemCond.getCount());
                        InventoryUtils.removeItemFromInventory(player, ((Item)BuiltInRegistries.ITEM.get(itemCond.getItemId())).asItem(), itemCond.getCount(), MythsAndLegends.getConfigManager().getConfig().inventory_check_bundles, MythsAndLegends.getConfigManager().getConfig().inventory_check_bundles);
                        removalAttempted = true;
                    }
                    continue;
                }
                if (!(appendage instanceof ZygardeCubeChargeCondition)) continue;
                ZygardeCubeChargeCondition zygardeCond = (ZygardeCubeChargeCondition)appendage;
                if (!(consumeThis = (switch (consumptionMode) {
                    case 2 -> true;
                    case 3 -> true;
                    default -> false;
                }))) continue;
                int cells = zygardeCond.getRequired_cells();
                int cores = zygardeCond.getRequired_cores();
                if (cells <= 0 && cores <= 0) continue;
                MythsAndLegends.getLogger().debug("Force Spawn (Mode {}): Consuming additional Zygarde components: {} cells, {} cores", (Object)consumptionMode, (Object)cells, (Object)cores);
                ForceSpawningUtils.removeZygardeComponentsFromPlayer(player, cells, cores);
                removalAttempted = true;
            }
        }
        if (removalAttempted) {
            MythsAndLegends.getLogger().debug("Force Spawn: Additional item consumption finished for mode {}. Triggering inventory update.", (Object)consumptionMode);
            PlayerDataUtils.updatePlayerData((Player)player);
        } else {
            MythsAndLegends.getLogger().debug("Force Spawn: No additional items required or consumed for mode {}.", (Object)consumptionMode);
        }
    }

    private static boolean removeZygardeComponentsFromPlayer(ServerPlayer player, int cellsToRemove, int coresToRemove) {
        boolean overallSuccess;
        if (cellsToRemove <= 0 && coresToRemove <= 0) {
            MythsAndLegends.getLogger().trace("Force Spawn Removal: No Zygarde components specified for removal.");
            return false;
        }
        ItemStack zygardeCubeStack = ZygardeUtil.findZygardeCube(player);
        if (zygardeCubeStack == null || zygardeCubeStack.isEmpty()) {
            MythsAndLegends.getLogger().warn("Force Spawn Removal: Could not find a Zygarde Cube in {}'s inventory.", (Object)player.getName().getString());
            DebtUtils debtUtils = MythsAndLegends.getDebtUtils();
            UUID playerUuid = player.getUUID();
            boolean debtAdded = false;
            if (cellsToRemove > 0) {
                ResourceLocation cellId = Items.ZYGARDE_CELL.getId();
                if (cellId != null) {
                    MythsAndLegends.getLogger().debug("Force Spawn Removal: Adding debt for {} cells (cube not found).", (Object)cellsToRemove);
                    debtUtils.addDebt(playerUuid, cellId, cellsToRemove);
                    debtAdded = true;
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Cell debt: Cell Item ID is null!");
                }
            }
            if (coresToRemove > 0) {
                ResourceLocation coreId = Items.ZYGARDE_CORE.getId();
                if (coreId != null) {
                    MythsAndLegends.getLogger().debug("Force Spawn Removal: Adding debt for {} cores (cube not found).", (Object)coresToRemove);
                    debtUtils.addDebt(playerUuid, coreId, coresToRemove);
                    debtAdded = true;
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Core debt: Core Item ID is null!");
                }
            }
            return false;
        }
        MythsAndLegends.getLogger().debug("Force Spawn Removal: Found Zygarde Cube. Attempting to remove {} cells, {} cores.", (Object)cellsToRemove, (Object)coresToRemove);
        int cellsActuallyRemoved = 0;
        int coresActuallyRemoved = 0;
        boolean fullCellRemoval = true;
        boolean fullCoreRemoval = true;
        if (cellsToRemove > 0) {
            cellsActuallyRemoved = ZygardeCubeBundleItem.removeCells(zygardeCubeStack, cellsToRemove);
            if (cellsActuallyRemoved != cellsToRemove) {
                fullCellRemoval = false;
                int debtCells = cellsToRemove - cellsActuallyRemoved;
                MythsAndLegends.getLogger().warn("Force Spawn Removal: Failed to remove required {} cells. Removed: {}. Adding debt for {}.", (Object)cellsToRemove, (Object)cellsActuallyRemoved, (Object)debtCells);
                ResourceLocation cellId = Items.ZYGARDE_CELL.getId();
                if (cellId != null) {
                    MythsAndLegends.getDebtUtils().addDebt(player.getUUID(), cellId, debtCells);
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Cell debt: Cell Item ID is null!");
                }
            } else {
                MythsAndLegends.getLogger().debug("Force Spawn Removal: Successfully removed {} cells.", (Object)cellsActuallyRemoved);
            }
        }
        if (coresToRemove > 0) {
            coresActuallyRemoved = ZygardeCubeBundleItem.removeCores(zygardeCubeStack, coresToRemove);
            if (coresActuallyRemoved != coresToRemove) {
                fullCoreRemoval = false;
                int debtCores = coresToRemove - coresActuallyRemoved;
                MythsAndLegends.getLogger().warn("Force Spawn Removal: Failed to remove required {} cores. Removed: {}. Adding debt for {}.", (Object)coresToRemove, (Object)coresActuallyRemoved, (Object)debtCores);
                ResourceLocation coreId = Items.ZYGARDE_CORE.getId();
                if (coreId != null) {
                    MythsAndLegends.getDebtUtils().addDebt(player.getUUID(), coreId, debtCores);
                } else {
                    MythsAndLegends.getLogger().error("Cannot add Zygarde Core debt: Core Item ID is null!");
                }
            } else {
                MythsAndLegends.getLogger().debug("Force Spawn Removal: Successfully removed {} cores.", (Object)coresActuallyRemoved);
            }
        }
        player.getInventory().setChanged();
        boolean bl = overallSuccess = fullCellRemoval && fullCoreRemoval;
        if (overallSuccess) {
            MythsAndLegends.getLogger().info("Force Spawn Removal: Successfully removed exact required amounts ({} cells, {} cores) from Zygarde Cube.", (Object)cellsToRemove, (Object)coresToRemove);
        } else {
            MythsAndLegends.getLogger().warn("Force Spawn Removal: Failed to remove exact required amounts (Needed:{}/{}, Removed:{}/{}. Debt may have been added.", (Object)cellsToRemove, (Object)coresToRemove, (Object)cellsActuallyRemoved, (Object)coresActuallyRemoved);
        }
        return overallSuccess;
    }
}

