/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class PlayerDataUtils {
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static ConfigVariables modConfig;

    public static void setModConfig(ConfigVariables config) {
        modConfig = config;
    }

    public static PlayerData getPlayerData(Player player) {
        return playerDataMap.computeIfAbsent(player.getUUID(), k -> new PlayerData());
    }

    public static void updatePlayerData(Player player) {
        PlayerData data = PlayerDataUtils.getPlayerData(player);
        data.clearTrackedData();
        HashMap<Item, Integer> currentItemCounts = new HashMap<Item, Integer>();
        DebtUtils debtUtils = MythsAndLegends.getDebtUtils();
        debtUtils.loadDebts();
        Map<ResourceLocation, Integer> playerDebts = debtUtils.getDebtsForPlayer(player.getUUID());
        if (!playerDebts.isEmpty() && player instanceof ServerPlayer) {
            Iterator serverPlayerEntity = (ServerPlayer)player;
            for (Map.Entry<ResourceLocation, Integer> debtEntry : playerDebts.entrySet()) {
                ResourceLocation debtItemId = debtEntry.getKey();
                Optional debtItemOpt = BuiltInRegistries.ITEM.getOptional(debtItemId);
                if (debtItemOpt.isPresent()) {
                    int debtCount;
                    Item debtItem = (Item)debtItemOpt.get();
                    if (InventoryUtils.removeItemFromInventory(serverPlayerEntity, debtItem, debtCount = debtEntry.getValue().intValue(), false, false)) {
                        debtUtils.clearDebt(player.getUUID(), debtItemId);
                        MythsAndLegends.getLogger().info("Cleared debt for {} item {} x{}", (Object)player.getName().getString(), (Object)debtItemId, (Object)debtCount);
                        continue;
                    }
                    MythsAndLegends.getLogger().warn("Failed to remove debt item {} x{} for {}", (Object)debtItemId, (Object)debtCount, (Object)player.getName().getString());
                    continue;
                }
                MythsAndLegends.getLogger().error("Debt item ID not found in registry: {}", (Object)debtItemId);
            }
        }
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty()) continue;
            Item currentItem = stack.getItem();
            data.setItemState(currentItem, true);
            currentItemCounts.merge(currentItem, stack.getCount(), Integer::sum);
            if (PlayerDataUtils.modConfig.inventory_check_bundles && currentItem instanceof BundleItem) {
                PlayerDataUtils.checkItemsInContainer(stack, data, currentItemCounts);
            }
            if (!PlayerDataUtils.modConfig.inventory_check_shulker_boxes || !(currentItem instanceof BlockItem) || !(((BlockItem)currentItem).getBlock() instanceof ShulkerBoxBlock)) continue;
            PlayerDataUtils.checkItemsInContainer(stack, data, currentItemCounts);
        }
        for (Map.Entry entry : currentItemCounts.entrySet()) {
            data.setItemCount((Item)entry.getKey(), (Integer)entry.getValue());
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<Pokemon> currentParty = PlayerDataUtils.getPokemonsInPlayerParty(serverPlayer);
            data.setPartyPokemon(currentParty);
        } else {
            data.setPartyPokemon(Collections.emptyList());
        }
    }

    public static List<Pokemon> getPokemonsInPlayerParty(ServerPlayer player) {
        ArrayList<Pokemon> pokemons = new ArrayList<Pokemon>();
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (partyStore == null) {
            MythsAndLegends.getLogger().warn("Could not retrieve party store for player {}", (Object)player.getName().getString());
            return pokemons;
        }
        for (int slot = 0; slot < partyStore.size(); ++slot) {
            Pokemon pokemon = partyStore.get(slot);
            if (pokemon == null) continue;
            pokemons.add(pokemon);
        }
        return pokemons;
    }

    public static boolean hasPokemonSpeciesInParty(ServerPlayer player, Species speciesToCheck) {
        if (speciesToCheck == null) {
            return false;
        }
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (partyStore == null) {
            return false;
        }
        for (Pokemon partyPokemon : partyStore) {
            if (partyPokemon == null || !speciesToCheck.equals(partyPokemon.getSpecies())) continue;
            return true;
        }
        return false;
    }

    public static List<Species> getPokemonSpeciesInParty(ServerPlayer player) {
        ArrayList<Species> pokemonSpeciesInParty = new ArrayList<Species>();
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (partyStore == null) {
            return pokemonSpeciesInParty;
        }
        for (Pokemon partyPokemon : partyStore) {
            if (partyPokemon == null) continue;
            pokemonSpeciesInParty.add(partyPokemon.getSpecies());
        }
        return pokemonSpeciesInParty;
    }

    private static void checkItemsInContainer(ItemStack containerStack, PlayerData data, Map<Item, Integer> currentItemCounts) {
        block4: {
            ItemContainerContents containerComponent;
            Item containerItem;
            block3: {
                containerItem = containerStack.getItem();
                if (!(containerItem instanceof BundleItem)) break block3;
                BundleContents bundleContents = (BundleContents)containerStack.get(DataComponents.BUNDLE_CONTENTS);
                if (bundleContents == null) break block4;
                for (ItemStack bundleItem : bundleContents.itemsCopy()) {
                    if (bundleItem.isEmpty()) continue;
                    data.setItemState(bundleItem.getItem(), true);
                    currentItemCounts.merge(bundleItem.getItem(), bundleItem.getCount(), Integer::sum);
                }
                break block4;
            }
            if (containerItem instanceof BlockItem && ((BlockItem)containerItem).getBlock() instanceof ShulkerBoxBlock && (containerComponent = (ItemContainerContents)containerStack.get(DataComponents.CONTAINER)) != null) {
                for (ItemStack shulkerItem : containerComponent.nonEmptyItems()) {
                    if (shulkerItem.isEmpty()) continue;
                    data.setItemState(shulkerItem.getItem(), true);
                    currentItemCounts.merge(shulkerItem.getItem(), shulkerItem.getCount(), Integer::sum);
                }
            }
        }
    }

    public static class PlayerData {
        private final Map<Item, Boolean> itemStates = new HashMap<Item, Boolean>();
        private final Map<Item, Integer> itemCounts = new HashMap<Item, Integer>();
        private List<Pokemon> partyPokemon = new ArrayList<Pokemon>();

        public void clearTrackedData() {
            this.itemStates.clear();
            this.itemCounts.clear();
            this.partyPokemon.clear();
        }

        public void setItemState(Item item, boolean hasItem) {
            if (hasItem) {
                this.itemStates.put(item, true);
            }
        }

        public boolean hasItem(Item item) {
            return this.itemStates.getOrDefault(item, false);
        }

        public void setItemCount(Item item, int count) {
            if (count <= 0) {
                this.itemCounts.remove(item);
                this.itemStates.remove(item);
            } else {
                this.itemCounts.put(item, count);
                this.itemStates.put(item, true);
            }
        }

        public int getItemCount(Item item) {
            return this.itemCounts.getOrDefault(item, 0);
        }

        public String getFormattedItemsWithCounts() {
            if (this.itemCounts.isEmpty()) {
                return "";
            }
            StringBuilder itemsWithCounts = new StringBuilder();
            ArrayList<Item> sortedItems = new ArrayList<Item>(this.itemCounts.keySet());
            sortedItems.sort(Comparator.comparing(item -> BuiltInRegistries.ITEM.getKey(item).toString()));
            for (Item item2 : sortedItems) {
                int itemCount = this.itemCounts.get(item2);
                String itemName = item2.getDescription().getString();
                if (itemName == null || itemName.isEmpty()) {
                    itemName = BuiltInRegistries.ITEM.getKey((Object)item2).getPath();
                }
                itemsWithCounts.append(itemName).append(": ").append(itemCount).append(", ");
            }
            if (itemsWithCounts.length() > 2) {
                itemsWithCounts.setLength(itemsWithCounts.length() - 2);
            }
            return itemsWithCounts.toString();
        }

        public void setPartyPokemon(List<Pokemon> party) {
            this.partyPokemon = new ArrayList<Pokemon>(party != null ? party : Collections.emptyList());
        }

        public List<Pokemon> getPartyPokemon() {
            return Collections.unmodifiableList(this.partyPokemon);
        }

        public List<Species> getPartyPokemonSpecies() {
            return this.partyPokemon.stream().map(Pokemon::getSpecies).collect(Collectors.toList());
        }

        public boolean hasPokemonSpeciesInParty(Species speciesToCheck) {
            if (speciesToCheck == null) {
                return false;
            }
            for (Pokemon p : this.partyPokemon) {
                if (!speciesToCheck.equals(p.getSpecies())) continue;
                return true;
            }
            return false;
        }

        public boolean hasPokemonSpeciesInParty(String speciesName) {
            if (speciesName == null || speciesName.trim().isEmpty()) {
                return false;
            }
            String lowerCaseName = speciesName.trim().toLowerCase();
            for (Pokemon p : this.partyPokemon) {
                if (!p.getSpecies().getName().toLowerCase().equals(lowerCaseName)) continue;
                return true;
            }
            return false;
        }
    }
}

