/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public class PlayerPartyUtils {
    public static List<Pokemon> getPokemonsInPlayerParty(ServerPlayer player) {
        ArrayList<Pokemon> pokemons = new ArrayList<Pokemon>();
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        for (int slot = 0; slot < 6; ++slot) {
            Pokemon pokemon = partyStore.get(slot);
            if (pokemon == null) continue;
            pokemons.add(pokemon);
        }
        return pokemons;
    }

    public static boolean hasPokemonInParty(ServerPlayer player, Pokemon pokemonToCheck) {
        List<Pokemon> partyPokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        for (Pokemon partyPokemon : partyPokemons) {
            if (!partyPokemon.getSpecies().getName().equals(pokemonToCheck.getSpecies().getName())) continue;
            return true;
        }
        return false;
    }

    public static List<Species> hasPokemonSpeciesInParty(ServerPlayer player) {
        ArrayList<Species> pokemonSpeciesInParty = new ArrayList<Species>();
        List<Pokemon> partyPokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        for (Pokemon partyPokemon : partyPokemons) {
            pokemonSpeciesInParty.add(partyPokemon.getSpecies());
        }
        return pokemonSpeciesInParty;
    }
}

