/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.References;

public class PortItemIdFix
extends DataFix {
    public PortItemIdFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type itemStackType = this.getInputSchema().getType(References.ITEM_STACK);
        String oldPrefix = "myths_and_legends:";
        String newPrefix = "mythsandlegends:";
        return this.fixTypeEverywhereTyped("MythsAndLegendsPortItemIdFix", itemStackType, typed -> typed.update(DSL.remainderFinder(), nbt -> this.fixStack((Dynamic<?>)nbt, "myths_and_legends:", "mythsandlegends:")));
    }

    private Dynamic<?> fixStack(Dynamic<?> nbt, String oldPrefix, String newPrefix) {
        String id = nbt.get("id").asString("");
        if (id.startsWith(oldPrefix)) {
            String path = id.substring(oldPrefix.length());
            String newId = newPrefix + path;
            return nbt.set("id", nbt.createString(newId));
        }
        return nbt;
    }
}

