/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.events;

import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.configs.BroadcastConfig;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class SpawnEventListener {
    public static void onPokemonSpawn(SpawnEvent<PokemonEntity> event) {
        boolean sendWaypointMessage;
        PlayerSpawner playerSpawner;
        boolean shouldBroadcastShiny;
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        boolean isBroadcastEnabled = config.isBroadcastEnabled;
        if (!isBroadcastEnabled) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)event.getEntity();
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.isPlayerOwned()) {
            return;
        }
        boolean isLegendary = pokemon.isLegendary();
        boolean isMythical = pokemon.isMythical();
        boolean isUltraBeast = pokemon.isUltraBeast();
        boolean isShiny = pokemon.getShiny();
        boolean bl = shouldBroadcastShiny = SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny") && isShiny;
        if (!(isLegendary || isMythical || isUltraBeast || shouldBroadcastShiny)) {
            return;
        }
        SpawnablePosition spawnablePosition = event.getSpawnablePosition();
        Spawner spawner = spawnablePosition.getSpawner();
        class_3222 player = null;
        MinecraftServer server = null;
        class_3218 world = spawnablePosition.getWorld();
        if (spawner instanceof PlayerSpawner && (player = MythsAndLegendsConditions.getPlayerFromUUID(world, (playerSpawner = (PlayerSpawner)spawner).getUuid())) != null) {
            server = player.method_5682();
        }
        if (server == null && world != null) {
            server = world.method_8503();
        }
        if (server == null) {
            System.err.println("MythsAndLegends: Could not obtain MinecraftServer instance for broadcasting.");
            return;
        }
        class_5250 PokemonDisplayName = pokemon.getDisplayName(true);
        String pokemonNameString = pokemon.getDisplayName(true).getString();
        class_2338 pos = pokemonEntity.method_24515();
        class_5250 message = class_2561.method_43469((String)"chat.mythsandlegends.broadcast.spawn", (Object[])new Object[]{PokemonDisplayName});
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Location")) {
            message.method_10852((class_2561)class_2561.method_43469((String)"chat.mythsandlegends.broadcast.location", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27692(class_124.field_1060));
        }
        if (pokemon.isLegendary() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Legendarys")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.mythsandlegends.broadcast.legendary").method_27692(class_124.field_1065));
        }
        if (pokemon.isMythical() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Mythicals")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.mythsandlegends.broadcast.mythical").method_27692(class_124.field_1064));
        }
        if (pokemon.isUltraBeast() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "UltraBeasts")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.mythsandlegends.broadcast.ultrabeast").method_27692(class_124.field_1062));
        }
        if (pokemon.getShiny() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.mythsandlegends.broadcast.shiny").method_27692(class_124.field_1076));
        }
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Level")) {
            int level = pokemon.getLevel();
            message.method_10852((class_2561)class_2561.method_43469((String)"chat.mythsandlegends.broadcast.level", (Object[])new Object[]{level}).method_27692(class_124.field_1054));
        }
        if (sendWaypointMessage = SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "XaerosMinimapSupport")) {
            class_5321 worldRegistryKey = world.method_27983();
            String dimensionName = worldRegistryKey.method_29177().method_12832();
            String waypointSet = "Internal-" + dimensionName + "-waypoints";
            String symbol = "P";
            int colorIndex = 8;
            String waypointString = String.format("xaero-waypoint:%s:%s:%d:%d:%d:%d:false:0:%s", pokemonNameString.replace(":", ""), symbol, pos.method_10263(), pos.method_10264(), pos.method_10260(), colorIndex, waypointSet);
            class_5250 waypointText = class_2561.method_43470((String)waypointString);
            if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "BroadcastToAll")) {
                SpawnEventListener.broadcastMessageToServer((class_2561)message, server);
                SpawnEventListener.broadcastMessageToServer((class_2561)waypointText, server);
            } else if (player != null) {
                player.method_7353((class_2561)message, false);
                player.method_7353((class_2561)waypointText, false);
            }
        } else if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "BroadcastToAll")) {
            if (server != null) {
                SpawnEventListener.broadcastMessageToServer((class_2561)message, server);
            }
        } else if (player != null) {
            player.method_7353((class_2561)message, false);
        }
    }

    public static boolean findBroadcastConfig(List<BroadcastConfig> settings, String settingName) {
        for (BroadcastConfig setting : settings) {
            if (!Objects.equals(setting.settingName, settingName)) continue;
            return setting.settingValue;
        }
        return false;
    }

    private static void broadcastMessageToServer(class_2561 message, MinecraftServer server) {
        if (server == null) {
            System.err.println("MythsAndLegends: Attempted to broadcast with null server!");
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(message, false);
        }
    }
}

