/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.commands;

import com.cobblemon.mod.common.api.permission.CobblemonPermission;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.KeyItemSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.PokemonSpeciesSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGui;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.items.KeyItem;
import com.github.d0ctorleon.mythsandlegends.permissions.MythsAndLegendsPermissions;
import com.github.d0ctorleon.mythsandlegends.utils.ForceSpawningUtils;
import com.github.d0ctorleon.mythsandlegends.utils.ItemCooldownStorage;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerPartyUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.text2speech.Narrator;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

public class Commands {
    private static final MythsAndLegendsPermissions PERMISSIONS = new MythsAndLegendsPermissions();
    private static final SimpleCommandExceptionType REQUIRES_PLAYER_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.mythsandlegends.error.requires_player"));
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.mythsandlegends.error.player_not_found"));
    private static final SimpleCommandExceptionType INVALID_SPECIES_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.mythsandlegends.error.invalid_species"));
    private static final SimpleCommandExceptionType INVALID_KEY_ITEM_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.mythsandlegends.error.invalid_key_item"));
    private static final DynamicCommandExceptionType INVALID_COOLDOWN_ITEM_EXCEPTION = new DynamicCommandExceptionType(itemName -> class_2561.method_43469((String)"commands.mythsandlegends.error.invalid_cooldown_item", (Object[])new Object[]{itemName}));
    private static final DynamicCommandExceptionType ITEM_NOT_TRACKED_EXCEPTION = new DynamicCommandExceptionType(itemName -> class_2561.method_43469((String)"commands.mythsandlegends.error.item_not_tracked", (Object[])new Object[]{itemName}));

    public static boolean hasPermission(class_2168 source, CobblemonPermission permission) {
        if (Objects.requireNonNull(source.method_44023()).method_5687(2)) {
            return true;
        }
        if (!source.method_43737()) {
            return true;
        }
        return MythsAndLegendsPermissions.checkPermission((class_2172)source, permission);
    }

    public static void registerCommands() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> Commands.register((CommandDispatcher<class_2168>)dispatcher, registryAccess));
        MythsAndLegends.getLogger().debug("Start registering commands");
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"mythsandlegends").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION));
        baseCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"items").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_ITEMS_PERMISSION))).executes(Commands::executeListItemsSelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executeListItemsTarget)));
        baseCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"syncitems").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_INVENTORY_PERMISSION))).executes(Commands::executeSyncItemsSelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executeSyncItemsTarget)));
        baseCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"party").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_POKEMON_PERMISSION))).executes(Commands::executeListPartySelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executeListPartyTarget)));
        baseCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"haspokemon").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_POKEMON_PERMISSION))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pokemon_species", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).executes(Commands::executeCheckPokemonSelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executeCheckPokemonTarget))));
        baseCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"placeifhas").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.SET_BLOCK_CHECK_SPECIES_PERMISSION))).then(class_2170.method_9244((String)"pokemon_species", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).executes(Commands::executePlaceIfHasSelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executePlaceIfHasTarget))))));
        baseCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).executes(Commands::executeOpenSettingsGui));
        LiteralArgumentBuilder cooldownCommand = class_2170.method_9247((String)"cooldown");
        cooldownCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"check").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_COOLDOWN_PERMISSION))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"item", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).executes(Commands::executeCheckCooldownSelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executeCheckCooldownTarget))));
        cooldownCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CLEAR_COOLDOWN_PERMISSION))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"item", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).executes(Commands::executeClearCooldownSelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executeClearCooldownTarget))));
        cooldownCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clearall").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CLEAR_ALL_COOLDOWNS_PERMISSION))).executes(Commands::executeClearAllCooldownsSelf)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Commands::executeClearAllCooldownsTarget)));
        baseCommand.then((ArgumentBuilder)cooldownCommand);
        dispatcher.register(baseCommand);
        baseCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"forcespawn").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.FORCE_SPAWN_PERMISSION))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"keyitem", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"consumeVoucher", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"ignoreCooldown", (ArgumentType)BoolArgumentType.bool()).executes(Commands::executeForceSpawnFullArgs))).executes(Commands::executeForceSpawnConsumeOnly))).executes(Commands::executeForceSpawnTargetOnly))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"consumeVoucher", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"ignoreCooldown", (ArgumentType)BoolArgumentType.bool()).executes(Commands::executeForceSpawnSelfFlags))).executes(Commands::executeForceSpawnSelfConsume))).executes(Commands::executeForceSpawnSelfOnly)));
        dispatcher.register(baseCommand);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mal").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).redirect(dispatcher.getRoot().getChild("mythsandlegends")));
        MythsAndLegends.getLogger().info("Registered Myths and Legends commands (using /mythsandlegends or /mal)");
    }

    private static boolean getOptionalBoolean(CommandContext<class_2168> context, String argName, boolean defaultValue) {
        try {
            return BoolArgumentType.getBool(context, (String)argName);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private static class_3222 getTargetPlayerOptional(CommandContext<class_2168> context, String argumentName) throws CommandSyntaxException {
        try {
            return class_2186.method_9315(context, (String)argumentName);
        }
        catch (IllegalArgumentException e) {
            class_2168 source = (class_2168)context.getSource();
            if (source.method_44023() != null) {
                return source.method_9207();
            }
            throw REQUIRES_PLAYER_EXCEPTION.create();
        }
    }

    private static int executeListItemsSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        return Commands.listItems(((class_2168)context.getSource()).method_9207(), (class_2168)context.getSource());
    }

    private static int executeListItemsTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        return Commands.listItems(class_2186.method_9315(context, (String)"player"), (class_2168)context.getSource());
    }

    private static int listItems(class_3222 player, class_2168 feedbackSource) {
        PlayerDataUtils.PlayerData playerData = PlayerDataUtils.getPlayerData((class_1657)player);
        String itemsWithCounts = playerData.getFormattedItemsWithCounts();
        String playerName = player.method_5477().getString();
        if (itemsWithCounts.isEmpty()) {
            feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.items.none", (Object[])new Object[]{playerName}), false);
        } else {
            feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.items.success", (Object[])new Object[]{playerName, itemsWithCounts}), false);
        }
        return 1;
    }

    private static int executeSyncItemsSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        return Commands.syncItems(((class_2168)context.getSource()).method_9207(), (class_2168)context.getSource());
    }

    private static int executeSyncItemsTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        return Commands.syncItems(class_2186.method_9315(context, (String)"player"), (class_2168)context.getSource());
    }

    private static int syncItems(class_3222 player, class_2168 feedbackSource) {
        PlayerDataUtils.updatePlayerData((class_1657)player);
        feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.syncitems.success", (Object[])new Object[]{player.method_5477().getString()}), false);
        return 1;
    }

    private static int executeListPartySelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        return Commands.listParty(((class_2168)context.getSource()).method_9207(), (class_2168)context.getSource());
    }

    private static int executeListPartyTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        return Commands.listParty(class_2186.method_9315(context, (String)"player"), (class_2168)context.getSource());
    }

    private static int listParty(class_3222 player, class_2168 feedbackSource) {
        List<Pokemon> pokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        String playerName = player.method_5477().getString();
        if (pokemons.isEmpty()) {
            feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.party.none", (Object[])new Object[]{playerName}), false);
        } else {
            String pokemonList = pokemons.stream().map(pokemon -> String.format("%s (%s)", pokemon.getDisplayName(true).getString(), pokemon.getSpecies().getName())).collect(Collectors.joining(", "));
            feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.party.success", (Object[])new Object[]{playerName, pokemonList}), false);
        }
        return 1;
    }

    private static int executeCheckPokemonSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        String speciesNameToCheck = StringArgumentType.getString(context, (String)"pokemon_species");
        return Commands.checkPokemon(((class_2168)context.getSource()).method_9207(), speciesNameToCheck, (class_2168)context.getSource());
    }

    private static int executeCheckPokemonTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        String speciesNameToCheck = StringArgumentType.getString(context, (String)"pokemon_species");
        return Commands.checkPokemon(class_2186.method_9315(context, (String)"player"), speciesNameToCheck, (class_2168)context.getSource());
    }

    private static int checkPokemon(class_3222 player, String speciesNameToCheck, class_2168 feedbackSource) throws CommandSyntaxException {
        if (Commands.isValidSpecies(speciesNameToCheck)) {
            throw INVALID_SPECIES_EXCEPTION.create();
        }
        String playerName = player.method_5477().getString();
        if (Commands.hasPokemon(player, speciesNameToCheck)) {
            feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.haspokemon.yes", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
        } else {
            feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.haspokemon.no", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
        }
        return 1;
    }

    private static int executePlaceIfHasSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String speciesName = StringArgumentType.getString(context, (String)"pokemon_species");
        class_2338 pos = class_2262.method_9696(context, (String)"pos");
        class_2247 block = class_2257.method_9655(context, (String)"block");
        return Commands.placeIfHas(player, speciesName, pos, block, (class_2168)context.getSource());
    }

    private static int executePlaceIfHasTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        String speciesName = StringArgumentType.getString(context, (String)"pokemon_species");
        class_2338 pos = class_2262.method_9696(context, (String)"pos");
        class_2247 block = class_2257.method_9655(context, (String)"block");
        return Commands.placeIfHas(player, speciesName, pos, block, (class_2168)context.getSource());
    }

    private static int placeIfHas(class_3222 playerToCheck, String speciesName, class_2338 pos, class_2247 block, class_2168 feedbackSource) throws CommandSyntaxException {
        if (Commands.isValidSpecies(speciesName)) {
            throw INVALID_SPECIES_EXCEPTION.create();
        }
        String playerName = playerToCheck.method_5477().getString();
        if (!Commands.hasPokemon(playerToCheck, speciesName)) {
            feedbackSource.method_9213((class_2561)class_2561.method_43469((String)"commands.mythsandlegends.placeifhas.failure_condition", (Object[])new Object[]{playerName, speciesName}));
            return 0;
        }
        class_3218 world = feedbackSource.method_9225();
        if (!block.method_9495(world, pos, 2)) {
            feedbackSource.method_9213((class_2561)class_2561.method_43469((String)"commands.mythsandlegends.placeifhas.failure_setblock", (Object[])new Object[]{block.method_9494().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260()}));
            Narrator.LOGGER.error("Failed to set block {} at {}", (Object)block.method_9494().toString(), (Object)pos);
            return 0;
        }
        feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.placeifhas.success", (Object[])new Object[]{block.method_9494().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260(), playerName, speciesName}), true);
        return 1;
    }

    private static int executeForceSpawnFullArgs(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = BoolArgumentType.getBool(context, (String)"ignoreCooldown");
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (class_2168)context.getSource());
    }

    private static int executeForceSpawnConsumeOnly(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (class_2168)context.getSource());
    }

    private static int executeForceSpawnTargetOnly(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = false;
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (class_2168)context.getSource());
    }

    private static int executeForceSpawnSelfFlags(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = ((class_2168)context.getSource()).method_9207();
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = BoolArgumentType.getBool(context, (String)"ignoreCooldown");
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (class_2168)context.getSource());
    }

    private static int executeForceSpawnSelfConsume(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = ((class_2168)context.getSource()).method_9207();
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (class_2168)context.getSource());
    }

    private static int executeForceSpawnSelfOnly(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = ((class_2168)context.getSource()).method_9207();
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = false;
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (class_2168)context.getSource());
    }

    private static int forceSpawn(class_3222 player, String keyItemIdentifierPath, boolean consumeVoucher, boolean ignoreCooldown, class_2168 feedbackSource) throws CommandSyntaxException {
        class_2960 itemId = class_2960.method_60655((String)"mythsandlegends", (String)keyItemIdentifierPath);
        class_1792 keyItem = class_7923.field_41178.method_17966(itemId).orElse(null);
        if (keyItem == null || !(keyItem instanceof KeyItem)) {
            throw INVALID_KEY_ITEM_EXCEPTION.create();
        }
        class_1269 result = ForceSpawningUtils.forceSpawnByKeyItem(player.method_37908(), player, keyItemIdentifierPath, consumeVoucher, ignoreCooldown, feedbackSource);
        String playerName = player.method_5477().getString();
        switch (result) {
            case field_5812: {
                feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.forcespawn.success", (Object[])new Object[]{playerName, keyItemIdentifierPath}), true);
                return 1;
            }
            case field_51370: {
                feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.forcespawn.success_no_spawn", (Object[])new Object[]{playerName, keyItemIdentifierPath}), false);
                return 1;
            }
            case field_5814: {
                return 0;
            }
        }
        MythsAndLegends.getLogger().warn("Unhandled ActionResult from forceSpawnByKeyItem: " + String.valueOf(result));
        feedbackSource.method_9213((class_2561)class_2561.method_43470((String)"An unexpected error occurred during force spawn."));
        return 0;
    }

    private static int executeOpenSettingsGui(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        ConfigGui configGui = new ConfigGui();
        configGui.openConfigGui(player, config, 1);
        source.method_9226(() -> class_2561.method_43471((String)"commands.mythsandlegends.settings.success"), true);
        return 1;
    }

    private static class_2960 getTrackedItemId(CommandContext<class_2168> context, String argName) throws CommandSyntaxException {
        class_2960 itemId = class_2232.method_9443(context, (String)argName);
        class_1792 item = class_7923.field_41178.method_17966(itemId).orElse(null);
        if (item == null) {
            throw INVALID_COOLDOWN_ITEM_EXCEPTION.create((Object)itemId.toString());
        }
        return itemId;
    }

    private static int executeCheckCooldownSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2960 itemId = Commands.getTrackedItemId(context, "item");
        return Commands.checkCooldown(player, itemId, (class_2168)context.getSource());
    }

    private static int executeCheckCooldownTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        class_2960 itemId = Commands.getTrackedItemId(context, "item");
        return Commands.checkCooldown(player, itemId, (class_2168)context.getSource());
    }

    private static int checkCooldown(class_3222 player, class_2960 itemId, class_2168 feedbackSource) {
        ItemCooldownStorage storage = MythsAndLegends.getItemCooldownStorage();
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        UUID playerId = player.method_5667();
        String playerName = player.method_5477().getString();
        String itemName = itemId.toString();
        class_1792 item = class_7923.field_41178.method_17966(itemId).orElse(null);
        if (item == null || !Items.KEY_ITEM_IDS.contains(itemId)) {
            feedbackSource.method_9213((class_2561)class_2561.method_43469((String)"commands.mythsandlegends.error.item_not_tracked", (Object[])new Object[]{itemName}));
            return 0;
        }
        Map<class_2960, List<Long>> playerCooldowns = storage.getCooldownsForPlayer(playerId);
        List specificTimestamps = playerCooldowns.getOrDefault(itemId, List.of());
        int baseMaxVouchers = config.force_spawning_vouchers;
        int baseCooldownSeconds = config.force_spawn_item_cooldown;
        int remainingTicks = ItemCooldownStorage.calculateRemainingCooldownTicks(storage, playerId, item, baseCooldownSeconds);
        String remainingTimeStr = Commands.formatTicksToTime(remainingTicks);
        boolean hasEnough = storage.hasEnoughVouchers(playerId, item, 1, baseMaxVouchers);
        class_5250 statusText = class_2561.method_43470((String)"");
        if (config.global_item_cooldown || config.global_item_vouchers) {
            statusText.method_10852((class_2561)class_2561.method_43471((String)"commands.mythsandlegends.cooldown.check.global_note"));
            if (config.global_item_cooldown) {
                long l = playerCooldowns.getOrDefault(ItemCooldownStorage.GLOBAL_COOLDOWN_ID, List.of()).stream().findFirst().orElse(0L);
            }
            if (config.global_item_vouchers) {
                int totalUsed = 0;
                for (Map.Entry<class_2960, List<Long>> entry : playerCooldowns.entrySet()) {
                    if (entry.getKey().equals((Object)ItemCooldownStorage.GLOBAL_COOLDOWN_ID) || !Items.KEY_ITEM_IDS.contains(entry.getKey())) continue;
                    totalUsed += entry.getValue().size();
                }
                statusText.method_10852((class_2561)class_2561.method_43469((String)"commands.mythsandlegends.cooldown.check.global_vouchers", (Object[])new Object[]{totalUsed, baseMaxVouchers}));
            }
        }
        statusText.method_10852((class_2561)class_2561.method_43469((String)"commands.mythsandlegends.cooldown.check.status", (Object[])new Object[]{playerName, itemName, specificTimestamps.size(), baseMaxVouchers, remainingTimeStr, hasEnough ? class_2561.method_43471((String)"commands.mythsandlegends.cooldown.check.can_use") : class_2561.method_43471((String)"commands.mythsandlegends.cooldown.check.cannot_use")}));
        feedbackSource.method_9226(() -> statusText, false);
        return 1;
    }

    private static int executeClearCooldownSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2960 itemId = Commands.getTrackedItemId(context, "item");
        return Commands.clearCooldown(player, itemId, (class_2168)context.getSource());
    }

    private static int executeClearCooldownTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        class_2960 itemId = Commands.getTrackedItemId(context, "item");
        return Commands.clearCooldown(player, itemId, (class_2168)context.getSource());
    }

    private static int clearCooldown(class_3222 player, class_2960 itemId, class_2168 feedbackSource) {
        ItemCooldownStorage storage = MythsAndLegends.getItemCooldownStorage();
        storage.clearCooldown(player.method_5667(), itemId);
        feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.cooldown.clear.success", (Object[])new Object[]{player.method_5477().getString(), itemId.toString()}), true);
        return 1;
    }

    private static int executeClearAllCooldownsSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return Commands.clearAllCooldowns(player, (class_2168)context.getSource());
    }

    private static int executeClearAllCooldownsTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        return Commands.clearAllCooldowns(player, (class_2168)context.getSource());
    }

    private static int clearAllCooldowns(class_3222 player, class_2168 feedbackSource) {
        ItemCooldownStorage storage = MythsAndLegends.getItemCooldownStorage();
        storage.clearAllCooldowns(player.method_5667());
        feedbackSource.method_9226(() -> class_2561.method_43469((String)"commands.mythsandlegends.cooldown.clearall.success", (Object[])new Object[]{player.method_5477().getString()}), true);
        return 1;
    }

    private static boolean isValidSpecies(String speciesName) {
        return PokemonSpecies.INSTANCE.getSpecies().stream().noneMatch(species -> species.getName().equalsIgnoreCase(speciesName));
    }

    private static boolean hasPokemon(class_3222 player, String speciesName) {
        return PlayerPartyUtils.getPokemonsInPlayerParty(player).stream().anyMatch(pokemon -> pokemon.getSpecies().getName().equalsIgnoreCase(speciesName));
    }

    public static String formatTicksToTime(int ticks) {
        if (ticks <= 0) {
            return "0s";
        }
        long totalSeconds = ticks / 20;
        long minutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
        long seconds = totalSeconds % 60L;
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }
}

