/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.events;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.FormChangeConfig;
import com.github.d0ctorleon.mythsandlegends.net.SyncTransformConfigPacket;
import com.github.d0ctorleon.mythsandlegends.utils.FusionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.InteractionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationConfig;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import java.util.HashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class PlayerEvents {
    public PlayerEvents() {
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(this::onPlayerQuit);
        PlayerEvent.PLAYER_RESPAWN.register(this::onPlayerRespawn);
        PlayerEvent.PLAYER_CLONE.register(this::onPlayerClone);
        PlayerEvent.PICKUP_ITEM_POST.register(this::onItemPickup);
        MythsAndLegends.getLogger().info("Player Events Registered");
    }

    private void onPlayerJoin(class_3222 player) {
        MythsAndLegends.getLogger().info("Player {} joined, sending transformation config.", (Object)player.method_5477().getString());
        PlayerEvents.sendConfigToPlayer(player);
    }

    public static void sendConfigToPlayer(class_3222 player) {
        TransformationConfig serverConfig = FormChangeConfig.getConfig();
        HashSet<class_2960> fusionItems = new HashSet<class_2960>();
        HashSet<class_2960> interactionItems = new HashSet<class_2960>();
        for (FusionTransformation fusionTransformation : serverConfig.fusions) {
            if (fusionTransformation.item == null) continue;
            fusionItems.add(fusionTransformation.item);
        }
        for (InteractionTransformation interactionTransformation : serverConfig.interactionChanges) {
            if (interactionTransformation.item == null) continue;
            interactionItems.add(interactionTransformation.item);
        }
        SyncTransformConfigPacket packet = new SyncTransformConfigPacket(fusionItems, interactionItems);
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)packet);
        MythsAndLegends.getLogger().debug("Sent config to {}: {} fusion items, {} interaction items", (Object)player.method_5477().getString(), (Object)fusionItems.size(), (Object)interactionItems.size());
    }

    private void onPlayerQuit(class_3222 player) {
    }

    private void onPlayerRespawn(class_3222 player, boolean alive, class_1297.class_5529 reason) {
    }

    private void onPlayerClone(class_3222 oldPlayer, class_3222 newPlayer, boolean isDeath) {
    }

    private void onItemPickup(class_1657 player, class_1542 itemEntity, class_1799 stack) {
    }
}

