/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.gui;

import com.github.d0ctorleon.mythsandlegends.configs.BroadcastConfig;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGuiHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_747;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ConfigGui {
    public static final List<SettingInfo<?>> ALL_SETTINGS = new ArrayList();
    public static final int INVENTORY_SIZE = 54;
    public static final int PREVIOUS_BUTTON_SLOT = 46;
    public static final int NEXT_BUTTON_SLOT = 54;
    public static final int MAX_SETTINGS_PER_PAGE = 26;

    private static BroadcastConfig findBroadcastSetting(ConfigVariables config, String settingName) {
        return config.broadcast_settings.stream().filter(bs -> bs.settingName.equals(settingName)).findFirst().orElse(new BroadcastConfig(settingName, false));
    }

    public static int getTotalPages() {
        return (int)Math.ceil((double)ALL_SETTINGS.size() / 26.0);
    }

    public void openConfigGui(class_3222 player, ConfigVariables config, int currentPage) {
        int totalPages = ConfigGui.getTotalPages();
        currentPage = Math.max(0, Math.min(currentPage, totalPages - 1));
        class_1277 inventory = new class_1277(54);
        ConfigGui.populateInventoryForPage(inventory, config, currentPage, totalPages);
        int finalCurrentPage = currentPage;
        player.method_17355((class_3908)new class_747((syncId, playerInventory, playerEntity) -> new ConfigGuiHandler(syncId, playerEntity, (class_1263)inventory, config, finalCurrentPage), class_2561.method_30163((String)("MythsAndLegends Settings (Page " + (currentPage + 1) + "/" + totalPages + ")"))));
    }

    public static void populateInventoryForPage(class_1277 inventory, ConfigVariables config, int currentPage, int totalPages) {
        inventory.method_5448();
        int startIndex = currentPage * 26;
        int endIndex = Math.min(startIndex + 26, ALL_SETTINGS.size());
        boolean hasPreviousPage = currentPage > 0;
        boolean hasNextPage = currentPage < totalPages - 1;
        int currentSettingIndexOnPage = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            SettingInfo<?> setting = ALL_SETTINGS.get(i);
            int paperSlot = -1;
            int woolSlot = -1;
            boolean slotFound = false;
            while (!slotFound) {
                int row = currentSettingIndexOnPage / 9;
                int col = currentSettingIndexOnPage % 9;
                int potentialPaperSlot = row * 18 + col;
                if (hasPreviousPage && potentialPaperSlot == 37) {
                    ++currentSettingIndexOnPage;
                    continue;
                }
                paperSlot = potentialPaperSlot;
                woolSlot = paperSlot + 9;
                slotFound = true;
            }
            switch (setting.type.ordinal()) {
                case 0: {
                    ConfigGui.setupToggleSetting(inventory, paperSlot, woolSlot, setting.displayName, (Boolean)setting.getter.apply(config), setting.description);
                    break;
                }
                case 1: {
                    ConfigGui.setupCycleSetting(inventory, paperSlot, woolSlot, setting.displayName, (String)setting.getter.apply(config), setting.description, setting.cycleOptions);
                }
            }
            ++currentSettingIndexOnPage;
        }
        if (hasPreviousPage) {
            class_1799 prevButton = new class_1799((class_1935)class_1802.field_8107);
            prevButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"<< Previous Page").method_27692(class_124.field_1054));
            inventory.method_5447(46, prevButton);
        }
        if (hasNextPage) {
            class_1799 nextButton = new class_1799((class_1935)class_1802.field_8107);
            nextButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Next Page >>").method_27692(class_124.field_1054));
            inventory.method_5447(53, nextButton);
        }
    }

    private static void setupToggleSetting(class_1277 inventory, int paperSlot, int woolSlot, String settingName, boolean value, String description) {
        class_1799 paper = new class_1799((class_1935)class_1802.field_8407);
        paper.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)settingName).method_27692(class_124.field_1075));
        paper.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)description).method_27692(class_124.field_1080))));
        class_1799 wool = new class_1799((class_1935)(value ? class_1802.field_19049 : class_1802.field_19058));
        wool.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(value ? "Enabled" : "Disabled")).method_27692(value ? class_124.field_1060 : class_124.field_1061));
        wool.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)settingName).method_27692(class_124.field_1063))));
        if (paperSlot >= 0 && paperSlot < inventory.method_5439()) {
            inventory.method_5447(paperSlot, paper);
        }
        if (woolSlot >= 0 && woolSlot < inventory.method_5439()) {
            inventory.method_5447(woolSlot, wool);
        }
    }

    private static void setupCycleSetting(class_1277 inventory, int paperSlot, int woolSlot, String settingName, String currentValue, String description, List<String> possibleValues) {
        class_1799 paper = new class_1799((class_1935)class_1802.field_8407);
        paper.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)settingName).method_27692(class_124.field_1075));
        paper.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)description).method_27692(class_124.field_1080))));
        class_1799 wool = new class_1799((class_1935)class_1802.field_19054);
        wool.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)currentValue).method_27692(class_124.field_1076));
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)settingName).method_27692(class_124.field_1063));
        wool.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        if (paperSlot >= 0 && paperSlot < inventory.method_5439()) {
            inventory.method_5447(paperSlot, paper);
        }
        if (woolSlot >= 0 && woolSlot < inventory.method_5439()) {
            inventory.method_5447(woolSlot, wool);
        }
    }

    static {
        ALL_SETTINGS.add(new SettingInfo("item_consumption_mode", "Item Consumption Mode", "0:None, 1:Legacy, 2:ForceOnly, 3:Always, 4:FlagOnly. See comments. Default: 1", cfg -> cfg.item_consumption_mode, (cfg, val) -> {
            cfg.item_consumption_mode = (Integer)val;
        }, Arrays.asList("0", "1", "2", "3", "4"), true));
        ALL_SETTINGS.add(new SettingInfo("inventory_check_shulker_boxes", "Check Shulker Boxes", "Scans Shulker Boxes for items. Default: true.", cfg -> cfg.inventory_check_shulker_boxes, (cfg, val) -> {
            cfg.inventory_check_shulker_boxes = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("inventory_check_bundles", "Check Bundles", "Scans Bundles for items. Default: true.", cfg -> cfg.inventory_check_bundles, (cfg, val) -> {
            cfg.inventory_check_bundles = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("inventory_check_interval", "Inventory Check Interval", "Interval (ticks) for checking inventories. Default: 3600.", cfg -> cfg.inventory_check_interval, (cfg, val) -> {
            cfg.inventory_check_interval = (Integer)val;
        }, Arrays.asList("600", "1200", "1800", "3600", "7200", "14400"), true));
        ALL_SETTINGS.add(new SettingInfo("form_changes", "Enable Form Changes", "Enables/Disables Form Changes triggered by items. Default: true.", cfg -> cfg.form_changes, (cfg, val) -> {
            cfg.form_changes = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("enable_force_spawning", "Enable Force Spawning", "Allow players to force spawns with key items. Default: true.", cfg -> cfg.enable_force_spawning, (cfg, val) -> {
            cfg.enable_force_spawning = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("force_spawning_spawn_pool", "Force Spawn Pool", "Spawn pool for force spawning. Default: ultra-rare.", cfg -> cfg.force_spawning_spawn_pool, (cfg, val) -> {
            cfg.force_spawning_spawn_pool = (String)val;
        }, Arrays.asList("common", "uncommon", "rare", "ultra-rare"), false));
        ALL_SETTINGS.add(new SettingInfo("force_spawn_check_width", "Force Spawn Width", "Width range for force spawning check. Default: 100.", cfg -> cfg.force_spawn_check_width, (cfg, val) -> {
            cfg.force_spawn_check_width = (Integer)val;
        }, Arrays.asList("50", "75", "100", "125", "150"), true));
        ALL_SETTINGS.add(new SettingInfo("force_spawn_check_height", "Force Spawn Height", "Height range for force spawning check. Default: 50.", cfg -> cfg.force_spawn_check_height, (cfg, val) -> {
            cfg.force_spawn_check_height = (Integer)val;
        }, Arrays.asList("25", "50", "75", "100"), true));
        ALL_SETTINGS.add(new SettingInfo("enable_vouchers", "Enable Vouchers", "Master switch for voucher system on key items. Default: false.", cfg -> cfg.enable_vouchers, (cfg, val) -> {
            cfg.enable_vouchers = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("force_spawn_item_cooldown", "Item Cooldown (Seconds)", "Cooldown after using a key item (if vouchers enabled). Default: 20.", cfg -> cfg.force_spawn_item_cooldown, (cfg, val) -> {
            cfg.force_spawn_item_cooldown = (Integer)val;
        }, Arrays.asList("10", "20", "30", "60", "120", "300"), true));
        ALL_SETTINGS.add(new SettingInfo("global_item_cooldown", "Global Item Cooldown", "Cooldown applies to ALL key items after one use (if vouchers enabled). Default: false.", cfg -> cfg.global_item_cooldown, (cfg, val) -> {
            cfg.global_item_cooldown = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("force_spawning_vouchers", "Item Vouchers (Uses)", "Max uses before cooldown (if vouchers enabled). Default: 1.", cfg -> cfg.force_spawning_vouchers, (cfg, val) -> {
            cfg.force_spawning_vouchers = (Integer)val;
        }, Arrays.asList("1", "2", "3", "5", "10"), true));
        ALL_SETTINGS.add(new SettingInfo("global_item_vouchers", "Global Item Vouchers", "Voucher limit shared across ALL key items (if vouchers enabled). Default: false.", cfg -> cfg.global_item_vouchers, (cfg, val) -> {
            cfg.global_item_vouchers = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("isBroadcastEnabled", "Enable Broadcast Feature", "Toggles broadcasting feature on and off. Default: false.", cfg -> cfg.isBroadcastEnabled, (cfg, val) -> {
            cfg.isBroadcastEnabled = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("BroadcastToAll", "Broadcast Server-Wide", "Toggles Server-wide broadcasting on/off. Default: true.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"BroadcastToAll").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"BroadcastToAll").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("DisplayName", "Broadcast Pokemon Name", "Displays the name in the broadcast message. Default: true.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"DisplayName").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"DisplayName").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("Legendarys", "Broadcast Legendaries", "Broadcasts when a legendary Pokemon spawns. Default: true.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Legendarys").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Legendarys").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("Mythicals", "Broadcast Mythicals", "Broadcasts when a mythical Pokemon spawns. Default: true.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Mythicals").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Mythicals").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("UltraBeasts", "Broadcast Ultra Beasts", "Broadcasts when an Ultra Beast spawns. Default: false.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"UltraBeasts").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"UltraBeasts").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("Location", "Broadcast Location", "Includes the location in broadcast messages. Default: true.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Location").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Location").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("Shiny", "Broadcast Shiny Status", "Enables broadcasts about Shiny Status. Default: false.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Shiny").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Shiny").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("Level", "Broadcast Level", "Includes the level in the broadcast. Default: true.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Level").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"Level").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("XaerosMinimapSupport", "Broadcast Xaeros Waypoints", "Shares a Waypoint for the Location of the Pokemon. Default: false.", cfg -> ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"XaerosMinimapSupport").settingValue, (cfg, val) -> {
            ConfigGui.findBroadcastSetting((ConfigVariables)cfg, (String)"XaerosMinimapSupport").settingValue = val;
        }));
        ALL_SETTINGS.add(new SettingInfo("debug_mode", "Debug Mode", "Enables extra logging for debugging. Default: false.", cfg -> cfg.debug_mode, (cfg, val) -> {
            cfg.debug_mode = val;
        }));
    }

    public static class SettingInfo<T> {
        final String key;
        final String displayName;
        final String description;
        final SettingType type;
        final Function<ConfigVariables, T> getter;
        final BiConsumer<ConfigVariables, T> setter;
        final List<String> cycleOptions;

        SettingInfo(String key, String displayName, String description, Function<ConfigVariables, Boolean> getter, BiConsumer<ConfigVariables, Boolean> setter) {
            this.key = key;
            this.displayName = displayName;
            this.description = description;
            this.type = SettingType.TOGGLE;
            this.getter = getter;
            this.setter = setter;
            this.cycleOptions = null;
        }

        SettingInfo(String key, String displayName, String description, Function<ConfigVariables, ?> getter, BiConsumer<ConfigVariables, ?> setter, List<String> cycleOptions, boolean isInteger) {
            this.key = key;
            this.displayName = displayName;
            this.description = description;
            this.type = SettingType.CYCLE;
            if (isInteger) {
                this.getter = cfg -> String.valueOf(getter.apply((ConfigVariables)cfg));
                BiConsumer<ConfigVariables, ?> originalIntSetter = setter;
                this.setter = (cfg, stringValue) -> {
                    try {
                        Integer intValue = Integer.parseInt((String)stringValue);
                        originalIntSetter.accept((ConfigVariables)cfg, intValue);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Error parsing integer setting '" + key + "' from value: " + String.valueOf(stringValue));
                    }
                };
            } else {
                this.getter = getter;
                this.setter = setter;
            }
            this.cycleOptions = cycleOptions;
        }
    }

    public static enum SettingType {
        TOGGLE,
        CYCLE;

    }
}

