/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Unit;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class ZygardeUtil {
    private static final int CELLS_FORM_CHANGE_AMOUNT = 38;
    private static final int CORES_FORM_CHANGE_AMOUNT = 1;
    private static final int CELLS_COST_CHARGE = 48;
    private static final int CORE_COST_CHARGE = 3;

    public static void handleZygardeFormChange(class_3222 player, UUID pokemonId) {
        if (!MythsAndLegends.getConfigManager().getConfig().form_changes) {
            MythsAndLegends.getLogger().debug("Zygarde form change action ignored: form_changes config is false.");
            return;
        }
        if (player == null || player.method_51469() == null) {
            MythsAndLegends.getLogger().warn("Received Zygarde form change packet with null player or world.");
            return;
        }
        class_1297 entity = player.method_51469().method_14190(pokemonId);
        if (!(entity instanceof PokemonEntity)) {
            MythsAndLegends.getLogger().warn("Received Zygarde form change packet for non-Pokemon entity or invalid UUID: {}", (Object)pokemonId);
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        Pokemon targetPokemon = pokemonEntity.getPokemon();
        if (!targetPokemon.getSpecies().getName().equalsIgnoreCase("zygarde")) {
            MythsAndLegends.getLogger().warn("Player {} tried Zygarde form change on non-Zygarde species: {}", (Object)player.method_5477().getString(), (Object)targetPokemon.getSpecies().getName());
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.wrong_species"), false);
            return;
        }
        if (targetPokemon.getOwnerUUID() != null && !targetPokemon.getOwnerUUID().equals(player.method_5667())) {
            MythsAndLegends.getLogger().warn("Player {} tried Zygarde form change on Pokemon {} they don't own.", (Object)player.method_5477().getString(), (Object)pokemonId);
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.generic.not_owner"), false);
            return;
        }
        class_1799 zygardeCubeStack = ZygardeUtil.findZygardeCube(player);
        if (zygardeCubeStack.method_7960()) {
            MythsAndLegends.getLogger().debug("Player {} tried Zygarde form change without Zygarde Cube.", (Object)player.method_5477().getString());
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.cube_missing"), false);
            return;
        }
        targetPokemon.getSpecies().getForms().forEach(form -> System.out.println(form.getName()));
        System.out.println(targetPokemon.getSpecies().getStandardForm().getName());
        String currentForm = targetPokemon.getForm().getName();
        String targetForm = null;
        int cellsToRemove = 0;
        int coresToRemove = 0;
        int cellsToAdd = 0;
        int coresToAdd = 0;
        boolean possible = true;
        switch (currentForm) {
            case "Normal": {
                targetForm = "10%";
                cellsToAdd = 38;
                coresToAdd = 1;
                break;
            }
            case "10%": {
                targetForm = "normal";
                cellsToRemove = 38;
                coresToRemove = 1;
                break;
            }
            case "50%-C": {
                targetForm = "10%-C";
                cellsToAdd = 38;
                coresToAdd = 1;
                break;
            }
            case "10%-C": {
                targetForm = "50%-C";
                cellsToRemove = 38;
                coresToRemove = 1;
                break;
            }
            default: {
                MythsAndLegends.getLogger().debug("Player {} tried Zygarde form change on Zygarde in unsupported form for this action: {}", (Object)player.method_5477().getString(), (Object)currentForm);
                player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.change_invalid_form"), false);
                possible = false;
            }
        }
        if (!possible || targetForm == null) {
            return;
        }
        boolean canProceed = true;
        if (cellsToRemove > 0 || coresToRemove > 0) {
            boolean hasCores;
            currentCells = ZygardeCubeBundleItem.getCellCount(zygardeCubeStack);
            currentCores = ZygardeCubeBundleItem.getCoreCount(zygardeCubeStack);
            boolean hasCells = currentCells >= cellsToRemove;
            boolean bl = hasCores = currentCores >= coresToRemove;
            if (!hasCells || !hasCores) {
                MythsAndLegends.getLogger().debug("Player {} lacks resources for Zygarde form change {} -> {}. Needs {} Cells, {} Cores. Has {} Cells, {} Cores.", (Object)player.method_5477().getString(), (Object)currentForm, (Object)targetForm, (Object)cellsToRemove, (Object)coresToRemove, (Object)currentCells, (Object)currentCores);
                player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.feedback.zygarde.insufficient_resources_detailed", (Object[])new Object[]{cellsToRemove, coresToRemove}), false);
                canProceed = false;
            }
        } else if (cellsToAdd > 0 || coresToAdd > 0) {
            boolean hasSpaceForCores;
            currentCells = ZygardeCubeBundleItem.getCellCount(zygardeCubeStack);
            currentCores = ZygardeCubeBundleItem.getCoreCount(zygardeCubeStack);
            boolean hasSpaceForCells = currentCells + cellsToAdd <= 95;
            boolean bl = hasSpaceForCores = currentCores + coresToAdd <= 5;
            if (!hasSpaceForCells || !hasSpaceForCores) {
                MythsAndLegends.getLogger().debug("Player {} cube lacks space for Zygarde form change {} -> {}. Needs space for {} Cells, {} Cores. Current: {}/{}, {}/{}. Has Space? Cells={}, Cores={}", new Object[]{player.method_5477().getString(), currentForm, targetForm, cellsToAdd, coresToAdd, currentCells, 95, currentCores, 5, hasSpaceForCells, hasSpaceForCores});
                player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.feedback.zygarde.insufficient_space_detailed", (Object[])new Object[]{cellsToAdd, coresToAdd}), false);
                canProceed = false;
            }
        }
        if (!canProceed) {
            return;
        }
        String finalTargetForm = targetForm;
        class_1799 finalZygardeCubeStack = zygardeCubeStack;
        int finalCellsToRemove = cellsToRemove;
        int finalCoresToRemove = coresToRemove;
        int finalCellsToAdd = cellsToAdd;
        int finalCoresToAdd = coresToAdd;
        String finalCurrentForm = currentForm;
        MythsAndLegends.getLogger().info("Attempting Zygarde transformation for {}: Current='{}', Target='{}'", (Object)player.method_5477().getString(), (Object)targetPokemon.getForm().getName(), (Object)finalTargetForm);
        MythsAndLegends.getLogger().info("Available forms for Zygarde species:");
        targetPokemon.getSpecies().getForms().forEach(form -> MythsAndLegends.getLogger().info(" - Form Name: '{}'", (Object)form.getName()));
        MythsAndLegends.getLogger().info("Standard form name: '{}'", (Object)targetPokemon.getSpecies().getStandardForm().getName());
        ZygardeUtil.attemptZygardeFormChange(targetPokemon, targetForm, false, success -> {
            if (success.booleanValue()) {
                boolean resourceUpdateSuccess = true;
                String changeDetail = "";
                int actualCellsChanged = 0;
                int actualCoresChanged = 0;
                if (finalCellsToRemove > 0 || finalCoresToRemove > 0) {
                    changeDetail = String.format("-%d Cells, -%d Cores", finalCellsToRemove, finalCoresToRemove);
                    actualCellsChanged = ZygardeCubeBundleItem.removeCells(finalZygardeCubeStack, finalCellsToRemove);
                    actualCoresChanged = ZygardeCubeBundleItem.removeCores(finalZygardeCubeStack, finalCoresToRemove);
                    if (actualCellsChanged != finalCellsToRemove || actualCoresChanged != finalCoresToRemove) {
                        MythsAndLegends.getLogger().error("Failed to REMOVE the correct amount of resources from Zygarde cube for player {} after form change {} -> {}! Expected: C={}, Co={}. Got: C={}, Co={}", (Object)player.method_5477().getString(), (Object)finalCurrentForm, (Object)finalTargetForm, (Object)finalCellsToRemove, (Object)finalCoresToRemove, (Object)actualCellsChanged, (Object)actualCoresChanged);
                        player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.resource_error"), true);
                        resourceUpdateSuccess = false;
                    }
                } else if (finalCellsToAdd > 0 || finalCoresToAdd > 0) {
                    changeDetail = String.format("+%d Cells, +%d Cores", finalCellsToAdd, finalCoresToAdd);
                    actualCellsChanged = ZygardeCubeBundleItem.addCells(finalZygardeCubeStack, finalCellsToAdd);
                    actualCoresChanged = ZygardeCubeBundleItem.addCores(finalZygardeCubeStack, finalCoresToAdd);
                    if (actualCellsChanged != finalCellsToAdd || actualCoresChanged != finalCoresToAdd) {
                        MythsAndLegends.getLogger().error("Failed to ADD the correct amount of resources to Zygarde cube for player {} after form change {} -> {}! Expected: C={}, Co={}. Got: C={}, Co={}", (Object)player.method_5477().getString(), (Object)finalCurrentForm, (Object)finalTargetForm, (Object)finalCellsToAdd, (Object)finalCoresToAdd, (Object)actualCellsChanged, (Object)actualCoresChanged);
                        player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.resource_error"), true);
                        resourceUpdateSuccess = false;
                    }
                }
                if (resourceUpdateSuccess) {
                    MythsAndLegends.getLogger().info("Player {} successfully changed Zygarde form from {} to {}. Resource change: {}", (Object)player.method_5477().getString(), (Object)finalCurrentForm, (Object)finalTargetForm, (Object)changeDetail);
                    player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.feedback.zygarde.change_success", (Object[])new Object[]{finalTargetForm}), false);
                    player.method_6104(class_1268.field_5808);
                }
            } else {
                MythsAndLegends.getLogger().warn("Zygarde form change from {} to {} failed for Player {}.", (Object)finalCurrentForm, (Object)finalTargetForm, (Object)player.method_5477().getString());
                player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.change_failed"), true);
            }
        });
    }

    public static void handleZygardeCharge(class_3222 player, UUID pokemonId) {
        boolean hasCores;
        if (!MythsAndLegends.getConfigManager().getConfig().form_changes) {
            MythsAndLegends.getLogger().debug("Zygarde charge action ignored: form_changes config is false.");
            return;
        }
        if (player == null || player.method_51469() == null) {
            MythsAndLegends.getLogger().warn("Received Zygarde charge packet with null player or world.");
            return;
        }
        class_1297 entity = player.method_51469().method_14190(pokemonId);
        if (!(entity instanceof PokemonEntity)) {
            MythsAndLegends.getLogger().warn("Received Zygarde charge packet for non-Pokemon entity or invalid UUID: {}", (Object)pokemonId);
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        Pokemon targetPokemon = pokemonEntity.getPokemon();
        if (!targetPokemon.getSpecies().getName().equalsIgnoreCase("zygarde")) {
            MythsAndLegends.getLogger().warn("Player {} tried Zygarde charge on non-Zygarde species: {}", (Object)player.method_5477().getString(), (Object)targetPokemon.getSpecies().getName());
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.wrong_species"), false);
            return;
        }
        if (targetPokemon.getOwnerUUID() != null && !targetPokemon.getOwnerUUID().equals(player.method_5667())) {
            MythsAndLegends.getLogger().warn("Player {} tried Zygarde charge on Pokemon {} they don't own.", (Object)player.method_5477().getString(), (Object)pokemonId);
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.generic.not_owner"), false);
            return;
        }
        class_1799 zygardeCubeStack = ZygardeUtil.findZygardeCube(player);
        if (zygardeCubeStack.method_7960()) {
            MythsAndLegends.getLogger().debug("Player {} tried Zygarde charge without Zygarde Cube.", (Object)player.method_5477().getString());
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.cube_missing"), false);
            return;
        }
        String currentForm = targetPokemon.getForm().getName().toLowerCase();
        String targetForm = null;
        int cellsNeeded = 0;
        int coresNeeded = 0;
        if (currentForm.equalsIgnoreCase("10%")) {
            targetForm = "10%-c";
            cellsNeeded = 48;
            coresNeeded = 3;
        } else if (currentForm.equalsIgnoreCase("normal")) {
            targetForm = "50%-c";
            cellsNeeded = 48;
            coresNeeded = 3;
        } else {
            if (currentForm.endsWith("-c")) {
                MythsAndLegends.getLogger().debug("Player {} tried Zygarde charge on already charged Zygarde.", (Object)player.method_5477().getString());
                player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.charge_already_charged"), false);
                return;
            }
            MythsAndLegends.getLogger().debug("Player {} tried Zygarde charge on Zygarde in unsupported form: {}", (Object)player.method_5477().getString(), (Object)currentForm);
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.charge_invalid_form"), false);
            return;
        }
        int currentCells = ZygardeCubeBundleItem.getCellCount(zygardeCubeStack);
        int currentCores = ZygardeCubeBundleItem.getCoreCount(zygardeCubeStack);
        boolean hasCells = currentCells >= cellsNeeded;
        boolean bl = hasCores = currentCores >= coresNeeded;
        if (!hasCells || !hasCores) {
            MythsAndLegends.getLogger().debug("Player {} lacks resources for Zygarde charge {} -> {}. Needed Cells/Cores: {}/{}. Has Cells? {}/{}. Has Cores? {}/{}", (Object)player.method_5477().getString(), (Object)currentForm, (Object)targetForm, (Object)cellsNeeded, (Object)coresNeeded, (Object)currentCells, (Object)cellsNeeded, (Object)currentCores, (Object)coresNeeded);
            player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.feedback.zygarde.insufficient_resources_detailed", (Object[])new Object[]{cellsNeeded, coresNeeded}), false);
            return;
        }
        String finalTargetForm = targetForm;
        class_1799 finalZygardeCubeStack = zygardeCubeStack;
        int finalCellsNeeded = cellsNeeded;
        int finalCoresNeeded = coresNeeded;
        String finalCurrentForm = currentForm;
        ZygardeUtil.attemptZygardeFormChange(targetPokemon, targetForm, false, success -> {
            if (success.booleanValue()) {
                int cellsActuallyRemoved = ZygardeCubeBundleItem.removeCells(finalZygardeCubeStack, finalCellsNeeded);
                int coresActuallyRemoved = ZygardeCubeBundleItem.removeCores(finalZygardeCubeStack, finalCoresNeeded);
                if (cellsActuallyRemoved != finalCellsNeeded || coresActuallyRemoved != finalCoresNeeded) {
                    MythsAndLegends.getLogger().error("Failed to remove the correct amount of resources from Zygarde cube for player {} after charge {} -> {}! Expected: C={}, Co={}. Got: C={}, Co={}", (Object)player.method_5477().getString(), (Object)finalCurrentForm, (Object)finalTargetForm, (Object)finalCellsNeeded, (Object)finalCoresNeeded, (Object)cellsActuallyRemoved, (Object)coresActuallyRemoved);
                    player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.resource_error"), true);
                } else {
                    MythsAndLegends.getLogger().info("Player {} successfully charged Zygarde from {} to {}. Used: {} Cells, {} Cores.", (Object)player.method_5477().getString(), (Object)finalCurrentForm, (Object)finalTargetForm, (Object)finalCellsNeeded, (Object)finalCoresNeeded);
                    player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.feedback.zygarde.charge_success", (Object[])new Object[]{finalTargetForm}), false);
                    player.method_6104(class_1268.field_5808);
                }
            } else {
                MythsAndLegends.getLogger().warn("Zygarde charge from {} to {} failed for Player {}.", (Object)finalCurrentForm, (Object)finalTargetForm, (Object)player.method_5477().getString());
                player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.feedback.zygarde.charge_failed"), true);
            }
        });
    }

    public static class_1799 findZygardeCube(class_3222 player) {
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_7909() instanceof ZygardeCubeBundleItem) {
            return mainHandStack;
        }
        class_1799 offHandStack = player.method_6079();
        if (offHandStack.method_7909() instanceof ZygardeCubeBundleItem) {
            return offHandStack;
        }
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
            if (!(stack.method_7909() instanceof ZygardeCubeBundleItem)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public static void attemptZygardeFormChange(Pokemon pokemon, String targetFormName, boolean playAnimation, Consumer<Boolean> onCompleteCallback) {
        Species species;
        block13: {
            block12: {
                if (pokemon == null || targetFormName == null || targetFormName.isEmpty()) {
                    MythsAndLegends.getLogger().warn("Zygarde Change: Invalid input pokemon or targetFormName.");
                    onCompleteCallback.accept(false);
                    return;
                }
                species = pokemon.getSpecies();
                if (species == null) break block12;
                if (PokemonSpecies.getByName((String)"zygarde").equals(species)) break block13;
            }
            MythsAndLegends.getLogger().error("Zygarde Change: Pokemon {} is not Zygarde or has null/incorrect species.", (Object)pokemon.getUuid());
            onCompleteCallback.accept(false);
            return;
        }
        FormData targetFormData = species.getForms().stream().filter(form -> targetFormName.equalsIgnoreCase(form.getName())).findFirst().orElse(null);
        if (targetFormData == null && targetFormName.equalsIgnoreCase(species.getStandardForm().getName())) {
            targetFormData = species.getStandardForm();
            MythsAndLegends.getLogger().debug("Zygarde Change: Target form '{}' matches the standard form.", (Object)targetFormName);
        }
        if (targetFormData == null) {
            String availableFormsString = Stream.concat(species.getForms().stream().map(FormData::getName), Stream.of(species.getStandardForm().getName())).distinct().collect(Collectors.joining("', '", "'", "'"));
            MythsAndLegends.getLogger().warn("Zygarde Change: Form '{}' not found for Zygarde. Available forms: [{}]", (Object)targetFormName, (Object)availableFormsString);
            onCompleteCallback.accept(false);
            return;
        }
        PokemonEntity entity = pokemon.getEntity();
        FormData finalTargetFormData = targetFormData;
        String preChangeName = pokemon.getDisplayName(true).getString();
        if (playAnimation && entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = entity;
            if (((Boolean)pokemonEntity.method_5841().method_12789(PokemonEntity.getEVOLUTION_STARTED())).booleanValue()) {
                MythsAndLegends.getLogger().warn("Zygarde Change: {} is already undergoing an evolution/form change animation. Aborting new change.", (Object)preChangeName);
                onCompleteCallback.accept(false);
                return;
            }
            pokemonEntity.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            pokemonEntity.getNavigation().method_6340();
            pokemonEntity.after(1.0f, () -> {
                TransformationHelper.evolutionAnimation((class_1297)pokemonEntity);
                if (pokemonEntity.method_37908() != null) {
                    pokemonEntity.method_37908().method_8396(null, pokemonEntity.method_24515(), CobblemonSounds.EVOLUTION_NOTIFICATION, class_3419.field_15254, 1.0f, 1.0f);
                }
                return Unit.INSTANCE;
            });
            pokemonEntity.after(11.2f, () -> {
                HashSet targetAspects = new HashSet(finalTargetFormData.getAspects());
                pokemon.setForcedAspects(targetAspects);
                pokemon.initialize();
                boolean success = pokemon.getForm().equals((Object)finalTargetFormData);
                if (success) {
                    MythsAndLegends.getLogger().info("Successfully changed Zygarde {} to form '{}'.", (Object)preChangeName, (Object)finalTargetFormData.getName());
                } else {
                    MythsAndLegends.getLogger().warn("Failed to change Zygarde {} to form '{}'. Final form is '{}' (Expected '{}'). Aspects applied: {}", (Object)preChangeName, (Object)finalTargetFormData.getName(), (Object)pokemon.getForm().getName(), (Object)finalTargetFormData.getName(), targetAspects);
                }
                TransformationHelper.cryAnimation((class_1297)pokemonEntity);
                onCompleteCallback.accept(success);
                return Unit.INSTANCE;
            });
            pokemonEntity.after(12.0f, () -> {
                pokemonEntity.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                return Unit.INSTANCE;
            });
        } else {
            HashSet currentAspects = new HashSet(pokemon.getAspects());
            MythsAndLegends.getLogger().debug("Zygarde Change: Current aspects before modification for {}: {}", (Object)preChangeName, currentAspects);
            HashSet targetAspectsFromData = new HashSet(finalTargetFormData.getAspects());
            MythsAndLegends.getLogger().debug("Zygarde Change: Target aspects from FormData for '{}': {}", (Object)finalTargetFormData.getName(), targetAspectsFromData);
            Set<String> percentageAspectsToRemove = Set.of("10-percent", "50-percent");
            HashSet aspectsToForce = new HashSet(currentAspects);
            aspectsToForce.removeAll(percentageAspectsToRemove);
            aspectsToForce.addAll(targetAspectsFromData);
            MythsAndLegends.getLogger().debug("Zygarde Change: Aspects calculated to be forced for {}: {}", (Object)preChangeName, aspectsToForce);
            pokemon.setForcedAspects(aspectsToForce);
            MythsAndLegends.getLogger().debug("Zygarde Change: Aspects on {} immediately after setForcedAspects: {}", (Object)preChangeName, (Object)pokemon.getAspects());
            pokemon.initialize();
            MythsAndLegends.getLogger().debug("Zygarde Change: Aspects on {} immediately after initialize: {}", (Object)preChangeName, (Object)pokemon.getAspects());
            MythsAndLegends.getLogger().debug("Zygarde Change: Form on {} immediately after initialize: {}", (Object)preChangeName, (Object)pokemon.getForm().getName());
            boolean success = pokemon.getForm().equals((Object)finalTargetFormData);
            if (success) {
                MythsAndLegends.getLogger().info("Successfully changed Zygarde {} to form '{}'.", (Object)preChangeName, (Object)finalTargetFormData.getName());
            } else {
                MythsAndLegends.getLogger().warn("Failed to change Zygarde {} to form '{}'. Final form is '{}' (Expected '{}'). Final Aspects: {}. Attempted to force: {}", (Object)preChangeName, (Object)finalTargetFormData.getName(), (Object)pokemon.getForm().getName(), (Object)finalTargetFormData.getName(), (Object)pokemon.getAspects(), aspectsToForce);
            }
            if (playAnimation && entity instanceof PokemonEntity) {
                TransformationHelper.cryAnimation((class_1297)entity);
            }
            onCompleteCallback.accept(success);
        }
    }
}

