/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.custom;

import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.context.FishingSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CustomItemsCondition
implements AppendageCondition {
    List<CustomItemCondition> item_requirement;

    public boolean fits(@NotNull SpawningContext spawningContext) {
        FishingSpawningContext fishingContext;
        SpawnCause fishingContextCause;
        class_1297 causeEntity;
        if (this.item_requirement == null || this.item_requirement.isEmpty()) {
            return true;
        }
        class_3222 targetPlayer = null;
        Spawner spawner = spawningContext.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            targetPlayer = MythsAndLegendsConditions.getPlayerFromUUID(spawningContext.getWorld(), playerSpawner.getUuid());
        } else if (spawningContext instanceof FishingSpawningContext && (causeEntity = (fishingContextCause = (fishingContext = (FishingSpawningContext)spawningContext).getCause()).getEntity()) instanceof class_3222) {
            class_3222 serverPlayerEntity;
            targetPlayer = serverPlayerEntity = (class_3222)causeEntity;
        }
        if (targetPlayer != null) {
            PlayerDataUtils.PlayerData data = PlayerDataUtils.getPlayerData(targetPlayer);
            if (data == null) {
                return false;
            }
            for (CustomItemCondition requirement : this.item_requirement) {
                if (requirement == null || requirement.id == null) continue;
                int requiredCount = requirement.getCount();
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)requirement.id));
                if (item == null || item == class_7923.field_41178.method_10223(class_7923.field_41178.method_10137()) || item == class_1802.field_8162) {
                    MythsAndLegends.getLogger().debug("Custom item requirement " + requirement.id + " not found");
                    return false;
                }
                if (data.getItemCount(item) >= requiredCount) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<CustomItemCondition> getItemConditions() {
        return this.item_requirement;
    }

    public static class CustomItemCondition
    implements Comparable<CustomItemCondition> {
        public String id;
        public Integer count;
        public boolean consume;

        @Override
        public int compareTo(@NotNull CustomItemCondition o) {
            if (this.id.compareTo(o.id) == 0) {
                return o.count - this.count;
            }
            return this.id.compareTo(o.id);
        }

        public String getItemIdString() {
            return this.id;
        }

        public Integer getCount() {
            return this.count;
        }

        public class_2960 getItemId() {
            if (this.id == null) {
                MythsAndLegends.getLogger().debug("CustomItemsCondition: id is null when calling getItemId()");
                return null;
            }
            try {
                return class_2960.method_60654((String)this.id);
            }
            catch (Exception e) {
                MythsAndLegends.getLogger().debug("Failed to parse customitem identifier: " + this.id, (Throwable)e);
                return null;
            }
        }

        public boolean isConsume() {
            return this.consume;
        }
    }
}

