/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.gui;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGui;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ConfigGuiHandler
extends class_1707 {
    private final ConfigVariables config;
    private int currentPage;
    private final int totalPages;
    private final class_1263 inventory;

    public ConfigGuiHandler(int syncId, class_1657 player, class_1263 inventory, ConfigVariables config, int currentPage) {
        super(class_3917.field_17327, syncId, player.method_31548(), inventory, 6);
        this.config = config;
        this.inventory = inventory;
        this.currentPage = currentPage;
        this.totalPages = ConfigGui.getTotalPages();
    }

    public void method_7593(int slotId, int button, class_1713 actionType, class_1657 player) {
        if (!(player instanceof class_3222) || slotId < 0 || slotId >= this.method_7629().method_5439()) {
            if (slotId >= this.method_7629().method_5439()) {
                super.method_7593(slotId, button, actionType, player);
            }
            return;
        }
        class_1799 clickedItem = this.method_7611(slotId).method_7677();
        if (clickedItem.method_7960()) {
            return;
        }
        if (slotId == 46 && clickedItem.method_7909() == class_1802.field_8107) {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.refreshGui(player);
            }
            return;
        }
        if (slotId == 53 && clickedItem.method_7909() == class_1802.field_8107) {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.refreshGui(player);
            }
            return;
        }
        int potentialPaperSlot = slotId - 9;
        ConfigGui.SettingInfo<?> clickedSetting = null;
        int overallSettingIndex = -1;
        if (potentialPaperSlot >= 0 && potentialPaperSlot < this.method_7629().method_5439()) {
            clickedSetting = this.findSettingByPaperSlot(potentialPaperSlot);
        }
        if (clickedSetting != null && actionType == class_1713.field_7790) {
            switch (clickedSetting.type) {
                case TOGGLE: {
                    this.handleToggleSetting(clickedSetting, slotId);
                    break;
                }
                case CYCLE: {
                    this.handleCycleSetting(clickedSetting, slotId);
                }
            }
            MythsAndLegends.getConfigManager().saveConfig();
        }
    }

    private ConfigGui.SettingInfo<?> findSettingByPaperSlot(int paperSlot) {
        int startIndex = this.currentPage * 26;
        int endIndex = Math.min(startIndex + 26, ConfigGui.ALL_SETTINGS.size());
        boolean hasPreviousPage = this.currentPage > 0;
        int currentSettingIndexOnPage = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            int expectedPaperSlot = -1;
            boolean slotFound = false;
            while (!slotFound) {
                int row = currentSettingIndexOnPage / 9;
                int col = currentSettingIndexOnPage % 9;
                int potentialPaperSlot = row * 18 + col;
                if (hasPreviousPage && potentialPaperSlot == 37) {
                    ++currentSettingIndexOnPage;
                    continue;
                }
                expectedPaperSlot = potentialPaperSlot;
                slotFound = true;
            }
            if (expectedPaperSlot == paperSlot) {
                return ConfigGui.ALL_SETTINGS.get(i);
            }
            ++currentSettingIndexOnPage;
        }
        return null;
    }

    private void handleToggleSetting(ConfigGui.SettingInfo<?> setting, int woolSlot) {
        ConfigGui.SettingInfo<?> toggleSetting = setting;
        boolean currentValue = (Boolean)toggleSetting.getter.apply(this.config);
        boolean newValue = !currentValue;
        toggleSetting.setter.accept(this.config, (ConfigVariables)((Object)Boolean.valueOf(newValue)));
        this.updateWoolColor(woolSlot, newValue);
    }

    private void handleCycleSetting(ConfigGui.SettingInfo<?> setting, int woolSlot) {
        ConfigGui.SettingInfo<?> cycleSetting = setting;
        String currentValue = (String)cycleSetting.getter.apply(this.config);
        List<String> options = cycleSetting.cycleOptions;
        if (options == null || options.isEmpty()) {
            return;
        }
        int currentIndex = options.indexOf(currentValue);
        int nextIndex = (currentIndex + 1) % options.size();
        String newValue = options.get(nextIndex);
        cycleSetting.setter.accept(this.config, (ConfigVariables)((Object)newValue));
        this.updateCycleWool(woolSlot, newValue);
    }

    private void updateWoolColor(int slot, boolean enabled) {
        class_1799 wool = new class_1799((class_1935)(enabled ? class_1802.field_19049 : class_1802.field_19058));
        wool.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(enabled ? "Enabled" : "Disabled")).method_27692(enabled ? class_124.field_1060 : class_124.field_1061));
        Optional<class_2561> originalName = Optional.ofNullable((class_2561)this.method_7611(slot - 9).method_7677().method_57824(class_9334.field_49631));
        originalName.ifPresent(name -> wool.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)name.getString()).method_27692(class_124.field_1063)))));
        this.method_7611(slot).method_53512(wool);
    }

    private void updateCycleWool(int slot, String currentValue) {
        class_1799 wool = new class_1799((class_1935)class_1802.field_19054);
        wool.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)currentValue).method_27692(class_124.field_1076));
        Optional<class_2561> originalName = Optional.ofNullable((class_2561)this.method_7611(slot - 9).method_7677().method_57824(class_9334.field_49631));
        originalName.ifPresent(name -> wool.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)name.getString()).method_27692(class_124.field_1063)))));
        this.method_7611(slot).method_53512(wool);
    }

    private void refreshGui(class_1657 player) {
        ConfigGui.populateInventoryForPage((class_1277)this.inventory, this.config, this.currentPage, this.totalPages);
        player.method_7346();
        new ConfigGui().openConfigGui((class_3222)player, this.config, this.currentPage);
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        return class_1799.field_8037;
    }
}

