/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.items;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.utils.ForceSpawningUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public class ZygardeCubeBundleItem
extends class_5537 {
    public static final int MAX_CELLS = 95;
    public static final int MAX_CORES = 5;
    public static final int TOTAL_CAPACITY = 100;
    private static final int ITEM_BAR_COLOR = class_3532.method_15353((float)0.2f, (float)0.9f, (float)0.3f);

    public ZygardeCubeBundleItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_1792 getZygardeCubeItem() {
        return (class_1792)Items.ZYGARDE_CORE.get();
    }

    public static class_1792 getCellItem() {
        return (class_1792)Items.ZYGARDE_CELL.get();
    }

    public static class_1792 getCoreItem() {
        return (class_1792)Items.ZYGARDE_CORE.get();
    }

    private static boolean isZygardeComponent(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 cell = ZygardeCubeBundleItem.getCellItem();
        class_1792 core = ZygardeCubeBundleItem.getCoreItem();
        return cell != null && stack.method_31574(cell) || core != null && stack.method_31574(core);
    }

    public static int countItemsOfType(List<class_1799> stacks, class_1792 itemType) {
        if (stacks == null || itemType == null) {
            return 0;
        }
        int count = 0;
        for (class_1799 stack : stacks) {
            if (stack == null || stack.method_7960() || !stack.method_31574(itemType)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private static int getTotalItemCount(List<class_1799> stacks) {
        if (stacks == null) {
            return 0;
        }
        int cellCount = ZygardeCubeBundleItem.countItemsOfType(stacks, ZygardeCubeBundleItem.getCellItem());
        int coreCount = ZygardeCubeBundleItem.countItemsOfType(stacks, ZygardeCubeBundleItem.getCoreItem());
        return cellCount + coreCount;
    }

    private static int getLimitForItem(class_1792 item) {
        class_1792 cell = ZygardeCubeBundleItem.getCellItem();
        class_1792 core = ZygardeCubeBundleItem.getCoreItem();
        if (cell != null && item == cell) {
            return 95;
        }
        if (core != null && item == core) {
            return 5;
        }
        return 0;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        class_1799 stackToAdd;
        int addedAmount;
        if (clickType != class_5536.field_27014 || stack.method_7947() != 1) {
            return false;
        }
        class_9276 currentContents = (class_9276)stack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289);
        ArrayList<class_1799> currentStacksList = new ArrayList<class_1799>(currentContents.method_57426());
        currentContents.method_59708().forEach(currentStacksList::add);
        boolean changed = false;
        class_1799 slotStack = slot.method_7677();
        if (slotStack.method_7960()) {
            class_1799 removedStack;
            if (!currentStacksList.isEmpty() && (removedStack = (class_1799)currentStacksList.removeFirst()) != null && !removedStack.method_7960()) {
                this.playRemoveOneSound((class_1297)player);
                class_1799 leftover = slot.method_32756(removedStack);
                if (!leftover.method_7960()) {
                    ZygardeCubeBundleItem.addStackToList(currentStacksList, leftover);
                    if (!leftover.method_7960()) {
                        player.method_31548().method_7398(leftover);
                    }
                }
                changed = true;
            }
        } else if (ZygardeCubeBundleItem.isZygardeComponent(slotStack) && slotStack.method_7909().method_31568() && (addedAmount = ZygardeCubeBundleItem.addStackToList(currentStacksList, stackToAdd = slotStack.method_7972())) > 0) {
            slotStack.method_7934(addedAmount);
            this.playInsertSound((class_1297)player);
            changed = true;
        }
        if (changed) {
            stack.method_57379(class_9334.field_49650, (Object)new class_9276(List.copyOf(currentStacksList)));
        }
        return changed;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        int addedAmount;
        if (clickType != class_5536.field_27014 || !slot.method_32754(player) || stack.method_7947() != 1) {
            return false;
        }
        class_9276 currentContents = (class_9276)stack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289);
        ArrayList<class_1799> currentStacksList = new ArrayList<class_1799>(currentContents.method_57426());
        currentContents.method_59708().forEach(currentStacksList::add);
        boolean changed = false;
        if (otherStack.method_7960()) {
            class_1799 removedStack;
            if (!currentStacksList.isEmpty() && (removedStack = (class_1799)currentStacksList.removeFirst()) != null && !removedStack.method_7960()) {
                this.playRemoveOneSound((class_1297)player);
                cursorStackReference.method_32332(removedStack);
                changed = true;
            }
        } else if (ZygardeCubeBundleItem.isZygardeComponent(otherStack) && otherStack.method_7909().method_31568() && (addedAmount = ZygardeCubeBundleItem.addStackToList(currentStacksList, otherStack)) > 0) {
            this.playInsertSound((class_1297)player);
            changed = true;
        }
        if (changed) {
            stack.method_57379(class_9334.field_49650, (Object)new class_9276(List.copyOf(currentStacksList)));
        }
        return changed;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_3222 serverPlayer;
        class_1799 itemstack = player.method_5998(hand);
        class_9276 bundleContents = (class_9276)itemstack.method_57824(class_9334.field_49650);
        if (bundleContents != null && !bundleContents.method_57429() && !world.field_9236 && player instanceof class_3222 && !(serverPlayer = (class_3222)player).method_5715()) {
            class_1269 result = ForceSpawningUtils.forceSpawnFromItemUse(world, player, hand, "zygarde_cube");
            if (result.method_23665()) {
                return class_1271.method_29237((Object)itemstack, (boolean)world.method_8608());
            }
            if (world.field_9236) {
                // empty if block
            }
        }
        return class_1271.method_22431((Object)itemstack);
    }

    public void method_33261(class_1542 entity) {
        class_9276 bundleContentsComponent = (class_9276)entity.method_6983().method_57824(class_9334.field_49650);
        if (bundleContentsComponent != null) {
            entity.method_6983().method_57379(class_9334.field_49650, (Object)class_9276.field_49289);
            class_5328.method_33263((class_1542)entity, (Iterable)bundleContentsComponent.method_59708());
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.ofNullable((class_9276)stack.method_57824(class_9334.field_49650)).filter(contents -> !contents.method_57429()).map(class_5631::new);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        List<class_1799> currentStacks;
        class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
        List<Object> list = currentStacks = contents != null ? contents.method_59707().toList() : List.of();
        if (currentStacks.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.mythsandlegends.zygarde_cube.tooltip.empty").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.mythsandlegends.zygarde_cube.tooltip.max_capacity", (Object[])new Object[]{95, 5}).method_27692(class_124.field_1063));
            return;
        }
        int cellCount = ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCellItem());
        int coreCount = ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCoreItem());
        int totalItems = cellCount + coreCount;
        tooltip.add((class_2561)class_2561.method_43469((String)"item.mythsandlegends.zygarde_cube.tooltip.cells", (Object[])new Object[]{cellCount, 95}).method_27692(class_124.field_1060));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.mythsandlegends.zygarde_cube.tooltip.cores", (Object[])new Object[]{coreCount, 5}).method_27692(class_124.field_1075));
        float fullnessRatio = (float)totalItems / 100.0f;
        tooltip.add((class_2561)class_2561.method_43469((String)"item.mythsandlegends.zygarde_cube.tooltip.fullness", (Object[])new Object[]{totalItems, 100}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.mythsandlegends.zygarde_cube.tooltip.max_capacity", (Object[])new Object[]{95, 5}).method_27692(class_124.field_1063));
        if (type.method_8035() && MythsAndLegends.getConfigManager().getConfig().debug_mode) {
            Fraction vanillaOccupancy = contents.method_57428();
            tooltip.add((class_2561)class_2561.method_43470((String)("Vanilla Occupancy: " + class_3532.method_59515((Fraction)vanillaOccupancy, (int)64) + "/64")).method_27692(class_124.field_1063));
        }
    }

    public boolean method_31567(class_1799 stack) {
        class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
        return contents != null && !contents.method_57429();
    }

    public int method_31569(class_1799 stack) {
        class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (contents == null || contents.method_57429()) {
            return 0;
        }
        int totalItems = ZygardeCubeBundleItem.getTotalItemCount(contents.method_59707().toList());
        float fullnessRatio = (float)totalItems / 100.0f;
        return Math.min(1 + (int)(fullnessRatio * 12.0f), 13);
    }

    public int method_31571(class_1799 stack) {
        return ITEM_BAR_COLOR;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private static int addStackToList(List<class_1799> currentStacks, class_1799 stackToAdd) {
        int currentCount;
        if (stackToAdd.method_7960() || !ZygardeCubeBundleItem.isZygardeComponent(stackToAdd)) {
            return 0;
        }
        class_1792 itemType = stackToAdd.method_7909();
        int limit = ZygardeCubeBundleItem.getLimitForItem(itemType);
        int spaceAvailable = limit - (currentCount = ZygardeCubeBundleItem.countItemsOfType(currentStacks, itemType));
        if (spaceAvailable <= 0) {
            return 0;
        }
        int amountToAdd = Math.min(stackToAdd.method_7947(), spaceAvailable);
        if (amountToAdd <= 0) {
            return 0;
        }
        class_1799 existingStack = null;
        for (class_1799 internalStack : currentStacks) {
            if (!class_1799.method_31577((class_1799)internalStack, (class_1799)stackToAdd)) continue;
            existingStack = internalStack;
            break;
        }
        if (existingStack != null) {
            existingStack.method_7933(amountToAdd);
            stackToAdd.method_7934(amountToAdd);
            currentStacks.remove(existingStack);
            currentStacks.add(existingStack);
        } else {
            currentStacks.add(stackToAdd.method_7971(amountToAdd));
        }
        return amountToAdd;
    }

    public static int getCellCount(class_1799 stack) {
        class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (contents == null || contents.method_57429()) {
            return 0;
        }
        List<class_1799> currentStacks = contents.method_59707().toList();
        return ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCellItem());
    }

    public static int getCoreCount(class_1799 stack) {
        class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (contents == null || contents.method_57429()) {
            return 0;
        }
        List<class_1799> currentStacks = contents.method_59707().toList();
        return ZygardeCubeBundleItem.countItemsOfType(currentStacks, ZygardeCubeBundleItem.getCoreItem());
    }

    public static int getRemainingSpace(class_1799 stack) {
        int currentCells = ZygardeCubeBundleItem.getCellCount(stack);
        int currentCores = ZygardeCubeBundleItem.getCoreCount(stack);
        return 100 - (currentCells + currentCores);
    }

    public static int addCells(class_1799 stack, int amount) {
        if (amount <= 0 || ZygardeCubeBundleItem.getCellItem() == null) {
            return 0;
        }
        class_9276 currentContents = (class_9276)stack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289);
        ArrayList<class_1799> currentStacksList = new ArrayList<class_1799>(currentContents.method_57426());
        currentContents.method_59708().forEach(currentStacksList::add);
        int currentCellCount = ZygardeCubeBundleItem.countItemsOfType(currentStacksList, ZygardeCubeBundleItem.getCellItem());
        int spaceAvailable = 95 - currentCellCount;
        int amountToAdd = Math.min(amount, spaceAvailable);
        if (amountToAdd <= 0) {
            return 0;
        }
        class_1799 cellsToAddStack = new class_1799((class_1935)ZygardeCubeBundleItem.getCellItem(), amountToAdd);
        int actuallyAdded = ZygardeCubeBundleItem.addStackToList(currentStacksList, cellsToAddStack);
        if (actuallyAdded > 0) {
            stack.method_57379(class_9334.field_49650, (Object)new class_9276(List.copyOf(currentStacksList)));
        }
        return actuallyAdded;
    }

    public static int addCores(class_1799 stack, int amount) {
        if (amount <= 0 || ZygardeCubeBundleItem.getCoreItem() == null) {
            return 0;
        }
        class_9276 currentContents = (class_9276)stack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289);
        ArrayList<class_1799> currentStacksList = new ArrayList<class_1799>(currentContents.method_57426());
        currentContents.method_59708().forEach(currentStacksList::add);
        int currentCoreCount = ZygardeCubeBundleItem.countItemsOfType(currentStacksList, ZygardeCubeBundleItem.getCoreItem());
        int spaceAvailable = 5 - currentCoreCount;
        int amountToAdd = Math.min(amount, spaceAvailable);
        if (amountToAdd <= 0) {
            return 0;
        }
        class_1799 coresToAddStack = new class_1799((class_1935)ZygardeCubeBundleItem.getCoreItem(), amountToAdd);
        int actuallyAdded = ZygardeCubeBundleItem.addStackToList(currentStacksList, coresToAddStack);
        if (actuallyAdded > 0) {
            stack.method_57379(class_9334.field_49650, (Object)new class_9276(List.copyOf(currentStacksList)));
        }
        return actuallyAdded;
    }

    public static int removeCells(class_1799 stack, int amount) {
        return ZygardeCubeBundleItem.removeItemsOfType(stack, ZygardeCubeBundleItem.getCellItem(), amount);
    }

    public static int removeCores(class_1799 stack, int amount) {
        return ZygardeCubeBundleItem.removeItemsOfType(stack, ZygardeCubeBundleItem.getCoreItem(), amount);
    }

    private static int removeItemsOfType(class_1799 stack, class_1792 itemType, int amount) {
        if (amount <= 0 || itemType == null) {
            return 0;
        }
        class_9276 currentContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (currentContents == null || currentContents.method_57429()) {
            return 0;
        }
        ArrayList currentStacksList = new ArrayList(currentContents.method_57426());
        currentContents.method_59708().forEach(currentStacksList::add);
        int totalRemoved = 0;
        int remainingToRemove = amount;
        for (int i = currentStacksList.size() - 1; i >= 0 && remainingToRemove > 0; --i) {
            class_1799 internalStack = (class_1799)currentStacksList.get(i);
            if (internalStack == null || internalStack.method_7960() || !internalStack.method_31574(itemType)) continue;
            int amountFromThisStack = Math.min(internalStack.method_7947(), remainingToRemove);
            internalStack.method_7934(amountFromThisStack);
            totalRemoved += amountFromThisStack;
            remainingToRemove -= amountFromThisStack;
            if (!internalStack.method_7960()) continue;
            currentStacksList.remove(i);
        }
        if (totalRemoved > 0) {
            stack.method_57379(class_9334.field_49650, (Object)new class_9276(List.copyOf(currentStacksList)));
        }
        return totalRemoved;
    }
}

