/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.animation.PlayPosableAnimationPacket;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.FormChangeConfig;
import com.github.d0ctorleon.mythsandlegends.utils.FusionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.HeldItemTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.InteractionTransformation;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public class TransformationHelper {
    private static final String NBT_KEY_STORED_POKEMON = "MythsStoredFusionPokemon";
    private static final String NBT_KEY_IS_FUSED = "MythsIsFused";
    private static final String NBT_KEY_FUSION_PARTNER_SPECIES = "MythsFusionPartnerSpecies";
    private static final String NBT_KEY_FUSION_RULE_FORM = "MythsFusionRuleForm";
    private static final String NBT_KEY_IS_TRADABLE = "MythsIsTradable";

    public static boolean tryApplyHeldItemChange(Pokemon pokemon, class_1799 newStack, HeldItemTransformation rule) {
        if (rule.item == null) {
            MythsAndLegends.getLogger().warn("Invalid item ID in heldItemChanges rule for {}: {}", (Object)rule.pokemon, (Object)rule.item);
            return false;
        }
        class_1792 requiredItem = (class_1792)class_7923.field_41178.method_10223(rule.item);
        if (newStack.method_31574(requiredItem)) {
            TransformationHelper.applyFormChange(pokemon, rule.targetForm, rule.playAnimation, rule.isTradable, success -> {});
            return true;
        }
        return false;
    }

    public static boolean tryRevertHeldItemChange(Pokemon pokemon, class_1799 oldStack, HeldItemTransformation rule) {
        if (rule.item == null) {
            return false;
        }
        class_1792 requiredItem = (class_1792)class_7923.field_41178.method_10223(rule.item);
        Species species = pokemon.getSpecies();
        if (species != null && oldStack.method_31574(requiredItem) && pokemon.getForm().getName().equalsIgnoreCase(rule.targetForm)) {
            TransformationHelper.applyFormChange(pokemon, species.getStandardForm().getName(), rule.playAnimation, true, success -> {});
            return true;
        }
        return false;
    }

    public static boolean tryApplyInteractionChange(class_3222 player, Pokemon pokemon, class_1799 heldStack, InteractionTransformation rule) {
        if (rule.item == null) {
            MythsAndLegends.getLogger().warn("Invalid item ID in interactionChanges rule for {}: {}", (Object)rule.pokemon, (Object)rule.item);
            return false;
        }
        class_1792 requiredItem = (class_1792)class_7923.field_41178.method_10223(rule.item);
        Species species = pokemon.getSpecies();
        if (species != null && heldStack.method_31574(requiredItem)) {
            if (pokemon.getForm().getName().equalsIgnoreCase(rule.targetForm)) {
                TransformationHelper.applyFormChange(pokemon, species.getStandardForm().getName(), rule.playAnimation, true, success -> {});
            } else {
                TransformationHelper.applyFormChange(pokemon, rule.targetForm, rule.playAnimation, rule.isTradable, success -> {});
            }
            return true;
        }
        return false;
    }

    public static boolean tryApplyFusionOrUnfusion(class_3222 player, Pokemon targetPokemon, class_1799 heldStack, FusionTransformation rule, class_1268 hand) {
        if (rule.item == null) {
            MythsAndLegends.getLogger().warn("Invalid item ID in fusions rule for {}: {}", (Object)rule.basePokemon, (Object)rule.item);
            return false;
        }
        class_1792 requiredItem = (class_1792)class_7923.field_41178.method_10223(rule.item);
        if (!heldStack.method_31574(requiredItem)) {
            return false;
        }
        class_2487 persistentData = targetPokemon.getPersistentData();
        boolean isCurrentlyFused = persistentData.method_10577(NBT_KEY_IS_FUSED);
        String storedPartnerSpecies = persistentData.method_10558(NBT_KEY_FUSION_PARTNER_SPECIES);
        String storedFusionForm = persistentData.method_10558(NBT_KEY_FUSION_RULE_FORM);
        if (isCurrentlyFused) {
            if (storedPartnerSpecies.equalsIgnoreCase(rule.partnerPokemon) && storedFusionForm.equalsIgnoreCase(rule.resultingForm)) {
                MythsAndLegends.getLogger().debug("Attempting unfusion for {} based on rule for partner {}", (Object)targetPokemon.getSpecies().getName(), (Object)rule.partnerPokemon);
                return TransformationHelper.unfusePokemon(player, targetPokemon, rule);
            }
            MythsAndLegends.getLogger().debug("Unfusion item used, but current fusion state (Partner: {}, Form: {}) doesn't match this rule (Partner: {}, Form: {}).", (Object)storedPartnerSpecies, (Object)storedFusionForm, (Object)rule.partnerPokemon, (Object)rule.resultingForm);
            return false;
        }
        targetPokemon.getSpecies().getForms().stream().filter(form -> form.getName().equalsIgnoreCase("mega")).findFirst().orElse(null);
        if (!targetPokemon.getForm().equals((Object)targetPokemon.getSpecies().getStandardForm())) {
            MythsAndLegends.getLogger().debug("Cannot fuse: {} is not in its standard form.", (Object)targetPokemon.getDisplayName().getString());
            player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.fusion.must_be_standard_form", (Object[])new Object[]{targetPokemon.getDisplayName()}), false);
            return false;
        }
        MythsAndLegends.getLogger().debug("Attempting fusion for {} with partner {}", (Object)targetPokemon.getSpecies().getName(), (Object)rule.partnerPokemon);
        return TransformationHelper.fusePokemon(player, targetPokemon, rule);
    }

    private static boolean fusePokemon(class_3222 player, Pokemon basePokemon, FusionTransformation rule) {
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        Pokemon partnerPokemon = null;
        for (Pokemon partyPokemon : playerPartyStore) {
            if (!partyPokemon.getSpecies().getName().equalsIgnoreCase(rule.partnerPokemon) || !partyPokemon.getForm().equals((Object)partyPokemon.getSpecies().getStandardForm())) continue;
            partnerPokemon = partyPokemon;
            break;
        }
        if (partnerPokemon == null) {
            MythsAndLegends.getLogger().debug("Fusion partner {} (in standard form) not found in party.", (Object)rule.partnerPokemon);
            player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.fusion.partner_missing", (Object[])new Object[]{rule.partnerPokemon}), false);
            return false;
        }
        class_5455 registryAccess = player.method_51469().method_30349();
        class_2487 partnerNbt = partnerPokemon.saveToNBT(registryAccess, new class_2487());
        class_2487 persistentData = basePokemon.getPersistentData();
        persistentData.method_10566(NBT_KEY_STORED_POKEMON, (class_2520)partnerNbt);
        persistentData.method_10556(NBT_KEY_IS_FUSED, true);
        persistentData.method_10582(NBT_KEY_FUSION_PARTNER_SPECIES, rule.partnerPokemon);
        persistentData.method_10582(NBT_KEY_FUSION_RULE_FORM, rule.resultingForm);
        boolean removed = playerPartyStore.remove(partnerPokemon);
        if (!removed) {
            MythsAndLegends.getLogger().error("Critical error: Failed to remove fusion partner {} from party after NBT was stored!", (Object)rule.partnerPokemon);
            persistentData.method_10551(NBT_KEY_STORED_POKEMON);
            persistentData.method_10551(NBT_KEY_IS_FUSED);
            persistentData.method_10551(NBT_KEY_FUSION_PARTNER_SPECIES);
            persistentData.method_10551(NBT_KEY_FUSION_RULE_FORM);
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.fusion.error.remove_failed"), true);
            return false;
        }
        MythsAndLegends.getLogger().info("Stored {} NBT and removed from party. Applying fusion form {} to {}.", (Object)rule.partnerPokemon, (Object)rule.resultingForm, (Object)basePokemon.getSpecies().getName());
        Pokemon finalPartnerPokemon = partnerPokemon;
        TransformationHelper.applyFormChange(basePokemon, rule.resultingForm, rule.playAnimation, rule.isTradable, success -> {
            if (success.booleanValue()) {
                MythsAndLegends.getLogger().info("Fusion form change successful for {}.", (Object)basePokemon.getSpecies().getName());
                player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.fusion.success", (Object[])new Object[]{basePokemon.getDisplayName(), finalPartnerPokemon.getDisplayName()}), false);
            } else {
                MythsAndLegends.getLogger().error("Fusion form change failed for {} to {}! Attempting to revert state.", (Object)basePokemon.getSpecies().getName(), (Object)rule.resultingForm);
                boolean addedBack = playerPartyStore.add(finalPartnerPokemon);
                if (!addedBack) {
                    MythsAndLegends.getLogger().error("Rollback failed: Could not add partner {} back to party!", (Object)finalPartnerPokemon.getSpecies().getName());
                }
                persistentData.method_10551(NBT_KEY_STORED_POKEMON);
                persistentData.method_10551(NBT_KEY_IS_FUSED);
                persistentData.method_10551(NBT_KEY_FUSION_PARTNER_SPECIES);
                persistentData.method_10551(NBT_KEY_FUSION_RULE_FORM);
                TransformationHelper.clearTradableNBT(basePokemon);
                TransformationHelper.applyFormChange(basePokemon, basePokemon.getSpecies().getStandardForm().getName(), false, true, revertSuccess -> {
                    if (!revertSuccess.booleanValue()) {
                        MythsAndLegends.getLogger().error("Rollback failed: Could not revert base Pokemon {} to standard form!", (Object)basePokemon.getSpecies().getName());
                    }
                });
                player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.fusion.error.form_change_failed"), true);
            }
        });
        return true;
    }

    private static boolean unfusePokemon(class_3222 player, Pokemon basePokemon, FusionTransformation rule) {
        class_2487 partnerNbt;
        class_2487 persistentData = basePokemon.getPersistentData();
        if (!persistentData.method_10545(NBT_KEY_STORED_POKEMON)) {
            MythsAndLegends.getLogger().warn("Attempted to unfuse {}, but no stored Pokemon NBT found. Clearing fusion tags.", (Object)basePokemon.getSpecies().getName());
            TransformationHelper.clearFusionTagsAndRevert(basePokemon, rule.playAnimation);
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.unfusion.error.no_data"), true);
            return false;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (playerPartyStore.occupied() >= 6) {
            MythsAndLegends.getLogger().debug("Cannot unfuse, party is full ({} / 6).", (Object)playerPartyStore.size());
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.unfusion.party_full"), true);
            MythsAndLegends.getLogger().debug("Sent player message key: mythsandlegends.unfusion.party_full");
            return false;
        }
        class_5455 registryAccess = player.method_51469().method_30349();
        Pokemon partnerPokemon = Pokemon.Companion.loadFromNBT(registryAccess, partnerNbt = persistentData.method_10562(NBT_KEY_STORED_POKEMON));
        if (partnerPokemon == null) {
            MythsAndLegends.getLogger().error("Failed to load stored partner Pokemon from NBT during unfusion! Clearing fusion tags.");
            TransformationHelper.clearFusionTagsAndRevert(basePokemon, rule.playAnimation);
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.unfusion.error.load_failed"), true);
            return false;
        }
        boolean added = playerPartyStore.add(partnerPokemon);
        if (!added) {
            MythsAndLegends.getLogger().error("Failed to add unfused partner {} back to party! Party size might have changed unexpectedly. Unfusion cannot complete.", (Object)partnerPokemon.getSpecies().getName());
            player.method_7353((class_2561)class_2561.method_43471((String)"mythsandlegends.unfusion.error.add_failed"), true);
            return false;
        }
        MythsAndLegends.getLogger().info("Unfusing {}. Partner {} returned to party.", (Object)basePokemon.getSpecies().getName(), (Object)partnerPokemon.getSpecies().getName());
        persistentData.method_10551(NBT_KEY_STORED_POKEMON);
        persistentData.method_10551(NBT_KEY_IS_FUSED);
        persistentData.method_10551(NBT_KEY_FUSION_PARTNER_SPECIES);
        persistentData.method_10551(NBT_KEY_FUSION_RULE_FORM);
        TransformationHelper.clearTradableNBT(basePokemon);
        String standardFormName = basePokemon.getSpecies().getStandardForm().getName();
        TransformationHelper.applyFormChange(basePokemon, standardFormName, rule.playAnimation, true, success -> {
            if (!success.booleanValue()) {
                MythsAndLegends.getLogger().warn("Post-unfusion revert failed for {}. Final form is '{}'.", (Object)basePokemon.getSpecies().getName(), (Object)basePokemon.getForm().getName());
            }
        });
        player.method_7353((class_2561)class_2561.method_43469((String)"mythsandlegends.unfusion.success", (Object[])new Object[]{basePokemon.getDisplayName(), partnerPokemon.getDisplayName()}), false);
        return true;
    }

    public static void applyFormChange(Pokemon pokemon, String targetFormName, boolean playAnimation, boolean isTradable, Consumer<Boolean> onCompleteCallback) {
        if (pokemon == null || targetFormName == null || targetFormName.isEmpty()) {
            MythsAndLegends.getLogger().warn("Cannot change form: Invalid input pokemon or targetFormName.");
            onCompleteCallback.accept(false);
            return;
        }
        Species species = pokemon.getSpecies();
        if (species == null) {
            MythsAndLegends.getLogger().error("Cannot change form: Pokemon {} has no species data.", (Object)pokemon.getUuid());
            onCompleteCallback.accept(false);
            return;
        }
        FormData targetFormData = species.getForms().stream().filter(form -> targetFormName.equalsIgnoreCase(form.getName())).findFirst().orElse(null);
        if (targetFormData == null && targetFormName.equalsIgnoreCase(species.getStandardForm().getName())) {
            targetFormData = species.getStandardForm();
        }
        if (targetFormData == null) {
            String availableForms = species.getForms().stream().map(FormData::getName).collect(Collectors.joining(", "));
            MythsAndLegends.getLogger().warn("Cannot change form: Form '{}' not found for species '{}'. Available forms: [{}]", (Object)targetFormName, (Object)species.getName(), availableForms.isEmpty() ? species.getStandardForm().getName() : availableForms + ", " + species.getStandardForm().getName());
            TransformationHelper.setTradableNBT(pokemon, true);
            pokemon.setTradeable(true);
            onCompleteCallback.accept(false);
            return;
        }
        PokemonEntity entity = pokemon.getEntity();
        FormData finalTargetFormData = targetFormData;
        String preChangeName = pokemon.getDisplayName().getString();
        if (playAnimation && entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = entity;
            pokemonEntity.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            pokemonEntity.getNavigation().method_6340();
            pokemonEntity.after(1.0f, () -> {
                TransformationHelper.evolutionAnimation((class_1297)pokemonEntity);
                pokemonEntity.method_37908().method_8396(null, pokemonEntity.method_24515(), CobblemonSounds.EVOLUTION_NOTIFICATION, class_3419.field_15254, 1.0f, 1.0f);
                return Unit.INSTANCE;
            });
            pokemonEntity.after(11.2f, () -> {
                HashSet targetAspects = new HashSet(finalTargetFormData.getAspects());
                pokemon.setForcedAspects(targetAspects);
                pokemon.initialize();
                boolean success = pokemon.getForm().equals((Object)finalTargetFormData);
                if (success) {
                    MythsAndLegends.getLogger().info("Successfully changed {} to form '{}'.", (Object)preChangeName, (Object)finalTargetFormData.getName());
                    TransformationHelper.setTradableNBT(pokemon, isTradable);
                    pokemon.setTradeable(isTradable);
                } else {
                    MythsAndLegends.getLogger().warn("Failed to change {} to form '{}'. Final form is '{}' (Expected '{}').", (Object)preChangeName, (Object)finalTargetFormData.getName(), (Object)pokemon.getForm().getName(), (Object)finalTargetFormData.getName());
                    TransformationHelper.setTradableNBT(pokemon, true);
                    pokemon.setTradeable(true);
                }
                TransformationHelper.cryAnimation((class_1297)pokemonEntity);
                onCompleteCallback.accept(success);
                return Unit.INSTANCE;
            });
            pokemonEntity.after(12.0f, () -> {
                pokemonEntity.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                return Unit.INSTANCE;
            });
        } else {
            HashSet targetAspects = new HashSet(finalTargetFormData.getAspects());
            pokemon.setForcedAspects(targetAspects);
            pokemon.initialize();
            boolean success = pokemon.getForm().equals((Object)finalTargetFormData);
            if (success) {
                MythsAndLegends.getLogger().info("Successfully changed {} to form '{}'.", (Object)preChangeName, (Object)finalTargetFormData.getName());
                TransformationHelper.setTradableNBT(pokemon, isTradable);
                pokemon.setTradeable(isTradable);
            } else {
                MythsAndLegends.getLogger().warn("Failed to change {} to form '{}'. Final form is '{}' (Expected '{}').", (Object)preChangeName, (Object)finalTargetFormData.getName(), (Object)pokemon.getForm().getName(), (Object)finalTargetFormData.getName());
                TransformationHelper.setTradableNBT(pokemon, true);
                pokemon.setTradeable(true);
            }
            onCompleteCallback.accept(success);
        }
    }

    public static void checkAndApplyPersistentForm(Pokemon pokemon) {
        class_2487 persistentData = pokemon.getPersistentData();
        if (persistentData.method_10577(NBT_KEY_IS_FUSED) && persistentData.method_10545(NBT_KEY_FUSION_RULE_FORM)) {
            String targetFormName = persistentData.method_10558(NBT_KEY_FUSION_RULE_FORM);
            String partnerSpecies = persistentData.method_10558(NBT_KEY_FUSION_PARTNER_SPECIES);
            MythsAndLegends.getLogger().debug("Loading persistent fusion state for {}: Form {}, Partner {}", (Object)pokemon.getSpecies().getName(), (Object)targetFormName, (Object)partnerSpecies);
            Optional<FusionTransformation> ruleOpt = FormChangeConfig.getConfig().fusions.stream().filter(rule -> rule.basePokemon.equalsIgnoreCase(pokemon.getSpecies().getName()) && rule.partnerPokemon.equalsIgnoreCase(partnerSpecies) && rule.resultingForm.equalsIgnoreCase(targetFormName)).findFirst();
            if (ruleOpt.isPresent()) {
                FusionTransformation rule2 = ruleOpt.get();
                boolean isTradable = persistentData.method_10545(NBT_KEY_IS_TRADABLE) ? persistentData.method_10577(NBT_KEY_IS_TRADABLE) : rule2.isTradable;
                TransformationHelper.applyFormChange(pokemon, targetFormName, false, isTradable, success -> {
                    if (!success.booleanValue()) {
                        MythsAndLegends.getLogger().warn("Persistent fusion form '{}' failed to apply correctly on load for {}. Final form is '{}'. Clearing fusion tags.", (Object)targetFormName, (Object)pokemon.getSpecies().getName(), (Object)pokemon.getForm().getName());
                        TransformationHelper.clearFusionTagsAndRevert(pokemon, false);
                    } else {
                        MythsAndLegends.getLogger().debug("Successfully applied persistent fusion form '{}' to {}.", (Object)targetFormName, (Object)pokemon.getSpecies().getName());
                    }
                });
                if (!pokemon.getForm().getName().equalsIgnoreCase(targetFormName)) {
                    MythsAndLegends.getLogger().warn("Persistent fusion form '{}' failed to apply correctly on load for {}. Final form is '{}'. Clearing fusion tags.", (Object)targetFormName, (Object)pokemon.getSpecies().getName(), (Object)pokemon.getForm().getName());
                    TransformationHelper.clearFusionTagsAndRevert(pokemon, false);
                } else {
                    MythsAndLegends.getLogger().debug("Successfully applied persistent fusion form '{}' to {}.", (Object)targetFormName, (Object)pokemon.getSpecies().getName());
                }
            } else {
                MythsAndLegends.getLogger().warn("Could not find matching fusion rule to validate persistent state for {}. Clearing fusion tags.", (Object)pokemon.getSpecies().getName());
                TransformationHelper.clearFusionTagsAndRevert(pokemon, false);
            }
        }
    }

    private static void clearFusionTagsAndRevert(Pokemon pokemon, boolean playAnimation) {
        class_2487 persistentData = pokemon.getPersistentData();
        persistentData.method_10551(NBT_KEY_STORED_POKEMON);
        persistentData.method_10551(NBT_KEY_IS_FUSED);
        persistentData.method_10551(NBT_KEY_FUSION_PARTNER_SPECIES);
        persistentData.method_10551(NBT_KEY_FUSION_RULE_FORM);
        TransformationHelper.clearTradableNBT(pokemon);
        if (pokemon.getSpecies() != null) {
            TransformationHelper.applyFormChange(pokemon, pokemon.getSpecies().getStandardForm().getName(), playAnimation, true, success -> {});
        }
    }

    private static void setTradableNBT(Pokemon pokemon, boolean isTradable) {
        pokemon.getPersistentData().method_10556(NBT_KEY_IS_TRADABLE, isTradable);
        pokemon.setTradeable(isTradable);
        MythsAndLegends.getLogger().debug("Set tradable status for {} to: {}", (Object)pokemon.getDisplayName().getString(), (Object)isTradable);
    }

    private static void clearTradableNBT(Pokemon pokemon) {
        pokemon.getPersistentData().method_10551(NBT_KEY_IS_TRADABLE);
        pokemon.setTradeable(true);
        MythsAndLegends.getLogger().debug("Cleared custom tradable status for {}, defaulting to true.", (Object)pokemon.getDisplayName().getString());
    }

    public static boolean isPokemonTradable(Pokemon pokemon) {
        class_2487 persistentData = pokemon.getPersistentData();
        return persistentData.method_10545(NBT_KEY_IS_TRADABLE) ? persistentData.method_10577(NBT_KEY_IS_TRADABLE) : true;
    }

    public static void evolutionAnimation(class_1297 pokemonEntity) {
        class_1937 world = pokemonEntity.method_37908();
        if (world == null) {
            return;
        }
        PlayPosableAnimationPacket playPoseableAnimationPacket = new PlayPosableAnimationPacket(pokemonEntity.method_5628(), Set.of("q.bedrock_stateful('evolution', 'evolution', 'endures_primary_animations');"), List.of());
        playPoseableAnimationPacket.sendToPlayersAround(pokemonEntity.method_23317(), pokemonEntity.method_23318(), pokemonEntity.method_23321(), 128.0, world.method_27983(), player -> false);
    }

    public static void cryAnimation(class_1297 pokemonEntity) {
        class_1937 world = pokemonEntity.method_37908();
        if (world == null) {
            return;
        }
        PlayPosableAnimationPacket playPoseableAnimationPacket = new PlayPosableAnimationPacket(pokemonEntity.method_5628(), Set.of("cry"), List.of());
        playPoseableAnimationPacket.sendToPlayersAround(pokemonEntity.method_23317(), pokemonEntity.method_23318(), pokemonEntity.method_23321(), 128.0, world.method_27983(), player -> false);
    }
}

