/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.jjelytraswap;

import io.github.jumperonjava.jjelytraswap.ModPlatform;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.lunaluna.fabric.elytrarecast.config.ElytraRecastConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.equipment.Equippable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JJElytraSwapInit {
    public static final String MODID = "jjelytraswap";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"JJElytraSwap");
    public static ModPlatform PLATFORM = null;
    public static boolean enabled = true;
    public static boolean shouldWearChestplatePrevTick = true;

    public static void entrypoint(ModPlatform platform) {
        PLATFORM = platform;
        JJElytraSwapInit.onInitializeClient();
    }

    public static boolean stackHasComponent(ItemStack stack, DataComponentType<?> type) {
        return stack.has(type);
    }

    public static void tryWearChestplate(Minecraft client) {
        if (client.level == null || client.player == null) {
            return;
        }
        if (client.player.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            return;
        }
        List chestplateSlots = JJElytraSwapInit.getChestplateSlots();
        chestplateSlots = chestplateSlots.stream().filter(slot -> (float)JJElytraSwapInit.getChestplateStat(client.player.getInventory().getItem(slot.intValue())) > 0.0f).sorted(Comparator.comparingInt(slot -> JJElytraSwapInit.getChestplateStat(client.player.getInventory().getItem(slot.intValue())))).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(chestplateSlots);
        if (!chestplateSlots.isEmpty()) {
            int bestSlot = (Integer)chestplateSlots.get(0);
            JJElytraSwapInit.swap(bestSlot, client);
        }
    }

    private static boolean elytraRecastEnabled() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        return ElytraRecastConfig.enabled && ElytraRecastConfig.jumpEnabled;
    }

    public static void tryWearElytra() {
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return;
        }
        if (JJElytraSwapInit.stackHasComponent(Minecraft.getInstance().player.getInventory().getItem(38), DataComponents.GLIDER)) {
            return;
        }
        List<Integer> elytraSlots = JJElytraSwapInit.getElytraSlots();
        elytraSlots.sort(Comparator.comparingInt(slot -> JJElytraSwapInit.getElytraStat(Minecraft.getInstance().player.getInventory().getItem(slot.intValue()))));
        if (!elytraSlots.isEmpty()) {
            int bestSlot = elytraSlots.get(elytraSlots.size() - 1);
            JJElytraSwapInit.wearElytra(bestSlot);
        }
    }

    public static List<Integer> getElytraSlots() {
        ArrayList<Integer> elytraSlots = new ArrayList<Integer>();
        for (int slot : JJElytraSwapInit.slotArray()) {
            if (!JJElytraSwapInit.stackHasComponent(Minecraft.getInstance().player.getInventory().getItem(slot), DataComponents.GLIDER)) continue;
            elytraSlots.add(slot);
        }
        return elytraSlots;
    }

    public static List<Integer> getChestplateSlots() {
        ArrayList<Integer> chestplateSlots = new ArrayList<Integer>();
        Minecraft client = Minecraft.getInstance();
        for (int slot : JJElytraSwapInit.slotArray()) {
            if (!JJElytraSwapInit.isSlotChestplate(slot)) continue;
            chestplateSlots.add(slot);
        }
        return chestplateSlots;
    }

    private static Registry<Enchantment> getEnchantmentRegistry() {
        return Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
    }

    private static int getLevel(ResourceKey<Enchantment> key, ItemStack stack) {
        Enchantment enchant = (Enchantment)JJElytraSwapInit.getEnchantmentRegistry().getValue(key);
        Holder enchantEntry = JJElytraSwapInit.getEnchantmentRegistry().wrapAsHolder((Object)enchant);
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantEntry, (ItemStack)stack);
    }

    private static int getElytraStat(ItemStack elytraItem) {
        int stat = JJElytraSwapInit.getLevel((ResourceKey<Enchantment>)Enchantments.MENDING, elytraItem) * 3 + 1 + JJElytraSwapInit.getLevel((ResourceKey<Enchantment>)Enchantments.UNBREAKING, elytraItem);
        return stat;
    }

    private static int getChestplateStat(ItemStack chestplateItem) {
        float score = 1.0f;
        ItemStack holder = chestplateItem;
        if (JJElytraSwapInit.stackHasComponent(chestplateItem, DataComponents.EQUIPPABLE) && ((Equippable)chestplateItem.get(DataComponents.EQUIPPABLE)).slot() == EquipmentSlot.CHEST) {
            ItemAttributeModifiers component = (ItemAttributeModifiers)chestplateItem.get(DataComponents.ATTRIBUTE_MODIFIERS);
            for (ItemAttributeModifiers.Entry entry : component.modifiers()) {
                Holder attribute = entry.attribute();
                if (attribute == Attributes.ARMOR) {
                    score = (float)((double)score + entry.modifier().amount());
                }
                if (attribute != Attributes.ARMOR_TOUGHNESS) continue;
                score = (float)((double)score + entry.modifier().amount());
            }
            score += (float)(JJElytraSwapInit.getLevel((ResourceKey<Enchantment>)Enchantments.PROTECTION, chestplateItem) * 2);
            score = (float)((double)score + (double)JJElytraSwapInit.getLevel((ResourceKey<Enchantment>)Enchantments.MENDING, chestplateItem) * 0.5);
            score = (float)((double)score + (JJElytraSwapInit.stackHasComponent(chestplateItem, DataComponents.CUSTOM_NAME) ? 0.25 : 0.0));
            score = (float)((double)score + (double)JJElytraSwapInit.getLevel((ResourceKey<Enchantment>)Enchantments.UNBREAKING, chestplateItem) * 0.24 / 3.0);
        }
        return (int)(score * 1000.0f);
    }

    private static void wearElytra(int slotId) {
        JJElytraSwapInit.swap(slotId, Minecraft.getInstance());
        try {
            Minecraft.getInstance().getConnection().send((Packet)new ServerboundPlayerCommandPacket((Entity)Minecraft.getInstance().player, ServerboundPlayerCommandPacket.Action.START_FALL_FLYING));
            Minecraft.getInstance().player.startFallFlying();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    private static void swap(int slot, Minecraft client) {
        int slot2 = slot;
        if (slot2 == 40) {
            slot2 = 45;
        }
        if (slot2 < 9) {
            slot2 += 36;
        }
        try {
            client.gameMode.handleInventoryMouseClick(0, slot2, 0, ClickType.PICKUP, (Player)client.player);
            client.gameMode.handleInventoryMouseClick(0, 6, 0, ClickType.PICKUP, (Player)client.player);
            client.gameMode.handleInventoryMouseClick(0, slot2, 0, ClickType.PICKUP, (Player)client.player);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isSlotChestplate(int slotId) {
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        ItemStack chestSlot = Minecraft.getInstance().player.getInventory().getItem(slotId);
        return !chestSlot.isEmpty() && JJElytraSwapInit.stackHasComponent(chestSlot, DataComponents.EQUIPPABLE) && ((Equippable)chestSlot.get(DataComponents.EQUIPPABLE)).slot() == EquipmentSlot.CHEST && JJElytraSwapInit.getLevel((ResourceKey<Enchantment>)Enchantments.BINDING_CURSE, chestSlot) == 0;
    }

    private static int[] slotArray() {
        int i;
        int[] range = new int[37];
        for (i = 0; i < 9; ++i) {
            range[i] = 8 - i;
        }
        for (i = 9; i < 36; ++i) {
            range[i] = 35 - (i - 9);
        }
        range[36] = 40;
        return range;
    }

    public static void onInitializeClient() {
        KeyMapping bind = PLATFORM.registerKeyBind("jjelytraswap.keybind", -1, "JJElytraSwap");
        PLATFORM.registerClientTickEvent(client -> {
            boolean shouldWearChestplate;
            if (client.level == null || client.player == null) {
                return;
            }
            if (bind.consumeClick()) {
                enabled = !enabled;
                String ts = "jjelytraswap." + (enabled ? "enabled" : "disabled");
                client.gui.getChat().addMessage((Component)Component.translatable((String)ts));
            }
            if (!enabled) {
                return;
            }
            boolean isInAir = !client.player.onGround() && !client.player.isInLiquid();
            boolean bl = shouldWearChestplate = !isInAir;
            if (shouldWearChestplate && !shouldWearChestplatePrevTick && JJElytraSwapInit.stackHasComponent(Minecraft.getInstance().player.getItemBySlot(EquipmentSlot.CHEST), DataComponents.GLIDER)) {
                JJElytraSwapInit.tryWearChestplate(client);
            }
            shouldWearChestplatePrevTick = shouldWearChestplate;
        });
    }

    private static void debugLogInChat(Object ... objects) {
        ChatComponent chat = Minecraft.getInstance().gui.getChat();
        if (chat == null) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        for (Object object : objects) {
            if (object instanceof Component) {
                Component text = (Component)object;
                msg.append(text.getString(100000));
                continue;
            }
            msg.append(object);
        }
        chat.addMessage(Component.nullToEmpty((String)msg.toString()));
    }
}

