/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.jjelytraswap.platforms.neoforge;

import io.github.jumperonjava.jjelytraswap.JJElytraSwapInit;
import io.github.jumperonjava.jjelytraswap.ModPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="jjelytraswap")
public class JJElytraSwapNeoForge {
    private static IEventBus MOD_EVENT_BUS;
    private static IEventBus GAME_EVENT_BUS;

    public JJElytraSwapNeoForge(IEventBus eventBus) {
        MOD_EVENT_BUS = eventBus;
        GAME_EVENT_BUS = NeoForge.EVENT_BUS;
        JJElytraSwapInit.entrypoint(new NeoForgePlatform());
    }

    public static class NeoForgePlatform
    implements ModPlatform {
        List<Consumer<Minecraft>> clientEvents = new ArrayList<Consumer<Minecraft>>();

        @Override
        public String getModloader() {
            return "NeoForge";
        }

        @Override
        public boolean isModLoaded(String modId) {
            return ModList.get().isLoaded(modId);
        }

        @Override
        public void registerClientTickEvent(Consumer<Minecraft> o) {
            GAME_EVENT_BUS.addListener(event -> o.accept(Minecraft.getInstance()));
        }

        @Override
        public KeyMapping registerKeyBind(String translationKeyName, int defaultKeyId) {
            KeyMapping.Category kbCategory = new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"jjelytraswap", (String)"generic"));
            KeyMapping keyBinding = new KeyMapping(translationKeyName, defaultKeyId, kbCategory);
            MOD_EVENT_BUS.addListener(event -> event.register(keyBinding));
            return keyBinding;
        }
    }
}

