package com.atsuishio.superbwarfare.client.model.item;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.AnimationHelper;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.special.TaserItem;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;

public class TaserItemModel extends CustomGunModel<TaserItem> {

    @Override
    public ResourceLocation getAnimationResource(TaserItem animatable) {
        return Mod.loc("animations/taser.animation.json");
    }

    @Override
    public ResourceLocation getModelResource(TaserItem animatable) {
        return Mod.loc("geo/taser.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource(TaserItem animatable) {
        return Mod.loc("textures/item/taser.png");
    }

    @Override
    public ResourceLocation getLODModelResource(TaserItem animatable) {
        return Mod.loc("geo/lod/taser.geo.json");
    }

    @Override
    public ResourceLocation getLODTextureResource(TaserItem animatable) {
        return Mod.loc("textures/item/taser.png");
    }

    @Override
    public void setCustomAnimations(TaserItem animatable, long instanceId, AnimationState<TaserItem> animationState) {
        Player player = Minecraft.getInstance().player;
        if (player == null) return;
        ItemStack stack = player.getMainHandItem();
        if (shouldCancelRender(stack, animationState)) return;

        CoreGeoBone gun = getAnimationProcessor().getBone("bone");
        CoreGeoBone shen = getAnimationProcessor().getBone("shen");

        double zt = ClientEventHandler.zoomTime;
        double zp = ClientEventHandler.zoomPos;
        double zpz = ClientEventHandler.zoomPosZ;

        ClientEventHandler.handleShootAnimation(shen, 0.1f, -0.1f, 0.3f, 0.2f, 0.1f, 0.1f, 0.5f, 0.75f);

        CrossHairOverlay.gunRot = shen.getRotZ();

        gun.setPosX(1.82f * (float) zp);
        gun.setPosY(1.3f * (float) zp - (float) (0.3f * zpz));
        gun.setPosZ((float) zp + (float) (0.5f * zpz));
        gun.setRotZ((float) (0.05f * zpz));

        ClientEventHandler.gunRootMove(getAnimationProcessor(), 0, 0, 0, false);

        CoreGeoBone camera = getAnimationProcessor().getBone("camera");
        CoreGeoBone main = getAnimationProcessor().getBone("0");

        float numR = (float) (1 - 0.72 * zt);
        float numP = (float) (1 - 0.68 * zt);

        AnimationHelper.handleReloadShakeAnimation(stack, main, camera, numR, numP);
        ClientEventHandler.handleReloadShake(Mth.RAD_TO_DEG * camera.getRotX(), Mth.RAD_TO_DEG * camera.getRotY(), Mth.RAD_TO_DEG * camera.getRotZ());
    }
}
