package com.atsuishio.superbwarfare.client.model.item;

import com.atsuishio.superbwarfare.client.animation.AnimationHelper;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.rifle.Qbz95Item;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;

import static com.atsuishio.superbwarfare.event.ClientEventHandler.isProne;

public class Qbz95ItemModel extends CustomGunModel<Qbz95Item> {
    public static float rotXBipod = 0f;

    public static float lHandPosX = 0f;
    public static float lHandPosY = 0f;
    public static float lHandPosZ = 0f;
    public static float lHandRotX = 0f;
    public static float lHandRotY = 0f;
    public static float lHandRotZ = 0f;

    @Override
    public void setCustomAnimations(Qbz95Item animatable, long instanceId, AnimationState<Qbz95Item> animationState) {
        Player player = Minecraft.getInstance().player;
        if (player == null) return;
        ItemStack stack = player.getMainHandItem();
        if (shouldCancelRender(stack, animationState)) return;

        GeoBone gun = getAnimationProcessor().getBone("bone");
        GeoBone bolt = getAnimationProcessor().getBone("bolt2");
        GeoBone button = getAnimationProcessor().getBone("button");
        GeoBone button3 = getAnimationProcessor().getBone("button3");
        GeoBone button6 = getAnimationProcessor().getBone("button6");
        GeoBone camera = getAnimationProcessor().getBone("camera");
        GeoBone main = getAnimationProcessor().getBone("0");

        float times = 0.6f * (float) Math.min(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true), 0.8);
        double zt = ClientEventHandler.zoomTime;
        double zp = ClientEventHandler.zoomPos;
        double zpz = ClientEventHandler.zoomPosZ;

        double fp = ClientEventHandler.firePos;

        var data = GunData.from(stack);
        int type = data.attachment.get(AttachmentType.SCOPE);

        float posYAlt = switch (type) {
            case 2 -> 0.85f;
            case 3 -> 0.9f;
            default -> 0f;
        };
        float posY = switch (type) {
            case 0 -> 0.535f;
            case 1 -> -0.155f;
            case 2 -> -0.975f + posYAlt;
            case 3 -> -0.64f + posYAlt;
            default -> 0f;
        };
        float posZ = switch (type) {
            case 0 -> 10.6f;
            case 1 -> 8.8f;
            case 2 -> 14.51f;
            case 3 -> 17.2f;
            default -> 0f;
        };
        float scaleZ = switch (type) {
            case 0 -> 0.5f;
            case 1 -> 0.51f;
            case 2 -> 0.792f;
            case 3 -> 0.891f;
            default -> 0f;
        };

        gun.setPosX(3.71f * (float) zp);
        gun.setPosY(posY * (float) zp - (float) (0.2f * zpz) - posYAlt);
        gun.setPosZ(posZ * (float) zp + (float) (0.3f * zpz));
        gun.setRotZ((float) (0.05f * zpz));
        gun.setScaleZ(1f - (scaleZ * (float) zp));

        button.setScaleY(1f - (0.85f * (float) zp));
        button3.setScaleX(1f - (0.5f * (float) zp));
        button6.setScaleX(1f - (0.8f * (float) zp));

        GeoBone shen;
        if (zt < 0.5) {
            shen = getAnimationProcessor().getBone("fireRootNormal");
        } else {
            shen = switch (type) {
                case 0 -> getAnimationProcessor().getBone("fireRoot0");
                case 1 -> getAnimationProcessor().getBone("fireRoot1");
                case 2 -> getAnimationProcessor().getBone("fireRoot2");
                case 3 -> getAnimationProcessor().getBone("fireRoot3");
                default -> getAnimationProcessor().getBone("fireRootNormal");
            };
        }

        ClientEventHandler.handleShootAnimation(shen, 0.95f, -0.95f, 0.85f, 0.8f, 0.9f, 1, 0.5f, 0.8f);

        CrossHairOverlay.gunRot = shen.getRotZ();
        bolt.setPosZ(5f * (float) fp);

        GeoBone l = getAnimationProcessor().getBone("l");
        GeoBone r = getAnimationProcessor().getBone("r");
        rotXBipod = Mth.lerp(1.5f * times, rotXBipod, isProne(player) ? -90 : 0);
        l.setRotX(rotXBipod * Mth.DEG_TO_RAD);
        r.setRotX(rotXBipod * Mth.DEG_TO_RAD);

        if (data.holdOpen.get()) {
            bolt.setPosZ(5f);
        }

        GeoBone flare = getAnimationProcessor().getBone("flare");
        flare.setPosZ(-2);

        ClientEventHandler.gunRootMove(getAnimationProcessor(), 6, 0, 0, false);
        float numR = (float) (1 - 0.975 * zt);
        float numP = (float) (1 - 0.97 * zt);

        GeoBone leftHand = getAnimationProcessor().getBone("Lefthand");
        GeoBone anim = getAnimationProcessor().getBone("anim");

        boolean isZooming = zt > 0 && anim.getPosZ() == 0;

        lHandPosX = Mth.lerp(1.5f * times, lHandPosX, isZooming ? 0 : leftHand.getPosX());
        lHandPosY = Mth.lerp(1.5f * times, lHandPosY, isZooming ? 0 : leftHand.getPosY());
        lHandPosZ = Mth.lerp(1.5f * times, lHandPosZ, isZooming ? 0 : leftHand.getPosZ());
        lHandRotX = Mth.lerp(1.5f * times, lHandRotX, isZooming ? -2.1f : leftHand.getRotX());
        lHandRotY = Mth.lerp(1.5f * times, lHandRotY, isZooming ? 0.2419f : leftHand.getRotY());
        lHandRotZ = Mth.lerp(1.5f * times, lHandRotZ, isZooming ? 2.9228f : leftHand.getRotZ());


        if (GunData.from(stack).reload.empty()) {
            leftHand.setPosX(lHandPosX);
            leftHand.setPosY(lHandPosY);
            leftHand.setPosZ(lHandPosZ);
            leftHand.setRotX(lHandRotX);
            leftHand.setRotY(lHandRotY);
            leftHand.setRotZ(lHandRotZ);
        }

        AnimationHelper.handleReloadShakeAnimation(stack, main, camera, numR, numP);
        ClientEventHandler.handleReloadShake(Mth.RAD_TO_DEG * camera.getRotX(), Mth.RAD_TO_DEG * camera.getRotY(), Mth.RAD_TO_DEG * camera.getRotZ());
    }
}
