package com.atsuishio.superbwarfare.client.renderer.block;

import com.atsuishio.superbwarfare.block.VehicleAssemblingTableBlock;
import com.atsuishio.superbwarfare.block.entity.VehicleAssemblingTableBlockEntity;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.client.layer.block.VehicleAssemblingTableBlockLayer;
import com.atsuishio.superbwarfare.client.model.block.VehicleAssemblingTableBlockModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class VehicleAssemblingTableBlockEntityRenderer extends GeoBlockRenderer<VehicleAssemblingTableBlockEntity> {

    public VehicleAssemblingTableBlockEntityRenderer() {
        super(new VehicleAssemblingTableBlockModel());
        this.addRenderLayer(new VehicleAssemblingTableBlockLayer(this));
    }

    @Override
    public RenderType getRenderType(VehicleAssemblingTableBlockEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent(getTextureLocation(animatable));
    }

    @Override
    public boolean shouldRender(VehicleAssemblingTableBlockEntity blockEntity, @NotNull Vec3 cameraPos) {
        return blockEntity.getBlockState().getValue(VehicleAssemblingTableBlock.BLOCK_PART) == BlockPart.FLB;
    }

    @Override
    public @NotNull AABB getRenderBoundingBox(@NotNull VehicleAssemblingTableBlockEntity blockEntity) {
        // 创建一个更大的边界框（示例：覆盖从方块底部到顶部上方2格的范围）
        double expansion = 2.0; // 根据模型实际大小调整
        var worldPosition = blockEntity.getBlockPos();

        return new AABB(
                worldPosition.getX() - 1,
                worldPosition.getY(),
                worldPosition.getZ() - 1,
                worldPosition.getX() + 2,
                worldPosition.getY() + expansion,
                worldPosition.getZ() + 2
        );
    }
}
