/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.SuperbItemInterfaceBlock;
import com.atsuishio.superbwarfare.block.entity.CreativeSuperbItemInterfaceBlockEntity;
import com.atsuishio.superbwarfare.block.entity.SuperbItemInterfaceBlockEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreativeSuperbItemInterfaceBlock
extends SuperbItemInterfaceBlock {
    private static final MapCodec<CreativeSuperbItemInterfaceBlock> CODEC = BlockBehaviour.simpleCodec(prop -> new CreativeSuperbItemInterfaceBlock());

    @Override
    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.creative_superb_item_interface").withStyle(ChatFormatting.GRAY));
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CreativeSuperbItemInterfaceBlockEntity(pos, state);
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? null : CreativeSuperbItemInterfaceBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CREATIVE_SUPERB_ITEM_INTERFACE.get()), SuperbItemInterfaceBlockEntity::serverTick);
    }

    @Override
    @ParametersAreNonnullByDefault
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof CreativeSuperbItemInterfaceBlockEntity) {
            CreativeSuperbItemInterfaceBlockEntity entity = (CreativeSuperbItemInterfaceBlockEntity)blockentity;
            player.openMenu((MenuProvider)entity);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void onRemove(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof CreativeSuperbItemInterfaceBlockEntity) {
                CreativeSuperbItemInterfaceBlockEntity entity = (CreativeSuperbItemInterfaceBlockEntity)blockentity;
                Containers.dropContents((Level)pLevel, (BlockPos)pPos, (Container)entity);
                pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Override
    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

