/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.entity.LuckyContainerBlockEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LuckyContainerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPENED = BooleanProperty.create((String)"opened");

    public LuckyContainerBlock() {
        this(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.0f).noOcclusion().requiresCorrectToolForDrops());
    }

    public LuckyContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide || ((Boolean)state.getValue((Property)OPENED)).booleanValue() || !(level.getBlockEntity(pos) instanceof LuckyContainerBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!stack.is(ModTags.Items.TOOLS_CROWBAR)) {
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.container.fail.crowbar"), true);
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPENED, (Comparable)Boolean.valueOf(true)));
        level.playSound(null, BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (SoundEvent)ModSounds.OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.isClientSide) {
            return LuckyContainerBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.LUCKY_CONTAINER.get()), LuckyContainerBlockEntity::serverTick);
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CustomData component = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag tag = component == null ? new CompoundTag() : component.copyTag();
        Object location = tag.getString("Location");
        if (((String)location).startsWith("superbwarfare")) {
            String[] split = ((String)location).split("superbwarfare:");
            if (split.length == 2) {
                location = "location." + split[1];
            }
            tooltipComponents.add((Component)Component.translatable((String)("des.superbwarfare.lucky_container." + (String)location)).withStyle(ChatFormatting.GRAY));
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)OPENED) != false ? LuckyContainerBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0) : LuckyContainerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return LuckyContainerBlock.simpleCodec(LuckyContainerBlock::new);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new LuckyContainerBlockEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{OPENED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.getCloneItemStack(level, pos, state);
        level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.LUCKY_CONTAINER.get()).ifPresent(blockEntity -> blockEntity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess()));
        return itemstack;
    }
}

