/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.entity.SmallContainerBlockEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SmallContainerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPENED = BooleanProperty.create((String)"opened");
    private static final MapCodec<SmallContainerBlock> CODEC = BlockBehaviour.simpleCodec(SmallContainerBlock::new);

    public SmallContainerBlock() {
        this(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.0f).noOcclusion().requiresCorrectToolForDrops());
    }

    public SmallContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level.isClientSide || ((Boolean)state.getValue((Property)OPENED)).booleanValue() || !((blockEntity = level.getBlockEntity(pos)) instanceof SmallContainerBlockEntity)) {
            return InteractionResult.PASS;
        }
        SmallContainerBlockEntity blockEntity2 = (SmallContainerBlockEntity)blockEntity;
        ItemStack stack = player.getItemInHand(player.getUsedItemHand());
        if (!stack.is(ModTags.Items.TOOLS_CROWBAR)) {
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.container.fail.crowbar"), true);
            return InteractionResult.PASS;
        }
        blockEntity2.setPlayer(player);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPENED, (Comparable)Boolean.valueOf(true)));
        level.playSound(null, BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (SoundEvent)ModSounds.OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> pBlockEntityType) {
        if (!level.isClientSide) {
            return SmallContainerBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SMALL_CONTAINER.get()), SmallContainerBlockEntity::serverTick);
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        SeededContainerLoot data = (SeededContainerLoot)stack.get(DataComponents.CONTAINER_LOOT);
        if (data != null) {
            Object lootTable = data.lootTable().location().toString();
            if (((String)lootTable).startsWith("superbwarfare:containers/")) {
                String[] split = ((String)lootTable).split("superbwarfare:containers/");
                if (split.length == 2) {
                    lootTable = "loot." + split[1];
                }
                tooltipComponents.add((Component)Component.translatable((String)("des.superbwarfare.small_container." + (String)lootTable)).withStyle(ChatFormatting.GRAY));
            } else {
                long seed = data.seed();
                if (seed != 0L && seed % 205L == 0L) {
                    tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.small_container.special").withStyle(ChatFormatting.GRAY));
                } else {
                    tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.small_container.random").withStyle(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.small_container").withStyle(ChatFormatting.GRAY));
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            return (Boolean)state.getValue((Property)OPENED) != false ? SmallContainerBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)12.0, (double)14.0) : SmallContainerBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)13.5, (double)15.0);
        }
        return (Boolean)state.getValue((Property)OPENED) != false ? SmallContainerBlock.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0) : SmallContainerBlock.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)13.5, (double)16.0);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new SmallContainerBlockEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{OPENED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.SMALL_CONTAINER.get()).ifPresent(blockEntity -> blockEntity.saveToItem(stack, (HolderLookup.Provider)level.registryAccess()));
        return stack;
    }
}

