/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ContainerBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    public EntityType<?> entityType;
    public CompoundTag entityTag = null;
    public int tick = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ContainerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CONTAINER.get(), pos, state);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ContainerBlockEntity blockEntity) {
        if (!((Boolean)pState.getValue((Property)ContainerBlock.OPENED)).booleanValue()) {
            return;
        }
        if (blockEntity.tick < 20) {
            ++blockEntity.tick;
            blockEntity.setChanged();
            if (blockEntity.tick == 18) {
                ParticleTool.sendParticle((ServerLevel)pLevel, ParticleTypes.EXPLOSION, pPos.getX(), pPos.getY() + 1, pPos.getZ(), 40, 1.5, 1.5, 1.5, 1.0, false);
                pLevel.playSound(null, pPos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.2f) * 0.7f);
            }
        } else {
            Direction direction = (Direction)pState.getValue((Property)ContainerBlock.FACING);
            Entity entity = blockEntity.entityType.create(pLevel);
            if (entity == null) {
                return;
            }
            if (blockEntity.entityTag != null) {
                entity.load(blockEntity.entityTag);
            }
            entity.setPos((double)pPos.getX() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)pPos.getY() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)pPos.getZ() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f);
            entity.setYRot(direction.toYRot());
            if (entity instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entity;
                vehicle.getEntityData().set(VehicleEntity.SERVER_YAW, (Object)Float.valueOf(direction.toYRot()));
            }
            pLevel.addFreshEntity(entity);
            pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
        }
    }

    private PlayState predicate(AnimationState<ContainerBlockEntity> event) {
        if (((Boolean)this.getBlockState().getValue((Property)ContainerBlock.OPENED)).booleanValue()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.container.open"));
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)this.saveToTag()));
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadFromTag(tag);
    }

    private void loadFromTag(CompoundTag tag) {
        if (tag.contains("EntityType")) {
            this.entityType = EntityType.byString((String)tag.getString("EntityType")).orElse(null);
        }
        if (tag.contains("Entity") && this.entityTag == null && this.entityType != null) {
            this.entityTag = tag.getCompound("Entity");
        }
        this.tick = tag.getInt("Tick");
    }

    private CompoundTag saveToTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", "superbwarfare:container");
        this.saveDataToTag(tag);
        return tag;
    }

    private void saveDataToTag(CompoundTag tag) {
        if (this.entityType != null) {
            tag.putString("EntityType", EntityType.getKey(this.entityType).toString());
        }
        if (this.entityTag != null) {
            tag.put("Entity", (Tag)this.entityTag);
        }
        tag.putInt("Tick", this.tick);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveDataToTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public void saveToItem(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveToItem(stack, registries);
        CompoundTag tag = new CompoundTag();
        if (this.entityType != null) {
            tag.putString("EntityType", EntityType.getKey(this.entityType).toString());
        }
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)this.getType(), (CompoundTag)tag);
    }
}

