/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.LuckyContainerBlock;
import com.atsuishio.superbwarfare.data.container.ContainerDataManager;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LuckyContainerBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    @Nullable
    public ResourceLocation location;
    @Nullable
    public ResourceLocation icon;
    public int tick = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public LuckyContainerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LUCKY_CONTAINER.get(), pos, state);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, LuckyContainerBlockEntity blockEntity) {
        if (!((Boolean)pState.getValue((Property)LuckyContainerBlock.OPENED)).booleanValue()) {
            return;
        }
        if (blockEntity.tick < 20) {
            ++blockEntity.tick;
            blockEntity.setChanged();
            if (blockEntity.tick == 18) {
                ParticleTool.sendParticle((ServerLevel)pLevel, ParticleTypes.EXPLOSION, pPos.getX(), pPos.getY() + 1, pPos.getZ(), 40, 1.5, 1.5, 1.5, 1.0, false);
                pLevel.playSound(null, pPos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.2f) * 0.7f);
            }
        } else {
            Entity entity;
            Direction direction = (Direction)pState.getValue((Property)LuckyContainerBlock.FACING);
            EntityType<?> type = blockEntity.unpackEntities();
            if (type != null && (entity = type.create(pLevel)) != null) {
                entity.setPos((double)pPos.getX() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)pPos.getY() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)pPos.getZ() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f);
                entity.setYRot(direction.toYRot());
                if (entity instanceof VehicleEntity) {
                    VehicleEntity vehicle = (VehicleEntity)entity;
                    vehicle.getEntityData().set(VehicleEntity.SERVER_YAW, (Object)Float.valueOf(direction.toYRot()));
                }
                pLevel.addFreshEntity(entity);
            }
            pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
        }
    }

    @Nullable
    public EntityType<?> unpackEntities() {
        ContainerDataManager dataManager;
        Optional<List<Pair<String, Integer>>> list;
        if (this.location != null && this.level != null && this.level.getServer() != null && (list = (dataManager = ContainerDataManager.INSTANCE).getEntityTypes(this.location)).isPresent()) {
            List<Pair<String, Integer>> pool = list.get();
            int sum = pool.stream().mapToInt(Pair::second).sum();
            if (sum <= 0) {
                return null;
            }
            int rand = this.level.random.nextInt(sum);
            int cumulativeWeight = 0;
            for (Pair<String, Integer> entry : pool) {
                if (rand >= (cumulativeWeight += ((Integer)entry.second()).intValue())) continue;
                return EntityType.byString((String)((String)entry.first())).orElse(null);
            }
        }
        return null;
    }

    private PlayState predicate(AnimationState<LuckyContainerBlockEntity> event) {
        if (((Boolean)this.getBlockState().getValue((Property)LuckyContainerBlock.OPENED)).booleanValue()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.container.open"));
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @ParametersAreNonnullByDefault
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("Location", 8)) {
            this.location = ResourceLocation.parse((String)tag.getString("Location"));
        }
        if (tag.contains("Icon", 8)) {
            this.icon = ResourceLocation.parse((String)tag.getString("Icon"));
        }
        this.tick = tag.getInt("Tick");
    }

    @ParametersAreNonnullByDefault
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.location != null) {
            tag.putString("Location", this.location.toString());
        }
        if (this.icon != null) {
            tag.putString("Icon", this.icon.toString());
        }
        tag.putInt("Tick", this.tick);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    @ParametersAreNonnullByDefault
    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        if (this.location != null) {
            tag.putString("Location", this.location.toString());
        }
        if (this.icon != null) {
            tag.putString("Icon", this.icon.toString());
        }
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)this.getType(), (CompoundTag)tag);
    }
}

