/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.atsuishio.superbwarfare.client.screens.WeaponEditScreen;
import com.atsuishio.superbwarfare.compat.CompatHolder;
import com.atsuishio.superbwarfare.compat.clothconfig.ClothConfigHelper;
import com.atsuishio.superbwarfare.config.client.ReloadConfig;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.SeekType;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.ItemScreenProvider;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.send.AdjustMortarAngleMessage;
import com.atsuishio.superbwarfare.network.message.send.AdjustZoomFovMessage;
import com.atsuishio.superbwarfare.network.message.send.DoubleJumpMessage;
import com.atsuishio.superbwarfare.network.message.send.DroneFireMessage;
import com.atsuishio.superbwarfare.network.message.send.EditMessage;
import com.atsuishio.superbwarfare.network.message.send.FireKeyMessage;
import com.atsuishio.superbwarfare.network.message.send.FireModeMessage;
import com.atsuishio.superbwarfare.network.message.send.InteractMessage;
import com.atsuishio.superbwarfare.network.message.send.ParachuteMessage;
import com.atsuishio.superbwarfare.network.message.send.PlayerStopRidingMessage;
import com.atsuishio.superbwarfare.network.message.send.ReloadMessage;
import com.atsuishio.superbwarfare.network.message.send.SensitivityMessage;
import com.atsuishio.superbwarfare.network.message.send.SetFiringParametersMessage;
import com.atsuishio.superbwarfare.network.message.send.SwitchScopeMessage;
import com.atsuishio.superbwarfare.network.message.send.SwitchVehicleWeaponMessage;
import com.atsuishio.superbwarfare.network.message.send.UnloadMessage;
import com.atsuishio.superbwarfare.network.message.send.ZoomMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.resource.gun.DefaultGunResource;
import com.atsuishio.superbwarfare.resource.gun.GunResource;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClickHandler {
    public static boolean switchZoom = false;

    private static boolean notInGame() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return true;
        }
        if (mc.getOverlay() != null) {
            return true;
        }
        if (mc.screen != null) {
            return true;
        }
        if (!mc.mouseHandler.isMouseGrabbed()) {
            return true;
        }
        return !mc.isWindowActive();
    }

    @SubscribeEvent
    public static void onButtonReleased(InputEvent.MouseButton.Pre event) {
        if (ClickHandler.notInGame()) {
            return;
        }
        if (event.getAction() != 0) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        int button = event.getButton();
        if (button == ModKeyMappings.FIRE.getKey().getValue()) {
            ClickHandler.handleWeaponFireRelease();
        }
        if (button == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
            ClickHandler.handleWeaponZoomRelease();
            return;
        }
        if (button == ModKeyMappings.SWITCH_ZOOM.getKey().getValue() && !switchZoom) {
            ClickHandler.handleWeaponZoomRelease();
        }
    }

    private static boolean cancelFireKey(Player player, ItemStack stack) {
        VehicleEntity vehicle;
        Entity entity;
        return stack.getItem() instanceof GunItem || stack.is((Item)ModItems.MONITOR.get()) || stack.is((Item)ModItems.LUNGE_MINE.get()) || stack.is((Item)ModItems.ARTILLERY_INDICATOR.get()) || player.hasEffect(ModMobEffects.SHOCK) || (entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player);
    }

    private static boolean cancelZoomKey(Player player, ItemStack stack) {
        VehicleEntity vehicle;
        Entity entity;
        return stack.getItem() instanceof GunItem || (entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player) && !stack.has(DataComponents.FOOD);
    }

    @SubscribeEvent
    public static void onButtonPressed(InputEvent.MouseButton.Pre event) {
        if (ClickHandler.notInGame()) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        int button = event.getButton();
        InputConstants.Key fireKey = ModKeyMappings.FIRE.getKey();
        if (fireKey.getType() == InputConstants.Type.MOUSE && fireKey.getValue() == button && ClickHandler.cancelFireKey((Player)player, stack)) {
            event.setCanceled(true);
        }
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        InputConstants.Key zoomKey = ModKeyMappings.HOLD_ZOOM.getKey();
        if (zoomKey.getType() == InputConstants.Type.MOUSE && zoomKey.getValue() == button && ClickHandler.cancelZoomKey((Player)player, stack)) {
            event.setCanceled(true);
        }
        if (button == 2) {
            if (player.hasEffect(ModMobEffects.SHOCK)) {
                event.setCanceled(true);
                return;
            }
            if (stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                event.setCanceled(true);
            }
            if (stack.is((Item)ModItems.MONITOR.get()) && player.getOffhandItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                event.setCanceled(true);
            }
        }
        if (button == ModKeyMappings.MARK.getKey().getValue()) {
            if (stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                PacketDistributor.sendToServer((CustomPacketPayload)SetFiringParametersMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (stack.is((Item)ModItems.MONITOR.get()) && player.getOffhandItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                ClickHandler.droneLeftClick(stack, (Player)player);
            }
        }
        if (stack.getItem() instanceof GunItem || stack.is((Item)ModItems.MONITOR.get()) || stack.is((Item)ModItems.LUNGE_MINE.get()) || player.getVehicle() instanceof VehicleEntity || stack.is(Items.SPYGLASS) && player.isScoping() && player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get()) || stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
            if (button == ModKeyMappings.FIRE.getKey().getValue()) {
                ClickHandler.handleWeaponFirePress((Player)player, stack);
            }
            if (button == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
                ClickHandler.handleWeaponZoomPress((Player)player, stack);
                switchZoom = false;
                return;
            }
            if (button == ModKeyMappings.SWITCH_ZOOM.getKey().getValue()) {
                ClickHandler.handleWeaponZoomPress((Player)player, stack);
                switchZoom = !switchZoom;
            }
        }
    }

    @SubscribeEvent
    public static void stopSwing(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getItemInHand(event.getHand()).getItem() instanceof GunItem) {
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void onMouseScrolling(InputEvent.MouseScrollingEvent event) {
        Entity looking;
        VehicleEntity vehicle;
        LocalPlayer player = Minecraft.getInstance().player;
        if (ClickHandler.notInGame()) {
            return;
        }
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        double scroll = event.getScrollDeltaY();
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && player == (vehicle = (VehicleEntity)entity).getFirstPassenger() && ModKeyMappings.FREE_CAMERA.isDown()) {
            ClientMouseHandler.custom3pDistance = Mth.clamp((double)(ClientMouseHandler.custom3pDistance - event.getScrollDeltaY()), (double)-3.0, (double)8.0);
            event.setCanceled(true);
            return;
        }
        if (!Screen.hasShiftDown() && (entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).hasWeapon(vehicle.getSeatIndex((Entity)player)) && vehicle.banHand((LivingEntity)player)) {
            if (ClientEventHandler.switchVehicleWeaponCooldown <= 0) {
                int index = vehicle.getSeatIndex((Entity)player);
                PacketDistributor.sendToServer((CustomPacketPayload)new SwitchVehicleWeaponMessage(index, -scroll, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ClientEventHandler.switchVehicleWeaponCooldown = 3;
            }
            event.setCanceled(true);
        }
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.getItem() instanceof GunItem && ClientEventHandler.zoom) {
            GunData data = GunData.from(stack);
            if (data.canSwitchScope()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SwitchScopeMessage(scroll), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (data.canAdjustZoom() || stack.is((Item)ModItems.MINIGUN.get())) {
                PacketDistributor.sendToServer((CustomPacketPayload)new AdjustZoomFovMessage(scroll), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            event.setCanceled(true);
        }
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            ClientEventHandler.droneFov = Mth.clamp((double)(ClientEventHandler.droneFov + 0.4 * scroll), (double)1.0, (double)6.0);
            event.setCanceled(true);
        }
        if (player.isUsingItem() && player.getUseItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
            ClientEventHandler.artilleryIndicatorCustomZoom = Mth.clamp((double)(ClientEventHandler.artilleryIndicatorCustomZoom + 0.4 * scroll), (double)-2.0, (double)6.0);
            event.setCanceled(true);
        }
        if ((looking = TraceTool.findLookingEntity((Entity)player, 6.0)) instanceof MortarEntity && player.isShiftKeyDown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AdjustMortarAngleMessage(scroll), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        if (ClickHandler.notInGame()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        int key = event.getKey();
        if (key < 0) {
            return;
        }
        if (key == ModKeyMappings.DISMOUNT.getKey().getValue()) {
            ClickHandler.handleDismountPress((Player)player);
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (event.getAction() == 1) {
            VehicleEntity vehicle;
            GunData data;
            Entity entity;
            if (player.hasEffect(ModMobEffects.SHOCK)) {
                return;
            }
            if (key == Minecraft.getInstance().options.keyJump.getKey().getValue()) {
                ClickHandler.handleDoubleJump((Player)player);
                ClickHandler.handleParachute();
            }
            if (key == ModKeyMappings.CONFIG.getKey().getValue() && ModKeyMappings.CONFIG.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.IN_GAME)) {
                ClickHandler.handleConfigScreen((Player)player);
            }
            if (key == ModKeyMappings.RELOAD.getKey().getValue()) {
                ClientEventHandler.burstFireAmount = 0;
                ClientEventHandler.isEditing = false;
                ClientEventHandler.seekingTime = 0;
                ClientEventHandler.lockOn = false;
                ClientEventHandler.lockingEntity = null;
                ClientEventHandler.seekingEntity = null;
                ClientEventHandler.lockingPos = null;
                PacketDistributor.sendToServer((CustomPacketPayload)ReloadMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (key == ModKeyMappings.FIRE_MODE.getKey().getValue() || key == ModKeyMappings.CHANGE_FIRE_MODE_BACKWARD.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FireModeMessage(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ClientEventHandler.burstFireAmount = 0;
            }
            if (key == ModKeyMappings.CHANGE_FIRE_MODE_FORWARD.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FireModeMessage(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ClientEventHandler.burstFireAmount = 0;
            }
            if (key == ModKeyMappings.INTERACT.getKey().getValue()) {
                if (stack.getItem() instanceof GunItem) {
                    KeyMapping.click((InputConstants.Key)mc.options.keyUse.getKey());
                } else if (stack.is((Item)ModItems.MONITOR.get())) {
                    PacketDistributor.sendToServer((CustomPacketPayload)InteractMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (stack.getItem() instanceof GunItem) {
                GunData data2 = GunData.from(stack);
                if (key == ModKeyMappings.UNLOAD.getKey().getValue()) {
                    if (data2.useBackpackAmmo() || data2.ammo.get() + data2.virtualAmmo.get() <= 0) {
                        return;
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)UnloadMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClientEventHandler.burstFireAmount = 0;
                }
                if (data2.compute().getAmmoConsumers().size() > 1) {
                    if (key == ModKeyMappings.CHANGE_AMMO_FORWARD.getKey().getValue()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(5, false, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ClientEventHandler.burstFireAmount = 0;
                    } else if (key == ModKeyMappings.CHANGE_AMMO_BACKWARD.getKey().getValue()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(5, true, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ClientEventHandler.burstFireAmount = 0;
                    }
                }
            }
            if ((entity = player.getVehicle()) instanceof VehicleEntity && (data = (vehicle = (VehicleEntity)entity).getGunData((Entity)player)) != null && data.getDefault().getAmmoConsumers().size() > 1) {
                if (key == ModKeyMappings.CHANGE_AMMO_FORWARD.getKey().getValue()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(5, false, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClientEventHandler.burstFireAmount = 0;
                }
                if (key == ModKeyMappings.CHANGE_AMMO_BACKWARD.getKey().getValue() || key == ModKeyMappings.FIRE_MODE.getKey().getValue()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(5, true, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClientEventHandler.burstFireAmount = 0;
                }
            }
            if (key == ModKeyMappings.EDIT_MODE.getKey().getValue()) {
                ItemScreenProvider provider;
                Screen screen;
                ItemScreenProvider provider2;
                Screen screen2;
                data = stack.getItem();
                if (data instanceof ItemScreenProvider && (screen2 = (provider2 = (ItemScreenProvider)((Object)data)).getItemScreen(stack, (Player)player, InteractionHand.MAIN_HAND)) != null) {
                    Minecraft.getInstance().setScreen(screen2);
                    if (screen2 instanceof WeaponEditScreen) {
                        ClientEventHandler.onOpenEditScreen();
                    }
                    return;
                }
                ItemStack offHand = player.getOffhandItem();
                Item item = offHand.getItem();
                if (item instanceof ItemScreenProvider && (screen = (provider = (ItemScreenProvider)item).getItemScreen(offHand, (Player)player, InteractionHand.OFF_HAND)) != null) {
                    Minecraft.getInstance().setScreen(screen);
                    return;
                }
            }
            if (key == ModKeyMappings.BREATH.getKey().getValue() && !ClientEventHandler.exhaustion && ClientEventHandler.zoom) {
                ClientEventHandler.breath = true;
            }
            if (key == ModKeyMappings.SENSITIVITY_INCREASE.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SensitivityMessage(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (key == ModKeyMappings.SENSITIVITY_REDUCE.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SensitivityMessage(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (stack.getItem() instanceof GunItem || stack.is((Item)ModItems.MONITOR.get()) || (entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).getFirstPassenger() == player || stack.is(Items.SPYGLASS) && player.isScoping() && player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get()) || stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                if (key == ModKeyMappings.FIRE.getKey().getValue()) {
                    ClickHandler.handleWeaponFirePress((Player)player, stack);
                }
                if (key == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
                    ClickHandler.handleWeaponZoomPress((Player)player, stack);
                    switchZoom = false;
                    return;
                }
                if (key == ModKeyMappings.SWITCH_ZOOM.getKey().getValue()) {
                    ClickHandler.handleWeaponZoomPress((Player)player, stack);
                    boolean bl = switchZoom = !switchZoom;
                }
                if (event.getAction() == 0 && key == ModKeyMappings.BREATH.getKey().getValue()) {
                    ClientEventHandler.breath = false;
                }
            }
            if (key == ModKeyMappings.MARK.getKey().getValue()) {
                if (stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                    PacketDistributor.sendToServer((CustomPacketPayload)SetFiringParametersMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (stack.is((Item)ModItems.MONITOR.get()) && player.getOffhandItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                    ClickHandler.droneLeftClick(stack, (Player)player);
                }
            }
        } else {
            if (player.hasEffect(ModMobEffects.SHOCK)) {
                return;
            }
            if (key == ModKeyMappings.FIRE.getKey().getValue()) {
                ClickHandler.handleWeaponFireRelease();
            }
            if (key == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
                ClickHandler.handleWeaponZoomRelease();
                return;
            }
            if (key == ModKeyMappings.SWITCH_ZOOM.getKey().getValue() && !switchZoom) {
                ClickHandler.handleWeaponZoomRelease();
            }
        }
    }

    public static void handleWeaponFirePress(Player player, ItemStack stack) {
        VehicleEntity vehicle;
        ClientEventHandler.isEditing = false;
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player)) {
            if (vehicle.hasWeapon(vehicle.getSeatIndex((Entity)player))) {
                ClientEventHandler.holdFireVehicle = true;
            }
            return;
        }
        if (stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
            ClientEventHandler.holdingFireKey = true;
        }
        if (stack.is(Items.SPYGLASS) && player.isScoping() && player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get())) {
            PacketDistributor.sendToServer((CustomPacketPayload)SetFiringParametersMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (stack.is((Item)ModItems.MONITOR.get())) {
            if (player.getOffhandItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                ClientEventHandler.holdingFireKey = true;
            } else {
                ClickHandler.droneLeftClick(stack, player);
            }
        }
        if (stack.is((Item)ModItems.LUNGE_MINE.get())) {
            ClientEventHandler.usingLunge = true;
        }
        if ((entity = stack.getItem()) instanceof GunItem) {
            GunItem gunItem = (GunItem)entity;
            if (ClientEventHandler.clientTimer.getProgress() == 0L && !ClickHandler.notInGame()) {
                GunData data = GunData.from(stack);
                DefaultGunResource resource = GunResource.compute(stack);
                if (!stack.is((Item)ModItems.BOCEK.get()) && !stack.is((Item)ModItems.AURELIA_SCEPTRE.get())) {
                    if (!data.meleeOnly()) {
                        SoundEvent triggerSound;
                        if (stack.is((Item)ModItems.QL_1031.get()) && data.selectedFireModeInfo().name.equals("Hold") && gunItem.canShoot(data, (Entity)player)) {
                            player.playSound((SoundEvent)ModSounds.QL_1031_CHARGE.get(), 1.0f, 1.0f);
                            ClientEventHandler.shouldPlayDischargeSound = true;
                        }
                        if ((triggerSound = resource.triggerSound) != null && !data.meleeOnly()) {
                            player.playSound(triggerSound, 1.0f, 1.0f);
                        }
                    }
                } else {
                    ClientEventHandler.bowPower = 0.0;
                    ClientEventHandler.holdingFireKey = true;
                    player.setSprinting(false);
                    if (data.hasEnoughAmmoToShoot((Entity)player)) {
                        return;
                    }
                }
                if (!(data.useBackpackAmmo() || data.meleeOnly() || data.hasEnoughAmmoToShoot((Entity)player) || data.reload.time() != 0)) {
                    if (((Boolean)ReloadConfig.LEFT_CLICK_RELOAD.get()).booleanValue()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)ReloadMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ClientEventHandler.burstFireAmount = 0;
                        ClientEventHandler.seekingTime = 0;
                        ClientEventHandler.lockOn = false;
                        ClientEventHandler.lockingEntity = null;
                        ClientEventHandler.seekingEntity = null;
                        ClientEventHandler.lockingPos = null;
                    }
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new FireKeyMessage(0, ClientEventHandler.bowPower, ClientEventHandler.zoom), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    if (!data.reloading() && !data.charging() && !data.bolt.needed.get() && ClientEventHandler.drawTime < 0.01) {
                        FireMode fireMode = data.selectedFireModeInfo().mode;
                        if (fireMode == FireMode.BURST) {
                            if (ClientEventHandler.burstFireAmount == 0) {
                                ClientEventHandler.noSprintTicks = 8.0f;
                                player.setSprinting(false);
                                ClientEventHandler.burstFireAmount = data.compute().burstAmount;
                            }
                        } else if (fireMode == FireMode.SEMI && ClientEventHandler.burstFireAmount == 0) {
                            ClientEventHandler.noSprintTicks = 3.0f;
                            player.setSprinting(false);
                            ClientEventHandler.burstFireAmount = 1;
                        }
                        ClientEventHandler.holdingFireKey = true;
                        player.setSprinting(false);
                    }
                }
            }
        }
    }

    public static void handleWeaponFireRelease() {
        PacketDistributor.sendToServer((CustomPacketPayload)new FireKeyMessage(1, ClientEventHandler.bowPower, ClientEventHandler.zoom), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClientEventHandler.bowPull = false;
        ClientEventHandler.holdingFireKey = false;
        ClientEventHandler.holdFireVehicle = false;
        ClientEventHandler.isEditing = false;
        ClientEventHandler.customRpm = 0;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)ModItems.BOCEK.get())) {
            PacketDistributor.sendToServer((CustomPacketPayload)ReloadMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (stack.getItem() instanceof GunItem) {
            GunData data = GunData.from(stack);
            DefaultGunData computed = data.compute();
            if (computed.seekType == SeekType.HOLD_FIRE) {
                ClientEventHandler.stopWeaponSeekSound((Player)Minecraft.getInstance().player);
            }
        }
    }

    public static void handleWeaponZoomPress(Player player, ItemStack stack) {
        VehicleEntity vehicle;
        PacketDistributor.sendToServer((CustomPacketPayload)new ZoomMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClientEventHandler.isEditing = false;
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).hasWeapon(vehicle.getSeatIndex((Entity)player)) && vehicle.banHand((LivingEntity)player)) {
            ClientEventHandler.zoomVehicle = true;
            return;
        }
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (!GunResource.compute((ItemStack)stack).canZoom) {
            return;
        }
        GunData data = GunData.from(stack);
        ClientEventHandler.zoom = true;
        short level = data.perk.getLevel(ModPerks.INTELLIGENT_CHIP);
        if (level > 0 && ClientEventHandler.lockedEntity == null) {
            ClientEventHandler.lockedEntity = data.perk.has((Perk)ModPerks.PHASE_PENETRATING_BULLET.get()) || data.perk.has((Perk)ModPerks.BEAST_BULLET.get()) ? SeekTool.seekEntityThroughWall((Entity)player, 32 + 8 * (level - 1), 20.0) : SeekTool.seekLivingEntity((Entity)player, 32 + 8 * (level - 1), 20.0);
        }
    }

    public static void handleWeaponZoomRelease() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ZoomMessage(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClientEventHandler.zoom = false;
        ClientEventHandler.zoomVehicle = false;
        ClientEventHandler.lockedEntity = null;
        ClientEventHandler.stopWeaponSeekSound((Player)Minecraft.getInstance().player);
        ClientEventHandler.breath = false;
    }

    private static void handleDoubleJump(Player player) {
        Level level = player.level();
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        if (!level.isLoaded(player.blockPosition())) {
            return;
        }
        if (ClientEventHandler.canDoubleJump) {
            player.setDeltaMovement(new Vec3(player.getLookAngle().x, 0.8, player.getLookAngle().z));
            level.playLocalSound(x, y, z, (SoundEvent)ModSounds.DOUBLE_JUMP.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            PacketDistributor.sendToServer((CustomPacketPayload)DoubleJumpMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            ClientEventHandler.canDoubleJump = false;
        }
    }

    private static void handleParachute() {
        PacketDistributor.sendToServer((CustomPacketPayload)ParachuteMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void handleConfigScreen(Player player) {
        if (ModList.get().isLoaded("cloth_config")) {
            CompatHolder.hasMod("cloth_config", () -> Minecraft.getInstance().setScreen(ClothConfigHelper.getConfigScreen(null)));
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.no_cloth_config").withStyle(ChatFormatting.RED), true);
        }
    }

    private static void handleDismountPress(Player player) {
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if ((!vehicle.onGround() || vehicle.getDeltaMovement().length() >= 0.1) && ClientEventHandler.dismountCountdown <= 0) {
                if (vehicle.allowEjection(vehicle.getSeatIndex((Entity)player))) {
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mount.onboard", (Object[])new Object[]{ModKeyMappings.DISMOUNT.getTranslatedKeyMessage()}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"mount.onboard", (Object[])new Object[]{ModKeyMappings.DISMOUNT.getTranslatedKeyMessage()}), true);
                }
                ClientEventHandler.dismountCountdown = 20;
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new PlayerStopRidingMessage(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ClientEventHandler.stopVehicleReloadSound(player);
        }
    }

    public static void droneLeftClick(ItemStack stack, Player player) {
        DroneEntity drone;
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked") && (drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"))) != null) {
            boolean lookAtEntity = false;
            Entity lookingEntity = SeekTool.seekLivingEntity(drone, 512.0, 2.0 / ClientEventHandler.droneFovLerp);
            BlockHitResult result = player.level().clip(new ClipContext(drone.getEyePosition(), drone.getEyePosition().add(drone.getLookAngle().scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)drone));
            Vec3 pos = result.getLocation();
            if (lookingEntity != null && !player.isShiftKeyDown()) {
                lookAtEntity = true;
            }
            if (lookAtEntity) {
                pos = lookingEntity.position();
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new DroneFireMessage(pos.toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

