/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.client.animation.AnimationCurves;
import com.atsuishio.superbwarfare.client.animation.AnimationTimer;
import com.atsuishio.superbwarfare.client.animation.ValueAnimator;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoSupplierItem;
import com.atsuishio.superbwarfare.item.common.ammo.box.AmmoBoxInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AmmoCountOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("ammo_count");
    private static final AnimationTimer ammoInfoTimer = new AnimationTimer(500L, 2000L).forwardAnimation(AnimationCurves.EASE_OUT_EXPO).backwardAnimation(AnimationCurves.EASE_IN_EXPO);
    private static final AnimationTimer ammoBoxTimer = new AnimationTimer(500L).forwardAnimation(AnimationCurves.EASE_OUT_EXPO).backwardAnimation(AnimationCurves.EASE_IN_EXPO);
    private static final ValueAnimator<Integer>[] ammoCountAnimators = ValueAnimator.create(Ammo.values().length, 800L, 0);
    private static final ValueAnimator<Integer>[] ammoBoxAnimators = ValueAnimator.create(Ammo.values().length, 800L, 0);

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        VehicleEntity vehicle;
        Entity entity;
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        boolean startRenderingAmmoInfo = false;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator()) {
            return;
        }
        boolean isAmmoBox = false;
        long currentTime = System.currentTimeMillis();
        ItemStack stack = player.getMainHandItem();
        if (!(!(stack.getItem() instanceof AmmoSupplierItem) && stack.getItem() != ModItems.AMMO_BOX.get() || (entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player))) {
            startRenderingAmmoInfo = ammoInfoTimer.getProgress(currentTime) == 0.0f;
            ammoInfoTimer.forward(currentTime);
            if (stack.getItem() == ModItems.AMMO_BOX.get()) {
                isAmmoBox = true;
                ammoBoxTimer.forward(currentTime);
            } else {
                ammoBoxTimer.backward(currentTime);
            }
        } else {
            ammoInfoTimer.backward(currentTime);
            ammoBoxTimer.backward(currentTime);
        }
        if (!ammoInfoTimer.isForward() && ammoInfoTimer.finished(currentTime)) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        float ammoX = ammoInfoTimer.lerp(w + 120, (float)w / 2.0f + 40.0f, currentTime);
        int fontHeight = 15;
        float yOffset = (float)(-h - Ammo.values().length * 15) / 2.0f;
        PlayerVariable cap = (PlayerVariable)player.getData(ModAttachments.PLAYER_VARIABLE);
        Font font = Minecraft.getInstance().font;
        for (Ammo type : Ammo.values()) {
            int index = type.ordinal();
            int ammoCount = type.get(cap);
            ValueAnimator<Integer> animator = ammoCountAnimators[index];
            ValueAnimator<Integer> boxAnimator = ammoBoxAnimators[index];
            Integer boxAmmoCount = boxAnimator.newValue();
            boolean boxAmmoSelected = false;
            if (isAmmoBox) {
                AmmoBoxInfo data = (AmmoBoxInfo)stack.get(ModDataComponents.AMMO_BOX_INFO);
                String ammoBoxType = data == null ? "All" : data.type();
                boxAmmoCount = type.get(stack);
                if (ammoBoxType.equals("All") || ammoBoxType.equals(type.serializationName)) {
                    boxAnimator.forward(currentTime);
                    boxAmmoSelected = true;
                } else {
                    boxAnimator.reset(boxAmmoCount);
                }
            }
            if (startRenderingAmmoInfo) {
                animator.reset(ammoCount);
                animator.endForward(currentTime);
                if (isAmmoBox) {
                    boxAnimator.reset(type.get(stack));
                    boxAnimator.endForward(currentTime);
                }
            }
            int ammoAdd = Integer.compare(ammoCount, animator.oldValue());
            animator.compareAndUpdate(ammoCount, () -> animator.beginForward(currentTime));
            float progress = animator.getProgress(currentTime);
            String ammoCountStr = Integer.toString(Math.round(animator.lerp(animator.oldValue().intValue(), ammoCount, currentTime)));
            int fontColor = FastColor.ARGB32.lerp((float)progress, (int)(switch (ammoAdd) {
                case 1 -> -16711936;
                case -1 -> -65536;
                default -> -1;
            }), (int)-1);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)ammoInfoTimer.lerp(0.0f, 1.0f, currentTime));
            guiGraphics.drawString(font, ammoCountStr, ammoX + (float)(30 - font.width(ammoCountStr)), (float)h + yOffset, fontColor, true);
            guiGraphics.drawString(font, Component.translatable((String)type.translationKey).getString(), ammoX + 35.0f, (float)h + yOffset, fontColor, true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)ammoBoxTimer.lerp(0.0f, 1.0f, currentTime));
            float ammoBoxX = ammoBoxTimer.lerp(-30.0f, (float)w / 2.0f, currentTime);
            int ammoBoxAdd = Integer.compare(boxAmmoCount, boxAnimator.oldValue());
            boxAnimator.compareAndUpdate(boxAmmoCount, () -> boxAnimator.beginForward(currentTime));
            int targetColor = boxAmmoSelected ? -256 : -1;
            float f = boxAnimator.getProgress(currentTime);
            int boxFontColor = FastColor.ARGB32.lerp((float)f, (int)(switch (ammoBoxAdd) {
                case 1 -> -16711936;
                case -1 -> -65536;
                default -> targetColor;
            }), (int)targetColor);
            guiGraphics.drawString(Minecraft.getInstance().font, Integer.toString(Math.round(boxAnimator.lerp(boxAnimator.oldValue().intValue(), boxAmmoCount.intValue(), currentTime))), ammoBoxX - 70.0f, (float)h + yOffset, boxFontColor, true);
            yOffset += 15.0f;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }
}

