/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.IFFOverlay;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DroneHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("drone_hud");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/frame/frame.png");
    private static final ResourceLocation TV_FRAME = Mod.loc("textures/overlay/vehicle/land/tv_frame.png");
    private static final ResourceLocation CROSSHAIR = Mod.loc("textures/overlay/vehicle/crosshair/third_camera.png");
    private static final ResourceLocation DRONE_FOV = Mod.loc("textures/overlay/drone/drone_fov.png");
    private static final ResourceLocation DRONE_FOV_MOVE = Mod.loc("textures/overlay/drone/drone_fov_move.png");
    private static final ResourceLocation INDICATOR = Mod.loc("textures/overlay/spyglass/indicator.png");

    public static int getMaxDistance() {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        return (connection == null ? 16 : connection.serverSimulationDistance) * 16;
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        boolean firstPerson;
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui) {
            return;
        }
        LocalPlayer player = mc.player;
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        if (player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ItemStack stack = player.getMainHandItem();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CompoundTag tag = NBTTool.getTag(stack);
        boolean bl = firstPerson = Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK;
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            if (firstPerson) {
                ItemStack offStack;
                guiGraphics.blit(CROSSHAIR, screenWidth / 2 - 16, screenHeight / 2 - 16, 0.0f, 0.0f, 32, 32, 32, 32);
                guiGraphics.blit(DRONE_FOV, screenWidth / 2 + 100, screenHeight / 2 - 64, 0.0f, 0.0f, 64, 129, 64, 129);
                int addW = screenWidth / screenHeight * 48;
                int addH = screenWidth / screenHeight * 27;
                RenderHelper.preciseBlit(guiGraphics, TV_FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, screenWidth + addW, screenHeight + addH, screenWidth + addW, screenHeight + addH);
                RenderHelper.preciseBlit(guiGraphics, DRONE_FOV_MOVE, (float)screenWidth / 2.0f + 100.0f, (float)((double)((float)screenHeight / 2.0f - 64.0f) - (ClientEventHandler.droneFovLerp - 1.0) * 23.8), 0.0f, 0.0f, 64.0f, 129.0f, 64.0f, 129.0f);
                guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format1D(ClientEventHandler.droneFovLerp, "x")), screenWidth / 2 + 144, screenHeight / 2 + 56 - (int)((ClientEventHandler.droneFovLerp - 1.0) * 23.8), -1, false);
                DroneEntity entity = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
                if (entity != null) {
                    boolean lookAtEntity = false;
                    double distance = player.position().subtract(entity.position()).horizontalDistance();
                    BlockHitResult result = entity.level().clip(new ClipContext(cameraPos, cameraPos.add(entity.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                    Vec3 hitPos = result.getLocation();
                    double blockRange = cameraPos.distanceTo(hitPos);
                    double entityRange = 0.0;
                    Entity lookingEntity = TraceTool.droneFindLookingEntity(entity, cameraPos, 512.0, partialTick);
                    if (lookingEntity != null) {
                        lookAtEntity = true;
                        entityRange = entity.distanceTo(lookingEntity);
                    }
                    int color = -1;
                    if (distance > (double)(DroneHudOverlay.getMaxDistance() - 48)) {
                        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.warning"), screenWidth / 2 - 18, screenHeight / 2 - 47, -65536, false);
                        color = -65536;
                    }
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.distance").append((Component)Component.literal((String)FormatTool.format1D(distance, "m"))), screenWidth / 2 + 10, screenHeight / 2 + 33, color, false);
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.health").append((Component)Component.literal((String)(FormatTool.format1D(entity.getHealth()) + " / " + FormatTool.format1D(entity.getMaxHealth())))), screenWidth / 2 - 77, screenHeight / 2 + 33, -1, false);
                    if (!((Boolean)entity.getEntityData().get(DroneEntity.IS_KAMIKAZE)).booleanValue()) {
                        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.ammo").append((Component)Component.literal((String)(String.valueOf(entity.getEntityData().get(DroneEntity.AMMO)) + " / " + String.valueOf(entity.getEntityData().get(DroneEntity.MAX_AMMO))))), screenWidth / 2 + 12, screenHeight / 2 - 37, -1, false);
                    } else {
                        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.kamikaze"), screenWidth / 2 + 12, screenHeight / 2 - 37, -65536, false);
                    }
                    if (lookAtEntity) {
                        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)(FormatTool.format1D(entityRange, "m ") + lookingEntity.getDisplayName().getString()))), screenWidth / 2 + 12, screenHeight / 2 - 28, color, false);
                    } else if (blockRange > 500.0) {
                        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)"---m")), screenWidth / 2 + 12, screenHeight / 2 - 28, color, false);
                    } else {
                        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)FormatTool.format1D(blockRange, "m"))), screenWidth / 2 + 12, screenHeight / 2 - 28, color, false);
                    }
                    List<Entity> entities = SeekTool.seekLivingEntities(entity, 256.0, 30.0);
                    for (Entity e : entities) {
                        Vec3 pos = new Vec3(Mth.lerp((double)partialTick, (double)e.xo, (double)e.getX()), Mth.lerp((double)partialTick, (double)(e.yo + (double)e.getEyeHeight()), (double)e.getEyeY()), Mth.lerp((double)partialTick, (double)e.zo, (double)e.getZ()));
                        Vec3 point = VectorUtil.worldToScreen(pos);
                        poseStack.pushPose();
                        float x = (float)point.x;
                        float y = (float)point.y;
                        RenderHelper.preciseBlit(guiGraphics, FRAME, x - 12.0f, y - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                        poseStack.popPose();
                    }
                }
                if ((offStack = player.getOffhandItem()).is((Item)ModItems.FIRING_PARAMETERS.get()) || offStack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                    FiringParameters.Parameters parameters = (FiringParameters.Parameters)offStack.get(ModDataComponents.FIRING_PARAMETERS);
                    BlockPos blockPos = parameters != null ? parameters.pos() : new BlockPos(0, 0, 0);
                    double targetX = blockPos.getX();
                    double targetY = blockPos.getY();
                    double targetZ = blockPos.getZ();
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableBlend();
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Vec3 pos = new Vec3(targetX, targetY, targetZ);
                    if (VectorUtil.canSee(pos)) {
                        Vec3 point = VectorUtil.worldToScreen(pos);
                        float x = (float)point.x;
                        float y = (float)point.y;
                        RenderHelper.preciseBlit(guiGraphics, INDICATOR, Mth.clamp((float)(x - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.clamp((float)(y - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                    }
                    if (offStack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                        ListTag tags = NBTTool.getTag(offStack).getList("Cannons", 10);
                        for (int m = 0; m < tags.size(); ++m) {
                            Entity e;
                            CompoundTag t = tags.getCompound(m);
                            e = EntityFindUtil.findEntity(player.level(), t.getString("UUID"));
                            if (e == null || !VectorUtil.canSee(e.position())) continue;
                            Vec3 posF = VectorTool.lerpGetEntityBoundingBoxCenter(e, partialTick);
                            Vec3 pointF = VectorUtil.worldToScreen(posF);
                            float xf = (float)pointF.x;
                            float yf = (float)pointF.y;
                            RenderHelper.preciseBlit(guiGraphics, IFFOverlay.FRIENDLY_ARTILLERY, Mth.clamp((float)(xf - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.clamp((float)(yf - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                        }
                    }
                }
            } else if (VectorUtil.canSee(player.position())) {
                LocalPlayer team = player;
                if (player.getVehicle() != null) {
                    team = player.getVehicle();
                }
                Vec3 pos = VectorTool.lerpGetEntityBoundingBoxCenter((Entity)team, partialTick);
                Vec3 point = VectorUtil.worldToScreen(pos);
                float xf = (float)point.x;
                float yf = (float)point.y;
                RenderHelper.preciseBlit(guiGraphics, IFFOverlay.FRIENDLY_INDICATOR, Mth.clamp((float)(xf - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.clamp((float)(yf - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
            }
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }
}

