/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.animation.AnimationCurves;
import com.atsuishio.superbwarfare.client.animation.AnimationTimer;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HeatBarOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("heat_bar");
    private static final ResourceLocation TEXTURE = Mod.loc("textures/overlay/heat_bar/heat_bar.png");
    private static final AnimationTimer ANIMATION_TIMER = new AnimationTimer(200L).animation(AnimationCurves.EASE_IN_QUART);

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        VehicleEntity vehicle;
        Entity entity;
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        if (!((Boolean)DisplayConfig.ENABLE_HEAT_BAR_HUD.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        double heat = ClientEventHandler.isEditing || !(player.getMainHandItem().getItem() instanceof GunItem) || (entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player) ? 0.0 : GunData.from((ItemStack)player.getMainHandItem()).heat.get();
        long currentTime = System.currentTimeMillis();
        if (heat <= 0.0) {
            ANIMATION_TIMER.forward(currentTime);
        } else {
            ANIMATION_TIMER.beginForward(currentTime);
        }
        if (ANIMATION_TIMER.finished(currentTime)) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int width = 16;
        int height = 64;
        int i = (screenWidth - width) / 2;
        int j = (screenHeight - height) / 2;
        float posX = (float)(i + 64 + (Integer)DisplayConfig.HEAT_BAR_HUD_X_OFFSET.get()) + ANIMATION_TIMER.lerp(0.0f, 5.0f, currentTime);
        float posY = j + 6 + (Integer)DisplayConfig.HEAT_BAR_HUD_Y_OFFSET.get();
        float alpha = ANIMATION_TIMER.lerp(1.0f, 0.0f, currentTime);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderHelper.preciseBlit(guiGraphics, TEXTURE, posX, posY, 0.0f, 0.0f, 9.25f, 58.25f, width, height);
        float rate = (float)Mth.clamp((double)(heat / 100.0), (double)0.0, (double)1.0);
        float barHeight = 56.0f * rate;
        poseStack.pushPose();
        int color = rate >= 0.795f ? HeatBarOverlay.calculateGradientColor(rate) : 0xFFFFFF;
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderHelper.preciseBlit(guiGraphics, TEXTURE, posX + 2.5f, posY + 1.5f + 56.0f - barHeight, 10.5f, 0.0f, 2.25f, barHeight, width, height);
        poseStack.popPose();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static int calculateGradientColor(float rate) {
        float clampedRate = Mth.clamp((float)rate, (float)0.795f, (float)1.0f);
        float normalized = (clampedRate - 0.795f) / 0.20499998f;
        int red = 255;
        int green = (int)(255.0f * (1.0f - normalized));
        int blue = (int)(255.0f * (1.0f - normalized));
        return red << 16 | green << 8 | blue;
    }
}

