/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JavelinHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("javelin_hud");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/frame/frame.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/overlay/frame/frame_target_triangle.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/overlay/frame/frame_lock.png");
    private static final ResourceLocation JAVELIN_HUD = Mod.loc("textures/overlay/javelin/javelin_hud.png");
    private static final ResourceLocation TOP = Mod.loc("textures/overlay/javelin/top.png");
    private static final ResourceLocation DIR = Mod.loc("textures/overlay/javelin/dir.png");
    private static final ResourceLocation MISSILE_GREEN = Mod.loc("textures/overlay/javelin/missile_green.png");
    private static final ResourceLocation MISSILE_RED = Mod.loc("textures/overlay/javelin/missile_red.png");
    private static final ResourceLocation SEEK = Mod.loc("textures/overlay/javelin/seek.png");
    private static float scopeScale = 1.0f;

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        VehicleEntity vehicle;
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        PoseStack poseStack = guiGraphics.pose();
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (ClientEventHandler.isEditing) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player)) {
            return;
        }
        if (stack.getItem() == ModItems.JAVELIN.get() && ClientEventHandler.zoomPos > 0.8 && Minecraft.getInstance().options.getCameraType().isFirstPerson() && ClientEventHandler.zoom) {
            GunData data = GunData.from(stack);
            CompoundTag tag = data.tag();
            poseStack.pushPose();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float deltaFrame = deltaTracker.getGameTimeDeltaPartialTick(true);
            float moveX = (float)(-32.0 * ClientEventHandler.turnRot[1] - (double)(player.isSprinting() ? 100 : 67) * ClientEventHandler.movePosX + 3.0 * ClientEventHandler.cameraRot[2]);
            float moveY = (float)(-32.0 * ClientEventHandler.turnRot[0] + (double)(100.0f * (float)ClientEventHandler.velocityY) - (double)(player.isSprinting() ? 100 : 67) * ClientEventHandler.movePosY - 12.0 * ClientEventHandler.firePos + 3.0 * ClientEventHandler.cameraRot[1]);
            scopeScale = (float)Mth.lerp((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
            float f = Math.min(w, h);
            float f1 = Math.min((float)w / f, (float)h / f) * scopeScale;
            float i = Mth.floor((float)(f * f1));
            float j = Mth.floor((float)(f * f1));
            float k = ((float)w - i) / 2.0f + moveX;
            float l = ((float)h - j) / 2.0f + moveY;
            float i1 = k + i;
            float j1 = l + j;
            RenderHelper.preciseBlit(guiGraphics, JAVELIN_HUD, k, l, 0.0f, 0.0f, i, j, i, j);
            RenderHelper.preciseBlit(guiGraphics, data.selectedFireModeInfo().name.equals("Top") ? TOP : DIR, k, l, 0.0f, 0.0f, i, j, i, j);
            RenderHelper.preciseBlit(guiGraphics, data.hasEnoughAmmoToShoot((Entity)player) ? MISSILE_GREEN : MISSILE_RED, k, l, 0.0f, 0.0f, i, j, i, j);
            if (tag.getInt("SeekTime") > 1 && tag.getInt("SeekTime") < 20) {
                RenderHelper.preciseBlit(guiGraphics, SEEK, k, l, 0.0f, 0.0f, i, j, i, j);
            }
            guiGraphics.fill(RenderType.guiOverlay(), 0, (int)l, (int)k + 3, (int)j1, -90, -16777216);
            guiGraphics.fill(RenderType.guiOverlay(), (int)i1, (int)l, w, (int)j1, -90, -16777216);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.getInstance();
            Camera camera = mc.gameRenderer.getMainCamera();
            Vec3 cameraPos = camera.getPosition();
            Entity decoy = TraceTool.findLookDecoy((Player)player, cameraPos, player.getViewVector(deltaTracker.getGameTimeDeltaPartialTick(true)), 512.0);
            if (decoy == null) {
                Entity targetEntity = ClientEventHandler.lockingEntity;
                List<Entity> entities = new SeekTool.Builder((Entity)player).withinRange(data.compute().seekRange).withinAngle(data.compute().seekAngle).baseFilter().heightRange(data.compute().minTargetHeight, data.compute().maxTargetHeight).smokeFilter().noVehicle().noClip().notFriendly().build();
                Entity nearestEntity = ClientEventHandler.nearestEntity;
                if (ClientEventHandler.guideType == 0) {
                    for (Entity e : entities) {
                        Vec3 pos = VectorTool.lerpGetEntityBoundingBoxCenter(e, deltaTracker.getGameTimeDeltaPartialTick(true));
                        Vec3 point = VectorUtil.worldToScreen(pos);
                        boolean lockOn = ClientEventHandler.lockOn && e == targetEntity;
                        boolean nearest = e == nearestEntity;
                        poseStack.pushPose();
                        float x = (float)point.x;
                        float y = (float)point.y;
                        RenderHelper.preciseBlitWithColor(guiGraphics, lockOn ? FRAME_LOCK : (nearest ? FRAME_TARGET : FRAME), x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                        poseStack.popPose();
                    }
                } else {
                    Vec3 pos = ClientEventHandler.lockingPos;
                    boolean lockOn = ClientEventHandler.lockOn;
                    if (pos != null) {
                        Vec3 point = VectorUtil.worldToScreen(pos);
                        if (VectorUtil.canSee(pos)) {
                            poseStack.pushPose();
                            float x = (float)point.x;
                            float y = (float)point.y;
                            RenderHelper.preciseBlitWithColor(guiGraphics, lockOn ? FRAME_LOCK : FRAME_TARGET, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                            poseStack.popPose();
                        }
                    }
                }
            }
            poseStack.popPose();
        } else {
            scopeScale = 1.0f;
        }
    }
}

