/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MortarInfoOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("mortar_info");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        Entity lookingEntity = null;
        if (player != null) {
            lookingEntity = TraceTool.findLookingEntity((Entity)player, 6.0);
        }
        if (lookingEntity instanceof MortarEntity) {
            MortarEntity mortar = (MortarEntity)lookingEntity;
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.pitch").append((Component)Component.literal((String)FormatTool.format1D(-mortar.getXRot(), "\u00b0"))), w / 2 - 90, h / 2 - 26, -1, false);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.yaw").append((Component)Component.literal((String)FormatTool.format1D(mortar.getYRot(), "\u00b0"))), w / 2 - 90, h / 2 - 16, -1, false);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.range").append((Component)Component.literal((String)FormatTool.format1D((int)RangeTool.getRange(-mortar.getXRot(), mortar.getProjectileVelocity("Main"), mortar.getProjectileGravity("Main")), "m"))), w / 2 - 90, h / 2 - 6, -1, false);
        }
    }
}

