/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.TowEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TowOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("tow");
    private static final ResourceLocation SPYGLASS = Mod.loc("textures/overlay/spyglass/spyglass.png");
    private static float scopeScale = 1.0f;

    public void render(GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        PoseStack poseStack = guiGraphics.pose();
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        if (player == null) {
            return;
        }
        if (player.getVehicle() instanceof TowEntity && (ClientEventHandler.zoomVehicle || mc.options.getCameraType() == CameraType.FIRST_PERSON)) {
            poseStack.pushPose();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float deltaFrame = deltaTracker.getGameTimeDeltaPartialTick(true);
            scopeScale = (float)Mth.lerp((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
            float f = Math.min(screenWidth, screenHeight);
            float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * scopeScale;
            float i = Mth.floor((float)(f * f1));
            float j = Mth.floor((float)(f * f1));
            float k = ((float)screenWidth - i) / 2.0f;
            float l = ((float)screenHeight - j) / 2.0f;
            float w = i * 21.0f / 9.0f;
            RenderHelper.preciseBlit(guiGraphics, SPYGLASS, k - 2.0f * w / 7.0f, l, 0.0f, 0.0f, w, j, w, j);
            poseStack.popPose();
        } else {
            scopeScale = 1.0f;
        }
    }
}

