/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.animation.AnimationCurves;
import com.atsuishio.superbwarfare.client.animation.AnimationTimer;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineType;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class VehicleHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("vehicle_hud");
    public static final int ANIMATION_TIME = 300;
    private static final ResourceLocation ARMOR = Mod.loc("textures/overlay/vehicle/base/armor.png");
    private static final ResourceLocation ENERGY = Mod.loc("textures/overlay/vehicle/base/energy.png");
    private static final ResourceLocation VALUE_BAR = Mod.loc("textures/overlay/vehicle/base/value_bar.png");
    private static final ResourceLocation VALUE_FRAME = Mod.loc("textures/overlay/vehicle/base/value_frame.png");
    private static final ResourceLocation DRIVER = Mod.loc("textures/overlay/vehicle/base/driver.png");
    private static final ResourceLocation PASSENGER = Mod.loc("textures/overlay/vehicle/base/passenger.png");
    private static final ResourceLocation SELECTED = Mod.loc("textures/overlay/vehicle/weapon/frame/selected.png");
    private static final ResourceLocation SWITCH_AMMO = Mod.loc("textures/overlay/vehicle/weapon/frame/switch_ammo.png");
    private static final ResourceLocation NUMBER = Mod.loc("textures/overlay/vehicle/weapon/frame/number.png");
    private static final ResourceLocation[] FRAMES = new ResourceLocation[]{Mod.loc("textures/overlay/vehicle/weapon/frame/frame_1.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_2.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_3.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_4.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_5.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_6.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_7.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_8.png"), Mod.loc("textures/overlay/vehicle/weapon/frame/frame_9.png")};
    private static final ResourceLocation GEAR = Mod.loc("textures/overlay/vehicle/aircraft/gear.png");
    private static final ResourceLocation HIT_MARKER = Mod.loc("textures/overlay/crosshair/hit_marker.png");
    private static final ResourceLocation HIT_MARKER_VEHICLE = Mod.loc("textures/overlay/crosshair/hit_marker_vehicle.png");
    private static final ResourceLocation HEADSHOT_MARKER = Mod.loc("textures/overlay/crosshair/headshot_marker.png");
    private static final ResourceLocation KILL_MARKER_1 = Mod.loc("textures/overlay/crosshair/kill_marker_1.png");
    private static final ResourceLocation KILL_MARKER_2 = Mod.loc("textures/overlay/crosshair/kill_marker_2.png");
    private static final ResourceLocation KILL_MARKER_3 = Mod.loc("textures/overlay/crosshair/kill_marker_3.png");
    private static final ResourceLocation KILL_MARKER_4 = Mod.loc("textures/overlay/crosshair/kill_marker_4.png");
    private static final AnimationTimer[] WEAPON_SLOTS_TIMER = AnimationTimer.createTimers(9, 300L, AnimationCurves.EASE_OUT_CIRC);
    private static final AnimationTimer WEAPON_INDEX_UPDATE_TIMER = new AnimationTimer(300L).animation(AnimationCurves.EASE_OUT_CIRC);
    private static boolean wasRenderingWeapons = false;
    private static int oldWeaponIndex = 0;
    private static int oldRenderWeaponIndex = 0;

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        if (!VehicleHudOverlay.shouldRenderHud((Player)player)) {
            wasRenderingWeapons = false;
            return;
        }
        Entity entity = player.getVehicle();
        if (!(entity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int compatHeight = VehicleHudOverlay.getArmorPlateCompatHeight((Player)player);
        if (vehicle.hasEnergyStorage()) {
            float energy = vehicle.getEnergy();
            float maxEnergy = vehicle.getMaxEnergy();
            RenderHelper.preciseBlit(guiGraphics, ENERGY, 10.0f, screenHeight - 22 - compatHeight, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            RenderHelper.preciseBlit(guiGraphics, VALUE_FRAME, 20.0f, screenHeight - 21 - compatHeight, 100.0f, 0.0f, 0.0f, 60.0f, 6.0f, 60.0f, 6.0f);
            RenderHelper.preciseBlit(guiGraphics, VALUE_BAR, 20.0f, screenHeight - 21 - compatHeight, 100.0f, 0.0f, 0.0f, (int)(60.0f * energy / maxEnergy), 6.0f, 60.0f, 6.0f);
        }
        float health = vehicle.getHealth();
        float maxHealth = vehicle.getMaxHealth();
        RenderHelper.preciseBlit(guiGraphics, ARMOR, 10.0f, screenHeight - 13 - compatHeight, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        RenderHelper.preciseBlit(guiGraphics, VALUE_FRAME, 20.0f, screenHeight - 12 - compatHeight, 100.0f, 0.0f, 0.0f, 60.0f, 6.0f, 60.0f, 6.0f);
        RenderHelper.preciseBlit(guiGraphics, VALUE_BAR, 20.0f, screenHeight - 12 - compatHeight, 100.0f, 0.0f, 0.0f, (int)(60.0f * health / maxHealth), 6.0f, 60.0f, 6.0f);
        VehicleHudOverlay.renderWeaponInfo(guiGraphics, vehicle, screenWidth, screenHeight);
        VehicleHudOverlay.renderPassengerInfo(guiGraphics, vehicle, screenWidth, screenHeight);
        VehicleHudOverlay.renderGearInfo(guiGraphics, vehicle, screenWidth, screenHeight, partialTick);
        poseStack.popPose();
    }

    private static boolean shouldRenderHud(Player player) {
        if (player == null) {
            return false;
        }
        return !player.isSpectator() && player.getVehicle() instanceof VehicleEntity;
    }

    private static int getArmorPlateCompatHeight(Player player) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (stack == ItemStack.EMPTY) {
            return 0;
        }
        if (!NBTTool.getTag(stack).contains("ArmorPlate")) {
            return 0;
        }
        if (!((Boolean)DisplayConfig.ARMOR_PLATE_HUD.get()).booleanValue()) {
            return 0;
        }
        return 9;
    }

    public static void renderKillIndicator(GuiGraphics guiGraphics, float screenWidth, float screenHeight) {
        float posX = screenWidth / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float posY = screenHeight / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float rate = (float)(40 - CrossHairOverlay.killIndicator * 5) / 5.5f;
        if (CrossHairOverlay.hitIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HIT_MARKER, posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.vehicleIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HIT_MARKER_VEHICLE, posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.headIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HEADSHOT_MARKER, posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.killIndicator > 0) {
            float posX1 = screenWidth / 2.0f - 7.5f - 2.0f + rate;
            float posY1 = screenHeight / 2.0f - 7.5f - 2.0f + rate;
            float posX2 = screenWidth / 2.0f - 7.5f + 2.0f - rate;
            float posY2 = screenHeight / 2.0f - 7.5f + 2.0f - rate;
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_1, posX1, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_2, posX2, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_3, posX1, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_4, posX2, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
    }

    public static void renderKillIndicatorDynamic(GuiGraphics guiGraphics, float posX, float posY) {
        float rate = (float)(40 - CrossHairOverlay.killIndicator * 5) / 5.5f;
        if (CrossHairOverlay.hitIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HIT_MARKER, posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.vehicleIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HIT_MARKER_VEHICLE, posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.headIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HEADSHOT_MARKER, posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.killIndicator > 0) {
            float posX1 = posX - 2.0f + rate;
            float posY1 = posY - 2.0f + rate;
            float posX2 = posX + 2.0f - rate;
            float posY2 = posY + 2.0f - rate;
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_1, posX1, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_2, posX2, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_3, posX1, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_4, posX2, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
    }

    private static void renderPassengerInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, int screenWidth, int screenHeight) {
        List<Entity> passengers = vehicle.getOrderedPassengers();
        int index = 0;
        for (int i = passengers.size() - 1; i >= 0; --i) {
            Entity passenger = passengers.get(i);
            int y = screenHeight - 35 - index * 12;
            AtomicReference<String> name = new AtomicReference<String>("---");
            if (passenger != null) {
                name.set(passenger.getName().getString());
            }
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(c -> c.findFirstCurio((Item)ModItems.DOG_TAG.get())).ifPresent(s -> name.set(s.stack().getHoverName().getString()));
            }
            guiGraphics.drawString(Minecraft.getInstance().font, name.get(), 42, y, 0x66FF00, true);
            String num = "[" + (i + 1) + "]";
            guiGraphics.drawString(Minecraft.getInstance().font, num, 25 - Minecraft.getInstance().font.width(num), y, 0x66FF00, true);
            RenderHelper.preciseBlit(guiGraphics, index == passengers.size() - 1 ? DRIVER : PASSENGER, 30.0f, y, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            ++index;
        }
    }

    private static void renderGearInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, int w, int h, float partialTick) {
        block6: {
            block5: {
                EngineType engineType = vehicle.computed().engineType;
                if (engineType != EngineType.AIRCRAFT) {
                    return;
                }
                EngineInfo engineInfo = vehicle.getEngineInfo();
                if (engineInfo == null) {
                    return;
                }
                if (!(engineInfo instanceof EngineInfo.Aircraft)) break block5;
                EngineInfo.Aircraft aircraft = (EngineInfo.Aircraft)engineInfo;
                if (aircraft.hasGear) break block6;
            }
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.pushPose();
        float angle = vehicle.gearRot(partialTick);
        poseStack.rotateAround(Axis.ZP.rotationDegrees(-90.0f + angle), 102.0f, (float)(h - 20), 0.0f);
        RenderHelper.preciseBlit(guiGraphics, GEAR, 86.0f, h - 36, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
        poseStack.popPose();
    }

    private static void renderWeaponInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, int w, int h) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!vehicle.banHand((LivingEntity)player)) {
            return;
        }
        if (!vehicle.hasWeapon()) {
            return;
        }
        boolean temp = wasRenderingWeapons;
        wasRenderingWeapons = false;
        assert (player != null);
        int index = vehicle.getSeatIndex((Entity)player);
        if (index == -1) {
            return;
        }
        List<GunData> weapons = vehicle.computed().seats().get(index).weapons().stream().map(vehicle::getGunData).toList();
        if (weapons.isEmpty()) {
            return;
        }
        int weaponIndex = vehicle.getWeaponIndex(index);
        if (weaponIndex == -1) {
            return;
        }
        wasRenderingWeapons = temp;
        long currentTime = System.currentTimeMillis();
        if (!wasRenderingWeapons) {
            WEAPON_SLOTS_TIMER[weaponIndex].beginForward(currentTime);
            if (oldWeaponIndex != weaponIndex) {
                WEAPON_SLOTS_TIMER[oldWeaponIndex].endBackward(currentTime);
                oldWeaponIndex = weaponIndex;
                oldRenderWeaponIndex = weaponIndex;
            }
            WEAPON_INDEX_UPDATE_TIMER.beginForward(currentTime);
        }
        if (weaponIndex != oldWeaponIndex) {
            WEAPON_SLOTS_TIMER[weaponIndex].forward(currentTime);
            WEAPON_SLOTS_TIMER[oldWeaponIndex].backward(currentTime);
            oldRenderWeaponIndex = oldWeaponIndex;
            oldWeaponIndex = weaponIndex;
            WEAPON_INDEX_UPDATE_TIMER.beginForward(currentTime);
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        int frameIndex = 0;
        for (int i = weapons.size() - 1; i >= 0 && i < 9; --i) {
            boolean selected;
            GunData weapon = weapons.get(i);
            ResourceLocation frame = FRAMES[i];
            pose.pushPose();
            int maxXOffset = 37;
            AnimationTimer currentSlotTimer = WEAPON_SLOTS_TIMER[i];
            float progress = currentSlotTimer.getProgress(currentTime);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Mth.lerp((float)progress, (float)0.2f, (float)1.0f));
            float xOffset = Mth.lerp((float)progress, (float)maxXOffset, (float)0.0f);
            RenderHelper.preciseBlit(guiGraphics, frame, (float)(w - 85) + xOffset, h - frameIndex * 18 - 20, 100.0f, 0.0f, 0.0f, 75.0f, 16.0f, 75.0f, 16.0f);
            GunData data = vehicle.getGunData(vehicle.getSeatIndex((Entity)player), i);
            if (data == null) {
                pose.popPose();
                continue;
            }
            boolean bl = selected = i == weaponIndex;
            if (selected) {
                float startY = Mth.lerp((float)progress, (float)(h - (weapons.size() - 1 - oldRenderWeaponIndex) * 18 - 16), (float)(h - (weapons.size() - 1 - weaponIndex) * 18 - 16));
                RenderHelper.preciseBlit(guiGraphics, SELECTED, w - 95, startY, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                int ammoCount = vehicle.getAmmoCount((LivingEntity)player);
                if (ammoCount == Integer.MAX_VALUE) {
                    RenderHelper.preciseBlit(guiGraphics, NUMBER, (float)(w - 28) + xOffset, h - frameIndex * 18 - 15, 100.0f, 58.0f, 0.0f, 10.0f, 7.5f, 75.0f, 7.5f);
                } else {
                    boolean percent;
                    boolean bl2 = percent = data.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.ENERGY;
                    if (percent) {
                        ammoCount /= (int)Math.max((double)1.0, (double)((double)vehicle.getMaxEnergy() / 100.0));
                    }
                    VehicleHudOverlay.renderNumber(guiGraphics, ammoCount, percent, (float)(w - 20) + xOffset, (float)(h - frameIndex * 18) - 15.5f, 0.25f);
                }
            }
            RenderHelper.preciseBlit(guiGraphics, weapon.compute().icon, (float)(w - 85) + xOffset, h - frameIndex * 18 - 20, 100.0f, 0.0f, 0.0f, 75.0f, 16.0f, 75.0f, 16.0f);
            int size = data.getDefault().getAmmoConsumers().size();
            if (selected && size > 1) {
                RenderHelper.preciseBlit(guiGraphics, SWITCH_AMMO, (float)(w - 13) + xOffset, h - frameIndex * 18 - 20, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                String string = "[" + ModKeyMappings.FIRE_MODE.getKey().getDisplayName().getString() + "]";
                int width = Minecraft.getInstance().font.width(string);
                pose.pushPose();
                pose.scale(0.6f, 0.6f, 1.0f);
                float xPos = (float)w - 6.0f + xOffset;
                if ((float)width >= 11.666666f) {
                    RenderHelper.renderScrollingString(guiGraphics, Minecraft.getInstance().font, (Component)Component.literal((String)string), 0.6f, (int)((xPos - 3.0f) / 0.6f), (int)(((float)(h - frameIndex * 18) - 14.0f) / 0.6f), (int)((xPos + 5.0f) / 0.6f), (int)(((float)(h - frameIndex * 18) - 4.0f) / 0.6f), 0xFFFFFF);
                } else {
                    guiGraphics.drawString(Minecraft.getInstance().font, string, (xPos + 3.0f - (float)width / 2.0f) / 0.6f, ((float)(h - frameIndex * 18) - 14.0f) / 0.6f, 0xFFFFFF, false);
                }
                pose.popPose();
            }
            DefaultGunData computed = data.compute();
            if (data.reloading()) {
                int totalReloadTime = data.reload.empty() ? computed.emptyReloadTime : computed.normalReloadTime;
                int currentReloadTime = data.reload.reloadTimer.get();
                float reloadProgress = (float)(totalReloadTime - currentReloadTime) / (float)totalReloadTime;
                float alpha = Mth.lerp((float)progress, (float)0.4f, (float)1.0f);
                if (currentReloadTime > 0 && currentReloadTime < totalReloadTime) {
                    RenderHelper.renderCircularRing(guiGraphics, (float)(w - 102) + xOffset, h - frameIndex * 18 - 12, 0.014f, 0.01f, new float[]{0.0f, 0.0f, 0.0f, 0.4f * alpha}, new float[]{1.0f, 1.0f, 1.0f, alpha}, reloadProgress, true);
                }
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            pose.popPose();
            ++frameIndex;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.popPose();
        if (oldWeaponIndex != oldRenderWeaponIndex && WEAPON_INDEX_UPDATE_TIMER.finished(currentTime)) {
            oldRenderWeaponIndex = oldWeaponIndex;
        }
        wasRenderingWeapons = true;
    }

    private static void renderNumber(GuiGraphics guiGraphics, int number, boolean percent, float x, float y, float scale) {
        float pX = x;
        if (percent) {
            RenderHelper.preciseBlit(guiGraphics, NUMBER, (pX -= 32.0f * scale) + 20.0f * scale, y, 100.0f, 200.0f * scale, 0.0f, 32.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
        }
        int index = 0;
        if (number == 0) {
            RenderHelper.preciseBlit(guiGraphics, NUMBER, pX, y, 100.0f, 0.0f, 0.0f, 20.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
        }
        while (number > 0) {
            int digit = number % 10;
            RenderHelper.preciseBlit(guiGraphics, NUMBER, pX - (float)(index * 20) * scale, y, 100.0f, (float)(digit * 20) * scale, 0.0f, 20.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
            number /= 10;
            ++index;
        }
    }
}

