/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.weapon.AircraftHud;
import com.atsuishio.superbwarfare.client.overlay.weapon.ArtilleryHud;
import com.atsuishio.superbwarfare.client.overlay.weapon.HelicopterHud;
import com.atsuishio.superbwarfare.client.overlay.weapon.LandVehicleHud;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.SeekWeaponInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class VehicleMainWeaponHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("vehicle_main_weapon_hud");
    public static final String EMPTY = "@Empty";
    private static float lerpLock = 1.0f;
    public static boolean lock = false;
    private static final ResourceLocation FRAME_GREEN = Mod.loc("textures/overlay/frame/frame_green.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/overlay/frame/frame_target.png");
    private static final ResourceLocation FRAME_TARGET_TRIANGLE = Mod.loc("textures/overlay/frame/frame_target_triangle.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/overlay/frame/frame_lock.png");
    private static final ResourceLocation IND_1 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind1.png");
    private static final ResourceLocation IND_2 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind2.png");
    private static final ResourceLocation IND_3 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind3.png");
    private static final ResourceLocation IND_4 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind4.png");
    private static final ResourceLocation SHOOT_INDICATOR = Mod.loc("textures/overlay/frame/frame_diamond.png");
    private static final ResourceLocation BLOCK = Mod.loc("textures/overlay/misc/block.png");

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Entity entity = player.getVehicle();
        if (!(entity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        if (ClientEventHandler.isEditing) {
            return;
        }
        String type = vehicle.computed().hudType;
        if (type.equals(EMPTY)) {
            return;
        }
        GunData gunData = vehicle.getGunData((Entity)player);
        if (gunData == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        switch (type) {
            case "@Land": {
                LandVehicleHud.render(vehicle, player, guiGraphics, partialTick, screenWidth, screenHeight);
                break;
            }
            case "@Helicopter": {
                HelicopterHud.render(vehicle, player, guiGraphics, partialTick, screenWidth, screenHeight);
                break;
            }
            case "@Artillery": {
                ArtilleryHud.render(vehicle, (Player)player, guiGraphics, partialTick, screenWidth, screenHeight);
                break;
            }
            case "@Aircraft": {
                AircraftHud.render(vehicle, (Player)player, guiGraphics, partialTick, screenWidth, screenHeight);
            }
        }
        SeekWeaponInfo seekInfo = gunData.compute().seekWeaponInfo;
        if (seekInfo == null) {
            poseStack.popPose();
            return;
        }
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        int seekTime = seekInfo.seekTime;
        if (seekInfo.onlyLockEntity) {
            Entity targetEntity = ClientEventHandler.lockingEntityVehicle;
            Entity nearestEntity = ClientEventHandler.nearestEntityVehicle;
            Vec3 seekVec = vehicle.getSeekVec((Entity)player, partialTick);
            List<Entity> entities = new SeekTool.Builder(vehicle).withinRange(seekInfo.seekRange).withinAngle(cameraPos, seekVec, seekInfo.seekAngle).baseFilter().heightRange(seekInfo.minTargetHeight, seekInfo.maxTargetHeight).sizeBiggerThan(seekInfo.minTargetSize).smokeFilter().noVehicle().noClip().notFriendly().build();
            Entity decoy = TraceTool.findLookDecoy((Player)player, cameraPos, seekVec, seekInfo.seekRange);
            if (decoy != null && decoy.getType().is(ModTags.EntityTypes.DECOY)) {
                return;
            }
            for (Entity e : entities) {
                Vec3 pos3;
                if (e.getType().is(ModTags.EntityTypes.DECOY) || !VectorUtil.canSee(pos3 = VectorTool.lerpGetEntityBoundingBoxCenter(e, partialTick)) || seekInfo.onlyLockBlock) continue;
                Vec3 point = VectorUtil.worldToScreen(pos3);
                boolean lockOn = ClientEventHandler.lockOnVehicle && targetEntity != null && e == targetEntity;
                boolean nearest = e == (ClientEventHandler.seekingEntityVehicle == null ? nearestEntity : ClientEventHandler.seekingEntityVehicle);
                poseStack.pushPose();
                float x = (float)point.x;
                float y = (float)point.y;
                if (lockOn) {
                    lock = true;
                    RenderHelper.preciseBlitWithColor(guiGraphics, FRAME_LOCK, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                    nearestEntity = targetEntity;
                    if (seekInfo.calculateTrajectory) {
                        Vec3 shootVector = RangeTool.calculateFiringSolution(vehicle.getShootPos((Entity)player, partialTick), VectorTool.lerpGetEntityBoundingBoxCenter(targetEntity, partialTick), targetEntity.getDeltaMovement().scale(1.25), vehicle.getProjectileVelocity((Entity)player), vehicle.getProjectileGravity((Entity)player)).normalize();
                        Vec3 shootPos = vehicle.getShootPos((Entity)player, partialTick).add(shootVector.scale(vehicle.getShootPos((Entity)player, partialTick).distanceTo(VectorTool.lerpGetEntityBoundingBoxCenter(targetEntity, partialTick))));
                        Vec3 point0 = VectorUtil.worldToScreen(shootPos);
                        if (VectorUtil.canSee(shootPos)) {
                            poseStack.pushPose();
                            float x0 = (float)point0.x;
                            float y0 = (float)point0.y;
                            Vec3 targetHudPos = new Vec3((double)x, (double)y, 0.0);
                            Vec3 shootHudPos = new Vec3((double)x0, (double)y0, 0.0);
                            RenderHelper.preciseBlitWithColor(guiGraphics, SHOOT_INDICATOR, x0 - 12.0f, y0 - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                            poseStack.popPose();
                            double dis = targetHudPos.distanceTo(shootHudPos);
                            for (double i = 3.0; i < dis - 3.0; i += 3.0) {
                                Vec3 toVec = targetHudPos.vectorTo(shootHudPos).normalize();
                                Vec3 p0 = targetHudPos.add(toVec.scale(i));
                                RenderHelper.preciseBlitWithColor(guiGraphics, BLOCK, (float)(p0.x - 0.5), (float)(p0.y - 0.5), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1);
                            }
                        }
                    }
                } else if (nearest && !lock) {
                    lerpLock = Mth.lerp((float)partialTick, (float)lerpLock, (float)ClientEventHandler.seekingTimeVehicle);
                    float lockTime = Mth.clamp((float)(((float)seekTime - lerpLock) * (20.0f / (float)seekTime)), (float)0.0f, (float)20.0f);
                    if (ClientEventHandler.seekingTimeVehicle > 0) {
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_1, x - 12.0f, y - 12.0f - lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_2, x - 12.0f, y - 12.0f + lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_3, x - 12.0f - lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_4, x - 12.0f + lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                    }
                    if (ClientEventHandler.seekingTimeVehicle == 0) {
                        poseStack.pushPose();
                        poseStack.translate(x, y, 0.0f);
                        String string = "[" + ModKeyMappings.VEHICLE_SEEK.getKey().getDisplayName().getString() + "]";
                        int width = Minecraft.getInstance().font.width(string);
                        guiGraphics.drawString(mc.font, string, -width / 2, 10, 16760191, false);
                        poseStack.popPose();
                    }
                    RenderHelper.preciseBlitWithColor(guiGraphics, ClientEventHandler.seekingTimeVehicle > 0 ? FRAME_TARGET : FRAME_TARGET_TRIANGLE, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                } else {
                    RenderHelper.preciseBlitWithColor(guiGraphics, FRAME_GREEN, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                }
                poseStack.popPose();
            }
        } else {
            Vec3 pos = ClientEventHandler.lockingPosVehicle;
            if (pos != null) {
                boolean lockOn = ClientEventHandler.lockOnVehicle;
                Vec3 point = VectorUtil.worldToScreen(pos);
                if (VectorUtil.canSee(pos)) {
                    poseStack.pushPose();
                    float x = (float)point.x;
                    float y = (float)point.y;
                    lerpLock = Mth.lerp((float)partialTick, (float)lerpLock, (float)ClientEventHandler.seekingTimeVehicle);
                    float lockTime = Mth.clamp((float)(((float)seekTime - lerpLock) * (20.0f / (float)seekTime)), (float)0.0f, (float)20.0f);
                    if (ClientEventHandler.seekingTimeVehicle > 0 && !lockOn) {
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_1, x - 12.0f, y - 12.0f - lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_2, x - 12.0f, y - 12.0f + lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_3, x - 12.0f - lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                        RenderHelper.preciseBlitWithColor(guiGraphics, IND_4, x - 12.0f + lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                    }
                    if (ClientEventHandler.seekingTimeVehicle == 0) {
                        poseStack.pushPose();
                        poseStack.translate(x, y, 0.0f);
                        String string = "[" + ModKeyMappings.VEHICLE_SEEK.getKey().getDisplayName().getString() + "]";
                        int width = Minecraft.getInstance().font.width(string);
                        guiGraphics.drawString(mc.font, string, -width / 2, 10, 16760191, false);
                        poseStack.popPose();
                    }
                    RenderHelper.preciseBlitWithColor(guiGraphics, lockOn ? FRAME_LOCK : FRAME_TARGET, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1);
                    poseStack.popPose();
                }
            }
        }
        poseStack.popPose();
    }

    public static void renderEnergyInfo(VehicleEntity vehicle, GuiGraphics guiGraphics, int screenWidth, int screenHeight, Font font) {
        if (!vehicle.hasEnergyStorage()) {
            return;
        }
        if ((double)vehicle.getEnergy() < 0.02 * (double)vehicle.getMaxEnergy()) {
            guiGraphics.drawString(font, (Component)Component.literal((String)"NO POWER!"), screenWidth / 2 - 144, screenHeight / 2 + 14, -65536, false);
        } else if ((double)vehicle.getEnergy() < 0.2 * (double)vehicle.getMaxEnergy()) {
            guiGraphics.drawString(font, (Component)Component.literal((String)"LOW POWER"), screenWidth / 2 - 144, screenHeight / 2 + 14, 16739072, false);
        }
    }

    public static void renderWeaponInfoFirst(GuiGraphics guiGraphics, VehicleEntity vehicle, Player player, GunData data, Font font, int screenWidth, int screenHeight, int color) {
        int heat = vehicle.getWeaponHeat((LivingEntity)player);
        Component component = vehicle.firstPersonAmmoComponent(data, player);
        guiGraphics.drawString(font, component, (screenWidth - font.width((FormattedText)component)) / 2, screenHeight - 65, MathTool.getGradientColor(color, 0xFF0000, heat, 2), false);
    }

    public static void renderWeaponInfoThird(GuiGraphics guiGraphics, VehicleEntity vehicle, Player player, GunData data, Font font) {
        if (!vehicle.hasWeapon()) {
            return;
        }
        float heat = (float)vehicle.getWeaponHeat((LivingEntity)player) / 100.0f;
        Component component = vehicle.thirdPersonAmmoComponent(data, player);
        guiGraphics.drawString(font, component, 30, -9, Mth.hsvToRgb((float)0.0f, (float)heat, (float)1.0f), false);
    }

    public static Vec3 getAroundPos(Vec3 direction, Vec3 center, double radius) {
        direction = direction.normalize();
        Vec3 randomPerp = VehicleMainWeaponHudOverlay.getRandomPerpendicular(direction);
        Vec3 u = randomPerp.normalize();
        Vec3 v = direction.cross(u).normalize();
        double theta = Math.PI * 2;
        double xOffset = radius * (Math.cos(theta) * u.x + Math.sin(theta) * v.x);
        double yOffset = radius * (Math.cos(theta) * u.y + Math.sin(theta) * v.y);
        double zOffset = radius * (Math.cos(theta) * u.z + Math.sin(theta) * v.z);
        return center.add(xOffset, yOffset, zOffset);
    }

    private static Vec3 getRandomPerpendicular(Vec3 dir) {
        Vec3 candidate1 = new Vec3(dir.y, -dir.x, 0.0);
        if (candidate1.lengthSqr() > 1.0E-4) {
            return candidate1;
        }
        return new Vec3(0.0, dir.z, -dir.y);
    }
}

