/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class BulletDecalOption
implements ParticleOptions {
    public static final MapCodec<BulletDecalOption> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("dir").forGetter(option -> option.direction.ordinal()), (App)Codec.LONG.fieldOf("pos").forGetter(option -> option.pos.asLong()), (App)Codec.FLOAT.fieldOf("r").forGetter(option -> Float.valueOf(option.red)), (App)Codec.FLOAT.fieldOf("g").forGetter(option -> Float.valueOf(option.green)), (App)Codec.FLOAT.fieldOf("b").forGetter(option -> Float.valueOf(option.blue))).apply((Applicative)builder, BulletDecalOption::new));
    public static final StreamCodec<ByteBuf, BulletDecalOption> STREAM_CODEC = StreamCodec.composite((StreamCodec)Direction.STREAM_CODEC, BulletDecalOption::getDirection, (StreamCodec)BlockPos.STREAM_CODEC, BulletDecalOption::getPos, (StreamCodec)ByteBufCodecs.FLOAT, BulletDecalOption::getRed, (StreamCodec)ByteBufCodecs.FLOAT, BulletDecalOption::getGreen, (StreamCodec)ByteBufCodecs.FLOAT, BulletDecalOption::getBlue, BulletDecalOption::new);
    private final Direction direction;
    private final BlockPos pos;
    private final float red;
    private final float green;
    private final float blue;

    public BulletDecalOption(int dir, long pos) {
        this(Direction.values()[dir], BlockPos.of((long)pos), 0.9f, 0.0f, 0.0f);
    }

    public BulletDecalOption(int dir, long pos, float r, float g, float b) {
        this(Direction.values()[dir], BlockPos.of((long)pos), r, g, b);
    }

    public BulletDecalOption(Direction dir, BlockPos pos) {
        this(dir, pos, 0.9f, 0.0f, 0.0f);
    }

    public BulletDecalOption(Direction dir, BlockPos pos, float r, float g, float b) {
        this.direction = dir;
        this.pos = pos;
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    @NotNull
    public ParticleType<?> getType() {
        return (ParticleType)ModParticleTypes.BULLET_DECAL.get();
    }
}

