/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.block;

import com.atsuishio.superbwarfare.block.ChargingStationBlock;
import com.atsuishio.superbwarfare.block.entity.ChargingStationBlockEntity;
import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ChargingStationBlockEntityRenderer
implements BlockEntityRenderer<ChargingStationBlockEntity> {
    public void render(ChargingStationBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)ChargingStationBlock.SHOW_RANGE)).booleanValue()) {
            return;
        }
        poseStack.pushPose();
        BlockPos pos = blockEntity.getBlockPos();
        poseStack.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
        AABB aabb = new AABB(pos).inflate((double)ChargingStationBlockEntity.CHARGE_RADIUS);
        float startX = (float)aabb.minX - 0.001f;
        float startY = (float)aabb.minY - 0.001f;
        float startZ = (float)aabb.minZ - 0.001f;
        float endX = (float)aabb.maxX + 0.001f;
        float endY = (float)aabb.maxY + 0.001f;
        float endZ = (float)aabb.maxZ + 0.001f;
        float red = 0.0f;
        float green = 1.0f;
        float blue = 0.0f;
        float alpha = 0.2f;
        VertexConsumer builder = bufferSource.getBuffer(ModRenderTypes.BLOCK_OVERLAY);
        Matrix4f m4f = poseStack.last().pose();
        builder.addVertex(m4f, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor(red, green, blue, alpha);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(@NotNull ChargingStationBlockEntity blockEntity) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRender(ChargingStationBlockEntity blockEntity, Vec3 pCameraPos) {
        return true;
    }
}

