/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.special;

import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.block.entity.ContainerBlockEntity;
import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.atsuishio.superbwarfare.init.ModTags;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ContainerBlockPreview {
    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        ItemStack item = player.getMainHandItem();
        if (!item.is(ModTags.Items.TOOLS_CROWBAR)) {
            return;
        }
        Level level = player.level();
        Vec3 look = player.getLookAngle();
        int distance = 32;
        Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 end = player.position().add(look.x * (double)distance, look.y * (double)distance + (double)player.getEyeHeight(), look.z * (double)distance);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = player.level().clip(context);
        if (result.getType().equals((Object)HitResult.Type.MISS)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(result.getBlockPos());
        if (!(blockEntity instanceof ContainerBlockEntity)) {
            return;
        }
        ContainerBlockEntity container = (ContainerBlockEntity)blockEntity;
        EntityType<?> entityType = container.entityType;
        int w = 0;
        int h = 0;
        if (entityType != null) {
            w = (int)(entityType.getDimensions().width() / 2.0f + 1.0f);
            h = (int)(entityType.getDimensions().height() + 1.0f);
        }
        if (w == 0 || h == 0) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        BlockPos pos = container.getBlockPos();
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        poseStack.translate((double)pos.getX() - view.x, (double)pos.getY() - view.y + 1.0, (double)pos.getZ() - view.z);
        AABB aabb = new AABB(pos).inflate((double)w, 0.0, (double)w).expandTowards(0.0, (double)(h - 1), 0.0).move(0.0, -1.0, 0.0);
        float startX = (float)aabb.minX - 0.001f - (float)pos.getX();
        float startY = (float)aabb.minY - 0.001f - (float)pos.getY();
        float startZ = (float)aabb.minZ - 0.001f - (float)pos.getZ();
        float endX = (float)aabb.maxX + 0.001f - (float)pos.getX();
        float endY = (float)aabb.maxY + 0.001f - (float)pos.getY();
        float endZ = (float)aabb.maxZ + 0.001f - (float)pos.getZ();
        boolean hasEnoughSpace = ContainerBlock.canOpen(level, pos, entityType);
        int red = hasEnoughSpace ? 0 : 1;
        int green = 1 - red;
        float blue = 0.0f;
        float alpha = 0.2f;
        VertexConsumer builder = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(ModRenderTypes.BLOCK_OVERLAY);
        Matrix4f m4f = poseStack.last().pose();
        builder.addVertex(m4f, startX, startY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, startY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, startY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor((float)red, (float)green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor((float)red, (float)green, blue, alpha);
        poseStack.popPose();
    }
}

