/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens.component;

import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.client.screens.VehicleAssemblingScreen;
import com.atsuishio.superbwarfare.init.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public class RecipeButton
extends Button {
    private final ItemStack stack;
    private boolean isSelected = false;

    public RecipeButton(int x, int y, ItemStack stack, Button.OnPress onPress) {
        super(x, y, 80, 18, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.stack = stack;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Object hoverName;
        pGuiGraphics.pose().pushPose();
        RenderSystem.enableDepthTest();
        if (this.isSelected) {
            if (this.isHoveredOrFocused()) {
                pGuiGraphics.blit(VehicleAssemblingScreen.TEXTURE, this.getX(), this.getY(), 6.0f, 239.0f, this.width, this.height, 356, 356);
            } else {
                pGuiGraphics.blit(VehicleAssemblingScreen.TEXTURE, this.getX(), this.getY(), 6.0f, 220.0f, this.width, this.height, 356, 356);
            }
        } else if (this.isHoveredOrFocused()) {
            pGuiGraphics.blit(VehicleAssemblingScreen.TEXTURE, this.getX(), this.getY(), 6.0f, 201.0f, this.width, this.height, 356, 356);
        } else {
            pGuiGraphics.blit(VehicleAssemblingScreen.TEXTURE, this.getX(), this.getY(), 6.0f, 182.0f, this.width, this.height, 356, 356);
        }
        pGuiGraphics.renderItem(this.stack, this.getX() + 2, this.getY() + 1);
        if (this.stack.is((Item)ModItems.CONTAINER.get())) {
            String key;
            CompoundTag tag;
            CustomData data = (CustomData)this.stack.get(DataComponents.BLOCK_ENTITY_DATA);
            CompoundTag compoundTag = tag = data != null ? data.copyTag() : null;
            hoverName = tag != null && tag.contains("EntityType") ? Component.translatable((String)((key = ContainerBlock.getEntityTranslationKey(tag.getString("EntityType"))) == null ? "des.superbwarfare.container.empty" : key)) : this.stack.getHoverName();
        } else {
            hoverName = this.stack.getHoverName();
        }
        RecipeButton.renderScrollingString((GuiGraphics)pGuiGraphics, (Font)Minecraft.getInstance().font, (Component)hoverName, (int)(this.getX() + 20), (int)(this.getY() + 4), (int)(this.getX() + 78), (int)(this.getY() + 13), (int)0xFFFFFF);
        pGuiGraphics.pose().popPose();
    }

    public void onPress() {
        this.isSelected = true;
        this.onPress.onPress((Button)this);
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public void renderTooltips(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        if (this.isHoveredOrFocused() && !this.stack.isEmpty() && mouseX > this.getX() + 1 && mouseY > this.getY() + 1 && mouseX < this.getX() + this.width - 1 && mouseY < this.getY() + this.height - 1) {
            pGuiGraphics.renderTooltip(Minecraft.getInstance().font, this.stack, mouseX, mouseY);
        }
    }
}

