/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens.modsell;

import com.atsuishio.superbwarfare.client.screens.modsell.TranslationRecord;
import com.atsuishio.superbwarfare.config.client.EnvironmentChecksumConfig;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.multiplayer.WarningScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class ModSellWarningScreen
extends WarningScreen {
    private static final String ENVIRONMENT_CHECKSUM = ModSellWarningScreen.generateEnvironmentHash();
    private final Screen lastScreen;

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return "error";
        }
    }

    private static String generateEnvironmentHash() {
        List<String> environmentInfo = List.of(System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("java.vm.version"), System.getProperty("java.home"), System.getProperty("user.name"), ModSellWarningScreen.getHostName(), "stupidNoPayWarningChecksum");
        return ModSellWarningScreen.sha256(String.join((CharSequence)"|", environmentInfo));
    }

    private static String sha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes());
            return HexFormat.of().formatHex(hash);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return "";
        }
    }

    public ModSellWarningScreen(Screen lastScreen) {
        super((Component)Component.literal((String)TranslationRecord.get(TranslationRecord.TITLE)).withStyle(ChatFormatting.BOLD), (Component)Component.literal((String)TranslationRecord.get(TranslationRecord.CONTENT)), (Component)Component.literal((String)TranslationRecord.get(TranslationRecord.CHECK)), (Component)Component.literal((String)TranslationRecord.get(TranslationRecord.TITLE)).withStyle(ChatFormatting.BOLD).append("\n").append((Component)Component.literal((String)TranslationRecord.get(TranslationRecord.CONTENT))));
        this.lastScreen = lastScreen;
    }

    private AbstractButton createProceedButton(int pYOffset) {
        return Button.builder((Component)CommonComponents.GUI_PROCEED, button -> {
            if (this.stopShowing != null && this.stopShowing.selected()) {
                EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.set((Object)ENVIRONMENT_CHECKSUM);
                EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.save();
            }
            Minecraft.getInstance().setScreen((Screen)new JoinMultiplayerScreen(this.lastScreen));
        }).bounds(this.width / 2 - 155, 100 + pYOffset, 150, 20).build();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onGuiOpen(ScreenEvent.Opening event) {
        if (!(event.getNewScreen() instanceof JoinMultiplayerScreen) && !(event.getNewScreen() instanceof SafetyScreen) || !(event.getCurrentScreen() instanceof TitleScreen)) {
            return;
        }
        if (((String)EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.get()).equals(ENVIRONMENT_CHECKSUM)) {
            return;
        }
        event.setCanceled(true);
        Minecraft.getInstance().setScreen((Screen)new ModSellWarningScreen(event.getCurrentScreen()));
    }

    @NotNull
    protected Layout addFooterButtons() {
        LinearLayout linearlayout = LinearLayout.horizontal().spacing(8);
        linearlayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_PROCEED, p_280872_ -> {
            if (this.stopShowing != null && this.stopShowing.selected()) {
                EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.set((Object)ENVIRONMENT_CHECKSUM);
                EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.save();
            }
            Minecraft.getInstance().setScreen((Screen)new JoinMultiplayerScreen(this.lastScreen));
        }).build());
        linearlayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_329731_ -> this.onClose()).build());
        return linearlayout;
    }
}

