/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.sound;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class HornSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final VehicleEntity entity;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public HornSoundInstance(SoundEvent sound, Minecraft client, VehicleEntity entity) {
        super(sound, SoundSource.PLAYERS, entity.getCommandSenderWorld().getRandom());
        this.client = client;
        this.entity = entity;
        this.looping = true;
        this.delay = 0;
    }

    protected abstract boolean canPlay(VehicleEntity var1);

    protected abstract float getPitch(VehicleEntity var1);

    protected abstract float getVolume(VehicleEntity var1);

    public void tick() {
        LocalPlayer player = this.client.player;
        if (this.entity.isRemoved() || player == null) {
            this.stop();
            return;
        }
        if (!this.canPlay(this.entity)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.stop();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.volume = this.getVolume(this.entity) * (float)this.fade;
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
        this.pitch = this.getPitch(this.entity);
        if (player.getVehicle() != this.entity) {
            double distance = this.entity.position().subtract(player.position()).length();
            this.pitch += (float)(0.1 * Math.atan(this.lastDistance - distance));
            this.lastDistance = distance;
        } else {
            this.lastDistance = 0.0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VehicleHornSound
    extends HornSoundInstance {
        public VehicleHornSound(VehicleEntity entity) {
            super(entity.getHornSound(), Minecraft.getInstance(), entity);
        }

        @Override
        protected boolean canPlay(VehicleEntity entity) {
            return entity.hornWorking();
        }

        @Override
        protected float getPitch(VehicleEntity entity) {
            return 1.0f;
        }

        @Override
        protected float getVolume(VehicleEntity entity) {
            return ((Float)entity.getEntityData().get(VehicleEntity.HORN_VOLUME)).floatValue();
        }
    }
}

