/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.command;

import com.atsuishio.superbwarfare.world.TDMSavedData;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class TDMCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tdm").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"entity");
            TDMSavedData tdm = (TDMSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(TDMSavedData::new, TDMSavedData::load, null), "superbwarfare_tdm");
            entities.forEach(entity -> tdm.addEntity(entity.getStringUUID()));
            tdm.sync();
            if (entities.size() == 1) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.tdm.add.single", (Object[])new Object[]{entities.iterator().next()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.tdm.add.multiple", (Object[])new Object[]{entities.size()}), true);
            }
            return 0;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"entity");
            TDMSavedData tdm = (TDMSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(TDMSavedData::new, TDMSavedData::load, null), "superbwarfare_tdm");
            entities.forEach(entity -> tdm.removeEntity(entity.getStringUUID()));
            tdm.sync();
            if (entities.size() == 1) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.tdm.remove.single", (Object[])new Object[]{entities.iterator().next()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.tdm.remove.multiple", (Object[])new Object[]{entities.size()}), true);
            }
            return 0;
        })));
    }
}

